/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.report;

import com.bstek.urule.console.database.manager.report.PacketDeployVO;
import com.bstek.urule.console.database.model.FileInfo;
import com.bstek.urule.console.database.model.PacketDeploy;
import com.bstek.urule.console.database.model.RuleFile;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class ReportProjectQuery {
    public static List<RuleFile> listLastModifyFiles(Long l) {
        Connection connection = JdbcUtils.getConnection();
        String string = "select URULE_FILE.ID_, URULE_FILE.NAME_, URULE_FILE.TYPE_, URULE_FILE.UPDATE_USER_, URULE_FILE.UPDATE_DATE_, URULE_FILE.PROJECT_ID_ from URULE_FILE";
        string = string + " where URULE_FILE.PROJECT_ID_=? order by URULE_FILE.UPDATE_DATE_ DESC";
        try {
            Object object;
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new RuleFile();
                ((FileInfo)object).setId(resultSet.getLong(1));
                ((FileInfo)object).setName(resultSet.getString(2));
                ((RuleFile)object).setType(resultSet.getString(3));
                ((RuleFile)object).setUpdateUser(resultSet.getString(4));
                ((FileInfo)object).setCreateUser(resultSet.getString(4));
                ((RuleFile)object).setModifyDate(resultSet.getDate(5));
                ((RuleFile)object).setProjectId(resultSet.getLong(6));
                arrayList.add(object);
            }
            JdbcUtils.closeStatement(preparedStatement);
            object = arrayList;
            return object;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    public static List<PacketDeployVO> listPacketDeploys(Long l) {
        Connection connection = JdbcUtils.getConnection();
        String string = "SELECT URULE_DEPLOYED_PACKET.ID_, URULE_DEPLOYED_PACKET.PACKET_ID_, URULE_PACKET.NAME_, URULE_DEPLOYED_PACKET.DESC_, URULE_DEPLOYED_PACKET.CREATE_USER_, URULE_DEPLOYED_PACKET.CREATE_DATE_ from URULE_DEPLOYED_PACKET";
        string = string + " LEFT JOIN URULE_PACKET ON URULE_PACKET.ID_=URULE_DEPLOYED_PACKET.PACKET_ID_";
        string = string + " WHERE URULE_DEPLOYED_PACKET.PROJECT_ID_=? order by URULE_DEPLOYED_PACKET.CREATE_DATE_ DESC";
        try {
            Object object;
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new PacketDeployVO();
                ((PacketDeploy)object).setId(resultSet.getLong(1));
                ((PacketDeploy)object).setPacketId(resultSet.getLong(2));
                ((PacketDeployVO)object).setPacketName(resultSet.getString(3));
                ((PacketDeploy)object).setDesc(resultSet.getString(4));
                ((PacketDeploy)object).setCreateUser(resultSet.getString(4));
                ((PacketDeploy)object).setCreateDate(resultSet.getTimestamp(5));
                arrayList.add(object);
            }
            JdbcUtils.closeStatement(preparedStatement);
            object = arrayList;
            return object;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    public static List<LinkedHashMap<String, Object>> countUserRuleFiles(Long l) {
        Connection connection = JdbcUtils.getConnection();
        String string = "select URULE_FILE.CREATE_USER_, COUNT(URULE_FILE.ID_) from URULE_FILE";
        string = string + " where URULE_FILE.PROJECT_ID_=? and URULE_FILE.DELETED_=?";
        string = string + " GROUP BY URULE_FILE.CREATE_USER_";
        try {
            Cloneable cloneable;
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.setBoolean(2, false);
            ArrayList<Cloneable> arrayList = new ArrayList<Cloneable>();
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                cloneable = new LinkedHashMap();
                ((HashMap)cloneable).put("createUser", resultSet.getString(1));
                ((HashMap)cloneable).put("count", resultSet.getInt(2));
                arrayList.add(cloneable);
            }
            JdbcUtils.closeStatement(preparedStatement);
            cloneable = arrayList;
            return cloneable;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    public static int countFile(Long l) {
        int n = 0;
        Connection connection = JdbcUtils.getConnection();
        String string = "select count(URULE_FILE.ID_) from URULE_FILE";
        string = string + " where URULE_FILE.PROJECT_ID_=?";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            JdbcUtils.closeStatement(preparedStatement);
            int n2 = n;
            return n2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    public static int countPacket(Long l) {
        int n = 0;
        Connection connection = JdbcUtils.getConnection();
        String string = "select count(URULE_PACKET.ID_) from URULE_PACKET";
        string = string + " where URULE_PACKET.PROJECT_ID_=?";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            JdbcUtils.closeStatement(preparedStatement);
            int n2 = n;
            return n2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    public static int countBatch(Long l) {
        int n = 0;
        Connection connection = JdbcUtils.getConnection();
        String string = "select count(URULE_BATCH.ID_) from URULE_BATCH";
        string = string + " where URULE_BATCH.PROJECT_ID_=?";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            JdbcUtils.closeStatement(preparedStatement);
            int n2 = n;
            return n2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    public static List<LinkedHashMap<String, Object>> countUserLogin(Long l, Date date, Date date2) {
        int n = ReportProjectQuery.a(date, date2);
        if (n > 31) {
            throw new RuleException("\u65e0\u6cd5\u7edf\u8ba1\u8d85\u8fc7\u4e00\u4e2a\u6708\u7684\u6570\u636e");
        }
        ArrayList<LinkedHashMap<String, Object>> arrayList = new ArrayList<LinkedHashMap<String, Object>>();
        Date date3 = new Date(date.getTime());
        Connection connection = JdbcUtils.getConnection();
        String string = "select count(URULE_LOG_USERLOGIN.ID_) from URULE_LOG_USERLOGIN";
        string = string + " left join URULE_PROJECT_USER on URULE_PROJECT_USER.USER_ID_=URULE_LOG_USERLOGIN.USER_ID_";
        string = string + " where URULE_PROJECT_USER.PROJECT_ID_=? and URULE_LOG_USERLOGIN.CREATE_DATE_>? and URULE_LOG_USERLOGIN.CREATE_DATE_<?";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            for (int i = 0; i < n; ++i) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date3);
                calendar.add(6, 1);
                Date date4 = calendar.getTime();
                int n2 = 0;
                preparedStatement.setLong(1, l);
                preparedStatement.setTimestamp(2, new Timestamp(date3.getTime()));
                preparedStatement.setTimestamp(3, new Timestamp(date4.getTime()));
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n2 = resultSet.getInt(1);
                }
                LinkedHashMap<String, Comparable<Integer>> linkedHashMap = new LinkedHashMap<String, Comparable<Integer>>();
                linkedHashMap.put("count", Integer.valueOf(n2));
                linkedHashMap.put("loginDate", date3);
                arrayList.add(linkedHashMap);
                date3 = calendar.getTime();
            }
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
        return arrayList;
    }

    private static int a(Date date, Date date2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        int n = calendar.get(6);
        int n2 = calendar2.get(6);
        int n3 = calendar.get(1);
        int n4 = calendar2.get(1);
        if (n3 != n4) {
            int n5 = 0;
            for (int i = n3; i < n4; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    n5 += 366;
                    continue;
                }
                n5 += 365;
            }
            return n5 + (n2 - n);
        }
        return n2 - n;
    }
}

