/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.url;

import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.url.UrlManager;
import com.bstek.urule.console.database.manager.url.UrlQuery;
import com.bstek.urule.console.database.manager.url.UrlQueryImpl;
import com.bstek.urule.console.database.model.UrlConfig;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

public class UrlManagerImpl
implements UrlManager {
    protected UrlManagerImpl() {
    }

    @Override
    public void add(UrlConfig urlConfig) {
        Connection connection = JdbcUtils.getConnection();
        try {
            urlConfig.setCreateDate(new Date());
            urlConfig.setUpdateDate(new Date());
            urlConfig.setId(IDGenerator.getInstance().nextId(IDType.URL_CONFIG));
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_URL_CONFIG (ID_, NAME_,URL_, TYPE_, GROUP_ID_, CREATE_DATE_, UPDATE_DATE_,CREATE_USER_,UPDATE_USER_) values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement.setLong(1, urlConfig.getId());
            preparedStatement.setString(2, urlConfig.getName());
            preparedStatement.setString(3, urlConfig.getUrl());
            preparedStatement.setString(4, urlConfig.getType().name());
            preparedStatement.setString(5, urlConfig.getGroupId());
            preparedStatement.setTimestamp(6, new Timestamp(urlConfig.getCreateDate().getTime()));
            preparedStatement.setTimestamp(7, new Timestamp(urlConfig.getUpdateDate().getTime()));
            preparedStatement.setString(8, urlConfig.getCreateUser());
            preparedStatement.setString(9, urlConfig.getCreateUser());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void delete(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_URL_CONFIG where ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void update(UrlConfig urlConfig) {
        Connection connection = JdbcUtils.getConnection();
        try {
            urlConfig.setUpdateDate(new Date());
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_URL_CONFIG set NAME_=?, URL_=?, UPDATE_DATE_=? , UPDATE_USER_=? where ID_=?");
            preparedStatement.setString(1, urlConfig.getName());
            preparedStatement.setString(2, urlConfig.getUrl());
            preparedStatement.setTimestamp(3, new Timestamp(urlConfig.getUpdateDate().getTime()));
            preparedStatement.setString(4, urlConfig.getUpdateUser());
            preparedStatement.setLong(5, urlConfig.getId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public UrlConfig load(long l) {
        List<UrlConfig> list = this.newQuery().id(l).list();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public UrlQuery newQuery() {
        return new UrlQueryImpl();
    }
}

