/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.user;

import com.bstek.urule.console.database.manager.user.UserManager;
import com.bstek.urule.console.database.manager.user.UserQuery;
import com.bstek.urule.console.database.manager.user.UserQueryImpl;
import com.bstek.urule.console.database.model.User;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class UserManagerImpl
implements UserManager {
    @Override
    public void add(User user) {
        Connection connection = JdbcUtils.getConnection();
        try {
            user.setCreateDate(new Timestamp(System.currentTimeMillis()));
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_USER (ID_, NAME_, PASSWORD_, EMAIL_, DESC_, CREATE_USER_,CREATE_DATE_) values (?, ?, ?, ?, ?,?, ?)");
            preparedStatement.setString(1, user.getId());
            preparedStatement.setString(2, user.getName());
            preparedStatement.setString(3, user.getPassword());
            preparedStatement.setString(4, user.getEmail());
            preparedStatement.setString(5, user.getDesc());
            preparedStatement.setString(6, user.getCreateUser());
            preparedStatement.setTimestamp(7, new Timestamp(user.getCreateDate().getTime()));
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void update(User user) {
        Connection connection = JdbcUtils.getConnection();
        try {
            user.setUpdateDate(new Timestamp(System.currentTimeMillis()));
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_USER set PASSWORD_=?, EMAIL_=?, SECRET_KEY_=?, DESC_=?, UPDATE_DATE_=?, EXPIR_DATE_=?, UPDATE_USER_=?, NAME_=?  where ID_=?");
            preparedStatement.setString(1, user.getPassword());
            preparedStatement.setString(2, user.getEmail());
            preparedStatement.setString(3, user.getSecretKey());
            preparedStatement.setString(4, user.getDesc());
            preparedStatement.setTimestamp(5, new Timestamp(user.getUpdateDate().getTime()));
            preparedStatement.setTimestamp(6, user.getExpirDate() == null ? null : new Timestamp(user.getExpirDate().getTime()));
            preparedStatement.setString(7, user.getId());
            preparedStatement.setString(8, user.getName());
            preparedStatement.setString(9, user.getUpdateUser());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void remove(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_USER where ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public User get(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string2 = "select ID_, NAME_, PASSWORD_, EMAIL_, SECRET_KEY_, DESC_, EXPIR_DATE_, CREATE_DATE_, UPDATE_DATE_ from URULE_USER where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            User user = null;
            if (resultSet.next()) {
                user = new User();
                user.setId(resultSet.getString(1));
                user.setName(resultSet.getString(2));
                user.setPassword(resultSet.getString(3));
                user.setEmail(resultSet.getString(4));
                user.setSecretKey(resultSet.getString(5));
                user.setDesc(resultSet.getString(6));
                user.setExpirDate(resultSet.getTimestamp(7));
                user.setCreateDate(resultSet.getTimestamp(8));
                user.setUpdateDate(resultSet.getTimestamp(9));
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            User user2 = user;
            return user2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void changePassword(String string, String string2) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string3 = "update URULE_USER set PASSWORD_=? where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public List<User> getUsersByGroupId(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            Object object;
            String string2 = "select URULE_USER.ID_, URULE_USER.NAME_, URULE_USER.PASSWORD_, URULE_USER.EMAIL_, URULE_USER.SECRET_KEY_, URULE_USER.DESC_, URULE_USER.EXPIR_DATE_, URULE_USER.CREATE_DATE_, URULE_USER.UPDATE_DATE_ from URULE_USER left join URULE_GROUP_USER on URULE_USER.ID_=URULE_GROUP_USER.USER_ID_  where URULE_GROUP_USER.GROUP_ID_ = ?";
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (resultSet.next()) {
                object = new User();
                ((User)object).setId(resultSet.getString(1));
                ((User)object).setName(resultSet.getString(2));
                ((User)object).setEmail(resultSet.getString(3));
                ((User)object).setSecretKey(resultSet.getString(4));
                ((User)object).setEnable(resultSet.getBoolean(5));
                ((User)object).setDesc(resultSet.getString(6));
                ((User)object).setExpirDate(resultSet.getTimestamp(7));
                ((User)object).setCreateDate(resultSet.getTimestamp(8));
                ((User)object).setUpdateDate(resultSet.getTimestamp(9));
                arrayList.add(object);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            object = arrayList;
            return object;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public List<User> getUsersByRoleId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            Object object;
            String string = "select URULE_USER.ID_, URULE_USER.NAME_, URULE_USER.PASSWORD_, URULE_USER.EMAIL_, URULE_USER.SECRET_KEY_, URULE_USER.DESC_, URULE_USER.EXPIR_DATE_, URULE_USER.CREATE_DATE_, URULE_USER.UPDATE_DATE_ from URULE_USER left join URULE_GROUP_USER_ROLE on URULE_USER.ID_=URULE_GROUP_USER_ROLE.USER_ID_  where URULE_GROUP_USER_ROLE.ROLE_ID_ = ?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (resultSet.next()) {
                object = new User();
                ((User)object).setId(resultSet.getString(1));
                ((User)object).setName(resultSet.getString(2));
                ((User)object).setEmail(resultSet.getString(3));
                ((User)object).setSecretKey(resultSet.getString(4));
                ((User)object).setEnable(resultSet.getBoolean(5));
                ((User)object).setDesc(resultSet.getString(6));
                ((User)object).setExpirDate(resultSet.getTimestamp(7));
                ((User)object).setCreateDate(resultSet.getTimestamp(8));
                ((User)object).setUpdateDate(resultSet.getTimestamp(9));
                arrayList.add(object);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            object = arrayList;
            return object;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public List<User> getUsersByProjectId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            Object object;
            String string = "select URULE_USER.ID_, NAME_, PASSWORD_, EMAIL_, SECRET_KEY_, DESC_, EXPIR_DATE_, URULE_PROJECT_USER.CREATE_DATE_, UPDATE_DATE_ from URULE_USER left join URULE_PROJECT_USER on URULE_USER.ID_=URULE_PROJECT_USER.USER_ID_  where URULE_PROJECT_USER.PROJECT_ID_=? order by URULE_PROJECT_USER.CREATE_DATE_";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (resultSet.next()) {
                object = new User();
                ((User)object).setId(resultSet.getString(1));
                ((User)object).setName(resultSet.getString(2));
                ((User)object).setEmail(resultSet.getString(3));
                ((User)object).setSecretKey(resultSet.getString(4));
                ((User)object).setEnable(resultSet.getBoolean(5));
                ((User)object).setDesc(resultSet.getString(6));
                ((User)object).setExpirDate(resultSet.getTimestamp(7));
                ((User)object).setCreateDate(resultSet.getTimestamp(8));
                ((User)object).setUpdateDate(resultSet.getTimestamp(9));
                arrayList.add(object);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            object = arrayList;
            return object;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public User getByEmail(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string2 = "select ID_, NAME_, PASSWORD_, EMAIL_, SECRET_KEY_, DESC_, EXPIR_DATE_, CREATE_DATE_, UPDATE_DATE_ from URULE_USER where EMAIL_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            User user = null;
            if (resultSet.next()) {
                user = new User();
                user.setId(resultSet.getString(1));
                user.setName(resultSet.getString(2));
                user.setPassword(resultSet.getString(3));
                user.setEmail(resultSet.getString(4));
                user.setSecretKey(resultSet.getString(5));
                user.setDesc(resultSet.getString(6));
                user.setExpirDate(resultSet.getTimestamp(7));
                user.setCreateDate(resultSet.getTimestamp(8));
                user.setUpdateDate(resultSet.getTimestamp(9));
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            User user2 = user;
            return user2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public UserQuery newQuery() {
        return new UserQueryImpl();
    }

    @Override
    public User getGroupUser(String string, String string2) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string3 = "select USER_ID_, USER_NAME_ from URULE_GROUP_USER where GROUP_ID_=? and USER_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            User user = null;
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                user = new User();
                user.setId(resultSet.getString(1));
                user.setName(resultSet.getString(2));
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            User user2 = user;
            return user2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public User getProjectUser(long l, String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string2 = "select USER_ID_, USER_NAME_ from URULE_PROJECT_USER where PROJECT_ID_=? and USER_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            User user = null;
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                user = new User();
                user.setId(resultSet.getString(1));
                user.setName(resultSet.getString(2));
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            User user2 = user;
            return user2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void changeEmail(String string, String string2) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string3 = "update URULE_USER set EMAIL_=? where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }
}

