/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.model.datasource;

import com.bstek.urule.console.util.Tools;
import java.math.BigDecimal;

public enum FieldType {
    String,
    Integer,
    Double,
    Long,
    Float,
    BigDecimal,
    Short,
    Boolean,
    Date,
    Other;


    public Object parseValue(String string) {
        if (string == null) {
            return null;
        }
        switch (this) {
            case BigDecimal: {
                return Tools.toBigDecimal(string);
            }
            case Boolean: {
                if (string.contentEquals("1")) {
                    return true;
                }
                if (string.contentEquals("0")) {
                    return false;
                }
                return java.lang.Boolean.valueOf(string);
            }
            case Date: {
                return Tools.toDateOrDatatime(string);
            }
            case Double: {
                BigDecimal bigDecimal = Tools.toBigDecimal(string);
                return bigDecimal.doubleValue();
            }
            case Long: {
                return Tools.toBigDecimal(string).longValue();
            }
            case Float: {
                BigDecimal bigDecimal = Tools.toBigDecimal(string);
                return java.lang.Float.valueOf(bigDecimal.floatValue());
            }
            case Integer: {
                BigDecimal bigDecimal = Tools.toBigDecimal(string);
                return bigDecimal.intValue();
            }
            case Short: {
                BigDecimal bigDecimal = Tools.toBigDecimal(string);
                return bigDecimal.shortValue();
            }
            case String: {
                return string;
            }
            case Other: {
                return string;
            }
        }
        return string;
    }
}

