/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.service.file;

import com.bstek.urule.builder.resource.ResourceType;
import com.bstek.urule.console.database.manager.file.DirectoryManager;
import com.bstek.urule.console.database.manager.file.FileManager;
import com.bstek.urule.console.database.manager.file.version.VersionFileManager;
import com.bstek.urule.console.database.model.RuleFile;
import com.bstek.urule.console.database.service.file.FileService;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.console.type.RuleFileType;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;

public class FileServiceImpl
implements FileService {
    @Override
    public List<RuleFile> tree(Long l, RuleFileType ruleFileType) {
        return this.tree(l, 0L, ruleFileType.name());
    }

    @Override
    public void removeDir(RuleFile ruleFile) {
        List<RuleFile> list = this.tree(ruleFile.getProjectId(), ruleFile.getId(), ruleFile.getType());
        for (RuleFile ruleFile2 : list) {
            if (ruleFile2.isDirectory()) {
                this.a(ruleFile2);
                continue;
            }
            VersionFileManager.ins.deleteByFileId(ruleFile2.getId());
            FileManager.ins.remove(ruleFile2.getId());
        }
        DirectoryManager.ins.remove(ruleFile.getId());
    }

    private void a(RuleFile ruleFile) {
        for (RuleFile ruleFile2 : ruleFile.getChildren()) {
            if (ruleFile2.isDirectory()) {
                this.a(ruleFile2);
                continue;
            }
            VersionFileManager.ins.deleteByFileId(ruleFile2.getId());
            FileManager.ins.remove(ruleFile2.getId());
        }
        DirectoryManager.ins.remove(ruleFile.getId());
    }

    @Override
    public List<RuleFile> tree(Long l, Long l2, String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            List<RuleFile> list = DirectoryManager.ins.list(l, l2, string);
            for (RuleFile object2 : list) {
                List<RuleFile> list2 = this.tree(l, object2.getId(), string);
                object2.setChildren(list2);
            }
            List<RuleFile> list3 = FileManager.ins.list(l, l2, string);
            list3.addAll(list);
            List<RuleFile> list4 = list3;
            return list4;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void updateFileDeleteFlag(Long l, boolean bl, String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            RuleFile ruleFile = FileManager.ins.get(l);
            if (ruleFile != null) {
                FileManager.ins.updateDeleteFlag(l, bl, string);
                if (!bl && ruleFile.getParentId() > 0L) {
                    DirectoryManager.ins.updateDeleteFlag(ruleFile.getParentId(), false, string);
                }
            }
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public List<RuleFile> menus(Long l) {
        ArrayList<RuleFile> arrayList = new ArrayList<RuleFile>();
        RuleFile ruleFile = new RuleFile();
        ruleFile.setName("\u5e93\u6587\u4ef6");
        ruleFile.setDirectory(true);
        ruleFile.setId(0L);
        ruleFile.setProjectId(l);
        ruleFile.setType(ResourceType.Library.name());
        ruleFile.setVirtual(true);
        ruleFile.setChildren(new ArrayList<RuleFile>());
        arrayList.add(ruleFile);
        ruleFile = new RuleFile();
        ruleFile.setName("\u51b3\u7b56\u96c6");
        ruleFile.setDirectory(true);
        ruleFile.setId(0L);
        ruleFile.setProjectId(l);
        ruleFile.setType(ResourceType.RuleSet.name());
        ruleFile.setVirtual(true);
        ruleFile.setChildren(new ArrayList<RuleFile>());
        arrayList.add(ruleFile);
        ruleFile = new RuleFile();
        ruleFile.setName("\u51b3\u7b56\u8868");
        ruleFile.setDirectory(true);
        ruleFile.setId(0L);
        ruleFile.setProjectId(l);
        ruleFile.setType(ResourceType.DecisionTable.name());
        ruleFile.setVirtual(true);
        ruleFile.setChildren(new ArrayList<RuleFile>());
        arrayList.add(ruleFile);
        ruleFile = new RuleFile();
        ruleFile.setName("\u51b3\u7b56\u6811");
        ruleFile.setDirectory(true);
        ruleFile.setId(0L);
        ruleFile.setProjectId(l);
        ruleFile.setType(ResourceType.DecisionTree.name());
        ruleFile.setVirtual(true);
        ruleFile.setChildren(new ArrayList<RuleFile>());
        arrayList.add(ruleFile);
        ruleFile = new RuleFile();
        ruleFile.setName("\u8bc4\u5206\u5361");
        ruleFile.setDirectory(true);
        ruleFile.setId(0L);
        ruleFile.setProjectId(l);
        ruleFile.setType(ResourceType.Scorecard.name());
        ruleFile.setVirtual(true);
        ruleFile.setChildren(new ArrayList<RuleFile>());
        arrayList.add(ruleFile);
        ruleFile = new RuleFile();
        ruleFile.setName("\u51b3\u7b56\u6d41");
        ruleFile.setDirectory(true);
        ruleFile.setId(0L);
        ruleFile.setProjectId(l);
        ruleFile.setType(ResourceType.Flow.name());
        ruleFile.setVirtual(true);
        ruleFile.setChildren(new ArrayList<RuleFile>());
        arrayList.add(ruleFile);
        ruleFile = new RuleFile();
        ruleFile.setName("\u6761\u4ef6\u6a21\u7248");
        ruleFile.setDirectory(true);
        ruleFile.setId(0L);
        ruleFile.setProjectId(l);
        ruleFile.setType(ResourceType.ConditionTemplate.name());
        ruleFile.setVirtual(true);
        ruleFile.setChildren(new ArrayList<RuleFile>());
        arrayList.add(ruleFile);
        ruleFile = new RuleFile();
        ruleFile.setName("\u52a8\u4f5c\u6a21\u7248");
        ruleFile.setDirectory(true);
        ruleFile.setId(0L);
        ruleFile.setProjectId(l);
        ruleFile.setType(ResourceType.ActionTemplate.name());
        ruleFile.setVirtual(true);
        ruleFile.setChildren(new ArrayList<RuleFile>());
        arrayList.add(ruleFile);
        return arrayList;
    }
}

