/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.service.group;

import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.RequestHolder;
import com.bstek.urule.console.config.Configure;
import com.bstek.urule.console.database.manager.authority.AuthorityManager;
import com.bstek.urule.console.database.manager.authority.AuthorityService;
import com.bstek.urule.console.database.manager.group.GroupManager;
import com.bstek.urule.console.database.manager.group.role.GroupRoleManager;
import com.bstek.urule.console.database.manager.invite.InviteManager;
import com.bstek.urule.console.database.manager.log.OperationLogManager;
import com.bstek.urule.console.database.manager.project.ProjectManager;
import com.bstek.urule.console.database.manager.project.role.ProjectRoleManager;
import com.bstek.urule.console.database.manager.user.UserManager;
import com.bstek.urule.console.database.model.Group;
import com.bstek.urule.console.database.model.GroupRole;
import com.bstek.urule.console.database.model.Project;
import com.bstek.urule.console.database.model.Role;
import com.bstek.urule.console.database.model.User;
import com.bstek.urule.console.database.service.group.GroupService;
import com.bstek.urule.console.database.service.group.role.GroupRoleService;
import com.bstek.urule.console.database.service.project.ProjectService;
import com.bstek.urule.console.database.service.user.UserServiceManager;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.security.entity.Module;
import com.bstek.urule.console.security.entity.Permission;
import com.bstek.urule.console.security.provider.PermissionProvider;
import com.bstek.urule.console.type.GroupRoleEnum;
import com.bstek.urule.console.type.RoleCategory;
import java.util.Iterator;
import java.util.List;

public class GroupServiceImpl
implements GroupService {
    @Override
    public boolean isFreeCreate(String string) {
        boolean bl = Configure.getConfigure().isFreeCreateGroup();
        int n = GroupManager.ins.count();
        boolean bl2 = false;
        List<Group> list = GroupManager.ins.createQuery().list(string);
        for (Group group : list) {
            if (!string.equals(group.getCreateUser())) continue;
            bl2 = true;
        }
        if (!bl && (n == 0 || bl2)) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void add(Group group) {
        com.bstek.urule.console.security.entity.User user = SecurityUtils.getLoginUser(RequestHolder.getRequest());
        if (!this.isFreeCreate(user.getName())) {
            boolean bl = false;
            for (Group object : user.getGroups()) {
                if (!user.getName().equals(object.getCreateUser())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new InfoException("\u6743\u9650\u4e0d\u8db3\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c.<br/>You are not authorized to do this action.");
            }
        }
        try {
            Group group2 = GroupManager.ins.get(group.getId());
            if (null != group2) {
                throw new InfoException("\u56e2\u961f\u7f16\u53f7\u91cd\u590d.<br/>Duplicate team id.");
            }
            List<Group> list = GroupManager.ins.createQuery().name(group.getName()).list();
            if (list.size() > 0) {
                throw new InfoException("\u56e2\u961f\u540d\u79f0\u91cd\u590d.<br/>Duplicate team name.");
            }
            GroupManager.ins.add(group);
            User user2 = UserServiceManager.getUserService().get(group.getCreateUser());
            GroupManager.ins.addGroupUser(group.getId(), group.getCreateUser(), user2.getName());
            for (GroupRoleEnum groupRoleEnum : GroupRoleEnum.values()) {
                GroupRole groupRole = new GroupRole();
                groupRole.setGroupId(group.getId());
                groupRole.setType("system");
                groupRole.setName(groupRoleEnum.name());
                groupRole.setCreateUser(group.getCreateUser());
                GroupRoleManager.ins.add(groupRole);
                this.a(groupRole);
                if (GroupRoleEnum.Owner != groupRoleEnum) continue;
                GroupRoleService.ins.addUserRole(group.getId(), group.getCreateUser(), groupRole.getId());
            }
        }
        catch (Exception exception) {
            throw new InfoException(exception);
        }
    }

    private void a(GroupRole groupRole) {
        if (GroupRoleEnum.Owner.name().equals(groupRole.getName())) {
            return;
        }
        List<Module> list = PermissionProvider.getGroupModules();
        for (Module module : list) {
            for (Permission permission : module.getItems()) {
                boolean bl = false;
                for (String string : permission.getRoles()) {
                    if (!string.equals(groupRole.getName())) continue;
                    bl = true;
                }
                permission.setChecked(bl);
                permission.setDisabled(false);
            }
        }
        AuthorityService.ins.initPermissions(groupRole.getId(), list);
    }

    @Override
    public void remove(String string) {
        try {
            OperationLogManager.ins.removeByGroupId(string);
            List<Project> list = ProjectManager.ins.getProjectsByGroupId(string);
            for (Project object2 : list) {
                ProjectService.ins.remove(object2.getId());
            }
            InviteManager.ins.removeByGroupId(string);
            List<Role> list2 = GroupRoleManager.ins.loadRoles(string);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Role role = (Role)iterator.next();
                AuthorityManager.ins.removeByRole(RoleCategory.group.name(), role.getId());
            }
            GroupRoleManager.ins.removeByGroupId(string);
            GroupManager.ins.removeGroupUsers(string);
            GroupManager.ins.remove(string);
        }
        catch (Exception exception) {
            throw new InfoException(exception);
        }
    }

    @Override
    public void addGroupUser(String string, String string2) {
        User user = UserManager.ins.getGroupUser(string, string2);
        if (user == null) {
            User user2 = UserServiceManager.getUserService().get(string2);
            GroupManager.ins.addGroupUser(string, string2, user2.getName());
            GroupRole groupRole = GroupRoleManager.ins.get(string, GroupRoleEnum.User.name());
            if (groupRole != null) {
                GroupRoleService.ins.addUserRole(string, string2, groupRole.getId());
            }
        }
    }

    @Override
    public void removeGroupUser(String string, String string2) {
        List<Project> list = ProjectManager.ins.getProjectsByGroupId(string);
        for (Project project : list) {
            ProjectRoleManager.ins.removeUserRoles(string2);
            ProjectManager.ins.removeProjectUser(project.getId(), string2);
        }
        GroupRoleManager.ins.removeUserRoles(string, string2);
        GroupManager.ins.removeGroupUser(string, string2);
    }

    @Override
    public Group get(String string) {
        return GroupManager.ins.get(string);
    }
}

