/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.service.group.role;

import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.admin.group.GroupRoleVO;
import com.bstek.urule.console.database.manager.group.role.GroupRoleManager;
import com.bstek.urule.console.database.model.GroupRole;
import com.bstek.urule.console.database.model.Role;
import com.bstek.urule.console.database.model.User;
import com.bstek.urule.console.database.service.group.role.GroupRoleService;
import com.bstek.urule.console.database.service.user.UserServiceManager;
import com.bstek.urule.console.type.GroupRoleEnum;
import java.util.ArrayList;
import java.util.List;

public class GroupRoleServiceImpl
implements GroupRoleService {
    @Override
    public List<Role> loadRoles(String string) throws Exception {
        return GroupRoleManager.ins.loadRoles(string);
    }

    @Override
    public List<GroupRoleVO> loadUserRoles(String string, String string2) throws Exception {
        List<Role> list = GroupRoleManager.ins.loadRoles(string);
        List<Role> list2 = GroupRoleManager.ins.loadUserRoles(string, string2);
        ArrayList<GroupRoleVO> arrayList = new ArrayList<GroupRoleVO>();
        for (Role role : list) {
            GroupRoleVO groupRoleVO = new GroupRoleVO();
            groupRoleVO.setId(role.getId());
            groupRoleVO.setName(role.getName());
            groupRoleVO.setType(role.getType());
            for (Role role2 : list2) {
                if (role2.getId() != role.getId()) continue;
                groupRoleVO.setSelected(true);
                break;
            }
            arrayList.add(groupRoleVO);
        }
        return arrayList;
    }

    @Override
    public void add(GroupRole groupRole) throws Exception {
        if (GroupRoleManager.ins.checkExist(groupRole.getGroupId(), groupRole.getName())) {
            throw new InfoException("Duplicate role name!");
        }
        GroupRoleManager.ins.add(groupRole);
    }

    @Override
    public void update(GroupRole groupRole) throws Exception {
        if (GroupRoleManager.ins.checkExist(groupRole.getGroupId(), groupRole.getName())) {
            throw new InfoException("Duplicate role name!");
        }
        GroupRoleManager.ins.update(groupRole);
    }

    @Override
    public void remove(Long l) throws Exception {
        GroupRoleManager.ins.remove(l);
    }

    @Override
    public void addUserRole(String string, String string2, long l) {
        if (GroupRoleManager.ins.getUserRole(string2, l) == null) {
            GroupRoleManager.ins.addUserRole(string, string2, l);
        }
    }

    @Override
    public void removeUserRole(String string, String string2, long l) throws Exception {
        GroupRole groupRole = GroupRoleManager.ins.get(l);
        if (groupRole.getName().equals(GroupRoleEnum.Owner.name())) {
            throw new InfoException("\u7cfb\u7edf\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c!");
        }
        GroupRoleManager.ins.removeUserRole(string, string2, l);
    }

    @Override
    public GroupRole get(long l) throws Exception {
        return GroupRoleManager.ins.get(l);
    }

    @Override
    public List<User> users(String string, long l) throws Exception {
        List<User> list = GroupRoleManager.ins.loadRoleUsers(string, l);
        ArrayList<User> arrayList = new ArrayList<User>();
        for (User user : list) {
            arrayList.add(UserServiceManager.getUserService().get(user.getId()));
        }
        return null;
    }
}

