/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.service.project;

import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.cache.packet.PacketCache;
import com.bstek.urule.console.database.manager.authority.AuthorityManager;
import com.bstek.urule.console.database.manager.authority.AuthorityService;
import com.bstek.urule.console.database.manager.batch.BatchManagerHelper;
import com.bstek.urule.console.database.manager.file.DirectoryManager;
import com.bstek.urule.console.database.manager.file.FileCountQuery;
import com.bstek.urule.console.database.manager.file.FileManager;
import com.bstek.urule.console.database.manager.file.version.VersionFileManager;
import com.bstek.urule.console.database.manager.log.KnowledgeLogCountQuery;
import com.bstek.urule.console.database.manager.log.KnowledgeLogManager;
import com.bstek.urule.console.database.manager.log.OperationLogManager;
import com.bstek.urule.console.database.manager.packet.PacketManager;
import com.bstek.urule.console.database.manager.packet.apply.PacketApplyManager;
import com.bstek.urule.console.database.manager.packet.apply.PacketApplyQuery;
import com.bstek.urule.console.database.manager.packet.deploy.PacketDeployManager;
import com.bstek.urule.console.database.manager.packet.scenario.ScenarioManager;
import com.bstek.urule.console.database.manager.project.ProjectManager;
import com.bstek.urule.console.database.manager.project.role.ProjectRoleManager;
import com.bstek.urule.console.database.manager.user.UserManager;
import com.bstek.urule.console.database.model.ApplyStatus;
import com.bstek.urule.console.database.model.ApplyType;
import com.bstek.urule.console.database.model.PacketApply;
import com.bstek.urule.console.database.model.Project;
import com.bstek.urule.console.database.model.ProjectRole;
import com.bstek.urule.console.database.model.Role;
import com.bstek.urule.console.database.model.RuleFile;
import com.bstek.urule.console.database.model.User;
import com.bstek.urule.console.database.service.project.ProjectService;
import com.bstek.urule.console.database.service.project.role.ProjectRoleService;
import com.bstek.urule.console.database.service.user.UserServiceManager;
import com.bstek.urule.console.database.vo.RuleCommitVO;
import com.bstek.urule.console.database.vo.RuleDeployVO;
import com.bstek.urule.console.database.vo.RuleExecVO;
import com.bstek.urule.console.database.vo.UserCommitVO;
import com.bstek.urule.console.security.entity.Module;
import com.bstek.urule.console.security.entity.Permission;
import com.bstek.urule.console.security.provider.PermissionProvider;
import com.bstek.urule.console.type.ProjectRoleEnum;
import com.bstek.urule.console.type.RoleCategory;
import com.bstek.urule.console.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProjectServiceImpl
implements ProjectService {
    @Override
    public void add(Project project) {
        try {
            String string = project.getName();
            if (StringUtils.isBlank(string)) {
                throw new InfoException("\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a.<br/>The project name can not empty.");
            }
            if (StringUtils.hasSpecialChar(string)) {
                throw new InfoException("\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26.<br/>Project name cannot contain special characters.");
            }
            List<Project> list = ProjectManager.ins.newQuery().groupId(project.getGroupId()).name(project.getName()).list();
            if (list.size() > 0) {
                throw new InfoException("\u9879\u76ee\u540d\u79f0\u91cd\u590d.<br/>Duplicate project name.");
            }
            ProjectManager.ins.add(project);
            User user = UserServiceManager.getUserService().get(project.getCreateUser());
            ProjectManager.ins.addProjectUser(project.getId(), project.getCreateUser(), user.getName());
            for (ProjectRoleEnum projectRoleEnum : ProjectRoleEnum.values()) {
                ProjectRole projectRole = new ProjectRole();
                projectRole.setProjectId(project.getId());
                projectRole.setType("system");
                projectRole.setName(projectRoleEnum.name());
                projectRole.setCreateUser(project.getCreateUser());
                ProjectRoleManager.ins.add(projectRole);
                this.a(projectRole);
                if (projectRoleEnum != ProjectRoleEnum.Manager) continue;
                ProjectRoleService.ins.addUserRole(project.getId(), project.getCreateUser(), projectRole.getId());
            }
        }
        catch (Exception exception) {
            throw new InfoException(exception);
        }
    }

    private void a(ProjectRole projectRole) {
        long l = projectRole.getId();
        List<Module> list = PermissionProvider.getProjectModules();
        for (Module module : list) {
            for (Permission permission : module.getItems()) {
                boolean bl = false;
                for (String string : permission.getRoles()) {
                    if (!string.equals(projectRole.getName())) continue;
                    bl = true;
                }
                permission.setChecked(bl);
                permission.setDisabled(false);
            }
        }
        AuthorityService.ins.initPermissions(l, list);
    }

    @Override
    public void update(Project project) {
        String string = project.getName();
        if (StringUtils.isBlank(string)) {
            throw new InfoException("\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a.<br/>The project name can not empty.");
        }
        if (StringUtils.hasSpecialChar(string)) {
            throw new InfoException("\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26.<br/>Project name cannot contain special characters.");
        }
        List<Project> list = ProjectManager.ins.newQuery().groupId(project.getGroupId()).name(project.getName()).list();
        if (list.size() > 0) {
            boolean bl = false;
            for (Project project2 : list) {
                if (project.getId() == project2.getId()) continue;
                bl = true;
            }
            if (bl) {
                throw new InfoException("\u9879\u76ee\u540d\u79f0\u91cd\u590d.<br/>Duplicate project name.");
            }
        }
        ProjectManager.ins.update(project);
    }

    @Override
    public List<Map<String, Object>> remove(long l) {
        try {
            Project project = ProjectManager.ins.get(l);
            List<Map<String, Object>> list = PacketCache.ins.removeProject(l, project.getGroupId());
            OperationLogManager.ins.removeByProjectId(l);
            KnowledgeLogManager.ins.removeByProject(l);
            ScenarioManager.ins.deleteByProjectId(l);
            PacketApplyManager.ins.deleteByProjectId(l);
            PacketDeployManager.ins.deleteByProjectId(l);
            PacketManager.ins.deleteByProjectId(l);
            BatchManagerHelper.removeByProjectId(l);
            VersionFileManager.ins.deleteByProjectId(l);
            DirectoryManager.ins.deleteByProjectId(l);
            FileManager.ins.deleteByProjectId(l);
            List<Role> list2 = ProjectRoleManager.ins.loadRoles(l);
            for (Role role : list2) {
                AuthorityManager.ins.removeByRole(RoleCategory.project.name(), role.getId());
            }
            ProjectRoleManager.ins.removeByProjectId(l);
            ProjectManager.ins.removeProjectUsers(l);
            ProjectManager.ins.remove(l);
            return list;
        }
        catch (Exception exception) {
            throw new InfoException(exception);
        }
    }

    @Override
    public void addProjectuser(long l, String string) {
        User user = UserManager.ins.getProjectUser(l, string);
        if (user == null) {
            User user2 = UserServiceManager.getUserService().get(string);
            ProjectManager.ins.addProjectUser(l, string, user2.getName());
            ProjectRole projectRole = ProjectRoleManager.ins.get(l, ProjectRoleEnum.User.name());
            if (projectRole != null) {
                ProjectRoleService.ins.addUserRole(l, string, projectRole.getId());
            }
        }
    }

    @Override
    public List<UserCommitVO> getUserCommits(Long l, Date date, Date date2) {
        FileCountQuery fileCountQuery = FileManager.ins.newCountQuery();
        List<RuleFile> list = fileCountQuery.projectId(l).updateDateBegin(date).updateDateEnd(date2).getUserCommits();
        HashMap<String, UserCommitVO> hashMap = new HashMap<String, UserCommitVO>();
        for (RuleFile ruleFile : list) {
            UserCommitVO userCommitVO = new UserCommitVO();
            if (!hashMap.containsKey(ruleFile.getUpdateUser())) {
                userCommitVO.setUserId(ruleFile.getUpdateUser());
                User user = UserServiceManager.getUserService().get(ruleFile.getUpdateUser());
                userCommitVO.setUserName(user != null ? user.getName() : ruleFile.getUpdateUser());
                hashMap.put(ruleFile.getUpdateUser(), userCommitVO);
            } else {
                userCommitVO = (UserCommitVO)hashMap.get(ruleFile.getUpdateUser());
            }
            userCommitVO.setCount(userCommitVO.getCount() + 1);
        }
        List list2 = new ArrayList(hashMap.values());
        Collections.sort(list2, new Comparator<UserCommitVO>(){

            @Override
            public int compare(UserCommitVO userCommitVO, UserCommitVO userCommitVO2) {
                return userCommitVO2.getCount() - userCommitVO.getCount();
            }
        });
        return list2.size() > 5 ? list2.subList(0, 4) : list2;
    }

    @Override
    public List<RuleCommitVO> getRuleCommits(Long l, Date date, Date date2) {
        FileCountQuery fileCountQuery = FileManager.ins.newCountQuery();
        List<RuleFile> list = fileCountQuery.projectId(l).updateDateBegin(date).updateDateEnd(date2).getRuleCommits();
        HashMap<Date, RuleCommitVO> hashMap = new HashMap<Date, RuleCommitVO>();
        for (RuleFile ruleFile : list) {
            RuleCommitVO ruleCommitVO = new RuleCommitVO();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(ruleFile.getModifyDate());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            if (!hashMap.containsKey(calendar.getTime())) {
                ruleCommitVO.setCreateDate(calendar.getTime());
                hashMap.put(calendar.getTime(), ruleCommitVO);
            } else {
                ruleCommitVO = (RuleCommitVO)hashMap.get(calendar.getTime());
            }
            ruleCommitVO.setCount(ruleCommitVO.getCount() + 1);
        }
        ArrayList arrayList = new ArrayList(hashMap.values());
        Collections.sort(arrayList, new Comparator<RuleCommitVO>(){

            @Override
            public int compare(RuleCommitVO ruleCommitVO, RuleCommitVO ruleCommitVO2) {
                return (int)(ruleCommitVO.getCreateDate().getTime() - ruleCommitVO2.getCreateDate().getTime());
            }
        });
        return arrayList;
    }

    @Override
    public List<RuleDeployVO> getRuleDeploys(Long l, Date date, Date date2) {
        PacketApplyQuery packetApplyQuery = PacketApplyManager.ins.newQuery();
        List<PacketApply> list = packetApplyQuery.projectId(l).startDate(date).endDate(date2).type(ApplyType.deploy).status(ApplyStatus.pass).list();
        HashMap<Date, RuleDeployVO> hashMap = new HashMap<Date, RuleDeployVO>();
        for (PacketApply packetApply : list) {
            RuleDeployVO ruleDeployVO = new RuleDeployVO();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(packetApply.getCreateDate());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            if (!hashMap.containsKey(calendar.getTime())) {
                hashMap.put(calendar.getTime(), ruleDeployVO);
            } else {
                ruleDeployVO = (RuleDeployVO)hashMap.get(calendar.getTime());
            }
            ruleDeployVO.setCreateDate(calendar.getTime());
            ruleDeployVO.setCount(ruleDeployVO.getCount() + 1);
        }
        ArrayList arrayList = new ArrayList(hashMap.values());
        Collections.sort(arrayList, new Comparator<RuleDeployVO>(){

            @Override
            public int compare(RuleDeployVO ruleDeployVO, RuleDeployVO ruleDeployVO2) {
                return (int)(ruleDeployVO.getCreateDate().getTime() - ruleDeployVO2.getCreateDate().getTime());
            }
        });
        return arrayList;
    }

    @Override
    public List<RuleExecVO> getRuleExecCount(Long l, Date date, Date date2) {
        KnowledgeLogCountQuery knowledgeLogCountQuery = KnowledgeLogManager.ins.newCountQuery();
        knowledgeLogCountQuery.projectId(l);
        knowledgeLogCountQuery.dateBegin(date);
        knowledgeLogCountQuery.dateEnd(date2);
        return knowledgeLogCountQuery.listExec();
    }

    @Override
    public List<RuleExecVO> getRuleExecTime(Long l, Date date, Date date2) {
        KnowledgeLogCountQuery knowledgeLogCountQuery = KnowledgeLogManager.ins.newCountQuery();
        knowledgeLogCountQuery.projectId(l);
        knowledgeLogCountQuery.dateBegin(date);
        knowledgeLogCountQuery.dateEnd(date2);
        List<RuleExecVO> list = knowledgeLogCountQuery.listTime();
        return list.size() > 10 ? list.subList(0, 9) : list;
    }
}

