/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.service.project.role;

import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.admin.project.ProjectRoleVO;
import com.bstek.urule.console.database.manager.project.role.ProjectRoleManager;
import com.bstek.urule.console.database.model.ProjectRole;
import com.bstek.urule.console.database.model.Role;
import com.bstek.urule.console.database.model.User;
import com.bstek.urule.console.database.service.project.role.ProjectRoleService;
import com.bstek.urule.console.database.service.user.UserServiceManager;
import com.bstek.urule.console.type.GroupRoleEnum;
import java.util.ArrayList;
import java.util.List;

public class ProjectRoleServiceImpl
implements ProjectRoleService {
    @Override
    public List<Role> loadRoles(long l) {
        return ProjectRoleManager.ins.loadRoles(l);
    }

    @Override
    public void add(ProjectRole projectRole) {
        if (ProjectRoleManager.ins.checkExist(projectRole.getProjectId(), projectRole.getName())) {
            throw new InfoException("Duplicate role name!");
        }
        ProjectRoleManager.ins.add(projectRole);
    }

    @Override
    public void update(ProjectRole projectRole) {
        if (ProjectRoleManager.ins.checkExist(projectRole.getProjectId(), projectRole.getName())) {
            throw new InfoException("Duplicate role name!");
        }
        ProjectRoleManager.ins.update(projectRole);
    }

    @Override
    public void remove(Long l) {
        ProjectRoleManager.ins.remove(l);
    }

    @Override
    public void addUserRole(long l, String string, long l2) {
        if (ProjectRoleManager.ins.getUserRole(string, l2) == null) {
            ProjectRoleManager.ins.addUserRole(l, string, l2);
        }
    }

    @Override
    public void removeUserRole(String string, long l) {
        ProjectRoleManager.ins.removeUserRole(string, l);
    }

    @Override
    public List<ProjectRoleVO> loadUserRoles(long l, String string) {
        List<Role> list = ProjectRoleManager.ins.loadRoles(l);
        List<Role> list2 = ProjectRoleManager.ins.loadUserRoles(l, string);
        ArrayList<ProjectRoleVO> arrayList = new ArrayList<ProjectRoleVO>();
        for (Role role : list) {
            if (role.getName().equals(GroupRoleEnum.Owner.name())) continue;
            ProjectRoleVO projectRoleVO = new ProjectRoleVO();
            projectRoleVO.setId(role.getId());
            projectRoleVO.setName(role.getName());
            projectRoleVO.setType(role.getType());
            for (Role role2 : list2) {
                if (role2.getId() != role.getId()) continue;
                projectRoleVO.setSelected(true);
                break;
            }
            arrayList.add(projectRoleVO);
        }
        return arrayList;
    }

    @Override
    public List<User> users(long l, long l2) {
        List<User> list = ProjectRoleManager.ins.loadRoleUsers(l, l2);
        ArrayList<User> arrayList = new ArrayList<User>();
        for (User user : list) {
            arrayList.add(UserServiceManager.getUserService().get(user.getId()));
        }
        return null;
    }
}

