/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.service.repository;

import com.bstek.urule.Utils;
import com.bstek.urule.console.database.model.batch.DataSourceType;
import com.bstek.urule.console.database.model.datasource.DataSource;
import com.bstek.urule.console.database.service.repository.BatchDataSourceHandler;
import com.bstek.urule.console.database.service.repository.JdbcDataSourceHandler;
import com.bstek.urule.console.database.service.repository.JndiDataSourceHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSourceHandlerManager {
    static final Log a = LogFactory.getLog(DataSourceHandlerManager.class);
    static Map<Long, javax.sql.DataSource> b = new ConcurrentHashMap<Long, javax.sql.DataSource>();
    static Map<DataSourceType, BatchDataSourceHandler> c = new HashMap<DataSourceType, BatchDataSourceHandler>();
    static Map<String, BatchDataSourceHandler> d = new ConcurrentHashMap<String, BatchDataSourceHandler>();

    public static javax.sql.DataSource getDataSource(DataSource dataSource) throws Exception {
        if (b.containsKey(dataSource.getId())) {
            return b.get(dataSource.getId());
        }
        javax.sql.DataSource dataSource2 = null;
        if (dataSource.getType() == DataSourceType.jdbc) {
            dataSource2 = c.get((Object)DataSourceType.jdbc).getDataSource(dataSource);
        } else if (dataSource.getType() == DataSourceType.jndi) {
            dataSource2 = c.get((Object)DataSourceType.jndi).getDataSource(dataSource);
        } else if (dataSource.getType() == DataSourceType.custom) {
            String string = dataSource.getDataSourceBean();
            BatchDataSourceHandler batchDataSourceHandler = d.get(string);
            if (batchDataSourceHandler == null) {
                try {
                    batchDataSourceHandler = (BatchDataSourceHandler)Utils.getApplicationContext().getBean(string);
                }
                catch (Exception exception) {
                    a.error((Object)exception);
                    batchDataSourceHandler = (BatchDataSourceHandler)Class.forName(string).newInstance();
                }
                d.put(string, batchDataSourceHandler);
            }
            dataSource2 = batchDataSourceHandler.getDataSource(dataSource);
        }
        b.put(dataSource.getId(), dataSource2);
        return dataSource2;
    }

    public static javax.sql.DataSource newDataSource(DataSource dataSource) throws Exception {
        javax.sql.DataSource dataSource2 = null;
        if (dataSource.getType() == DataSourceType.jdbc) {
            dataSource2 = new JdbcDataSourceHandler().getDataSource(dataSource);
        } else if (dataSource.getType() == DataSourceType.jndi) {
            dataSource2 = new JndiDataSourceHandler().getDataSource(dataSource);
        } else if (dataSource.getType() == DataSourceType.custom) {
            String string = dataSource.getDataSourceBean();
            BatchDataSourceHandler batchDataSourceHandler = null;
            try {
                batchDataSourceHandler = (BatchDataSourceHandler)Utils.getApplicationContext().getBean(string);
            }
            catch (Exception exception) {
                a.error((Object)exception);
                batchDataSourceHandler = (BatchDataSourceHandler)Class.forName(string).newInstance();
            }
            dataSource2 = batchDataSourceHandler.getDataSource(dataSource);
        }
        return dataSource2;
    }

    public static void removeDataSource(Long l) {
        b.remove(l);
    }

    static {
        c.put(DataSourceType.jdbc, new JdbcDataSourceHandler());
        c.put(DataSourceType.jndi, new JndiDataSourceHandler());
    }
}

