/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.service.user;

import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.database.manager.group.GroupManager;
import com.bstek.urule.console.database.manager.user.UserManager;
import com.bstek.urule.console.database.model.Group;
import com.bstek.urule.console.database.model.User;
import com.bstek.urule.console.database.service.user.PersistUserService;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.exception.RuleException;
import java.util.List;

public class UserServiceImpl
implements PersistUserService {
    @Override
    public void add(User user) {
        UserManager.ins.add(user);
    }

    @Override
    public void update(User user) {
        UserManager.ins.update(user);
    }

    @Override
    public User get(String string) {
        return UserManager.ins.get(string);
    }

    @Override
    public void remove(User user) {
        UserManager.ins.remove(user.getId());
    }

    @Override
    public void changeEmail(String string, String string2) {
        UserManager.ins.changeEmail(string, string2);
    }

    @Override
    public void changePassword(String string, String string2) {
        UserManager.ins.changePassword(string, string2);
    }

    @Override
    public User validate(String string, String string2) {
        User user = null;
        try {
            if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
                throw new InfoException("\u8d26\u53f7\u548c\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a!<br>Username and Password can not be null.");
            }
            user = this.get(string);
            if (user == null) {
                throw new InfoException("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef!<br>Username or Password is invalid.");
            }
            if (!string2.equals(user.getPassword())) {
                throw new InfoException("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef!<br>Username or Password is invalid.");
            }
            List<Group> list = GroupManager.ins.createQuery().list(user.getId());
            user.setGroups(list);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        return user;
    }
}

