/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.util;

import com.bstek.urule.console.config.Configuration;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationUtils {
    private static String a = "select ID_, KEY_, VALUE_, LABEL_, CREATE_DATE_, UPDATE_DATE_ from URULE_PROPERTY";
    private static String b = "update URULE_PROPERTY set VALUE_=? , UPDATE_DATE_=? where KEY_=?";

    public static List<Configuration> getConfigurations(Connection connection) {
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(a);
            while (resultSet.next()) {
                Configuration configuration = new Configuration();
                configuration.setId(resultSet.getLong(1));
                configuration.setKey(resultSet.getString(2));
                configuration.setValue(resultSet.getString(3));
                configuration.setLabel(resultSet.getString(4));
                configuration.setCreateDate(resultSet.getTimestamp(5));
                configuration.setUpdateDate(resultSet.getTimestamp(6));
                arrayList.add(configuration);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        return arrayList;
    }

    public static void updateConfiguration(Connection connection, Configuration configuration) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(b);
            preparedStatement.setString(1, configuration.getKey());
            preparedStatement.setString(2, configuration.getValue());
            preparedStatement.setDate(3, new Date(System.currentTimeMillis()));
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }
}

