/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.util;

import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.config.bootstrap.BootstrapManager;
import com.bstek.urule.console.config.dialect.Dialect;
import com.bstek.urule.console.config.dialect.DialectResolver;
import com.bstek.urule.console.config.manager.DBConfigManager;
import com.bstek.urule.console.database.model.datasource.FieldType;
import com.bstek.urule.exception.RuleException;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class JdbcUtils {
    static ThreadLocal<Connection> a = new ThreadLocal();
    static ThreadLocal<Stack<String>> b = new ThreadLocal();
    private static final String c = "urule";
    private static final Log d = LogFactory.getLog(JdbcUtils.class);

    public static FieldType buildJdbcFieldType(int n) {
        FieldType fieldType;
        switch (n) {
            case -5: {
                fieldType = FieldType.Double;
            }
            case 4: {
                fieldType = FieldType.Integer;
            }
            case 8: {
                fieldType = FieldType.Double;
            }
            case 6: {
                fieldType = FieldType.Double;
                break;
            }
            case 7: {
                fieldType = FieldType.Float;
                break;
            }
            case 3: {
                fieldType = FieldType.BigDecimal;
                break;
            }
            case 2: {
                fieldType = FieldType.BigDecimal;
                break;
            }
            case -6: {
                fieldType = FieldType.Short;
                break;
            }
            case 5: {
                fieldType = FieldType.Integer;
                break;
            }
            case 1: {
                fieldType = FieldType.String;
                break;
            }
            case 12: {
                fieldType = FieldType.String;
                break;
            }
            case -16: {
                fieldType = FieldType.String;
                break;
            }
            case -1: {
                fieldType = FieldType.String;
                break;
            }
            case -9: {
                fieldType = FieldType.String;
                break;
            }
            case 16: {
                fieldType = FieldType.Boolean;
                break;
            }
            case -7: {
                fieldType = FieldType.Boolean;
                break;
            }
            case 91: {
                fieldType = FieldType.Date;
                break;
            }
            case 93: {
                fieldType = FieldType.Date;
                break;
            }
            default: {
                fieldType = FieldType.Other;
            }
        }
        return fieldType;
    }

    public static void fillPreparedStatementParameters(List<Object> list, PreparedStatement preparedStatement) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            if (object instanceof String) {
                preparedStatement.setString(i + 1, (String)object);
                continue;
            }
            if (object instanceof Long) {
                preparedStatement.setLong(i + 1, (Long)object);
                continue;
            }
            if (object instanceof Boolean) {
                preparedStatement.setBoolean(i + 1, (Boolean)object);
                continue;
            }
            if (object instanceof Array) {
                preparedStatement.setArray(i + 1, (Array)object);
                continue;
            }
            if (object instanceof Date) {
                preparedStatement.setTimestamp(i + 1, new Timestamp(((Date)object).getTime()));
                continue;
            }
            preparedStatement.setObject(i + 1, object);
        }
    }

    public static void rollback(Connection connection) {
        try {
            connection.rollback();
        }
        catch (SQLException sQLException) {
            throw new RuleException((Exception)sQLException);
        }
    }

    public static void setAutoCommit(Connection connection, boolean bl) {
        try {
            connection.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            throw new RuleException((Exception)sQLException);
        }
    }

    public static void closeConnection(Connection connection) {
        Stack<String> stack = b.get();
        if (stack != null) {
            if (stack.size() > 0) {
                stack.pop();
            }
            if (stack.size() == 0 && connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    d.debug((Object)"Could not close JDBC Connection", (Throwable)sQLException);
                }
                catch (Throwable throwable) {
                    d.debug((Object)"Unexpected exception on closing JDBC Connection", throwable);
                }
                a.remove();
            }
        }
    }

    public static void rollbackConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                d.debug((Object)"Could not rollback JDBC Connection", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                d.debug((Object)"Unexpected exception on rollback JDBC Connection", throwable);
            }
        }
    }

    public static void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                d.trace((Object)"Could not close JDBC Statement", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                d.trace((Object)"Unexpected exception on closing JDBC Statement", throwable);
            }
        }
    }

    public static void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                d.trace((Object)"Could not close JDBC ResultSet", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                d.trace((Object)"Unexpected exception on closing JDBC ResultSet", throwable);
            }
        }
    }

    public static boolean checkTableExists(Connection connection, String string) {
        boolean bl = false;
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, null, string, null);
            bl = resultSet.next();
            resultSet.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return bl;
    }

    public static Connection getConnection() {
        Stack<String> stack;
        Connection connection = a.get();
        if (connection == null) {
            stack = (DBConfigManager)BootstrapManager.get().getConfigManager();
            try {
                connection = ((DBConfigManager)((Object)stack)).getConnection();
            }
            catch (Exception exception) {
                throw new InfoException(exception);
            }
        }
        a.set(connection);
        stack = b.get();
        if (stack == null) {
            stack = new Stack<String>();
        }
        stack.push(c);
        b.set(stack);
        return connection;
    }

    public static String getPlatform() {
        DBConfigManager dBConfigManager = (DBConfigManager)BootstrapManager.get().getConfigManager();
        return dBConfigManager.getPlatform();
    }

    public static String getPageSql(Connection connection, String string, long l, int n) {
        Dialect dialect = DialectResolver.resolveDialect(connection);
        return dialect.getLimitString(string, Long.valueOf(l).intValue(), n);
    }

    public static String getPageSql(String string, long l, int n) {
        String string2 = "";
        String string3 = JdbcUtils.getPlatform();
        if (StringUtils.isEmpty((Object)string3)) {
            throw new RuleException("\u672a\u6307\u5b9a\u53c2\u6570urule.store.database.platform");
        }
        string2 = string3.indexOf("oracle") != -1 || string3.equalsIgnoreCase("dm") ? JdbcUtils.b(string, Long.valueOf(l).intValue(), Long.valueOf(n).intValue()) : (string3.indexOf("db2") != -1 ? JdbcUtils.a(string, Long.valueOf(l).intValue(), Long.valueOf(n).intValue()) : (string3.indexOf("sqlserver") != -1 ? string + " offset " + l + " rows fetch next " + n + " rows only" : (string3.indexOf("mysql") != -1 ? JdbcUtils.c(string, Long.valueOf(l).intValue(), Long.valueOf(n).intValue()) : (string3.indexOf("hsql") != -1 ? JdbcUtils.d(string, Long.valueOf(l).intValue(), Long.valueOf(n).intValue()) : (string3.indexOf("postgresql") != -1 ? JdbcUtils.e(string, Long.valueOf(l).intValue(), Long.valueOf(n).intValue()) : string)))));
        return string2;
    }

    private static String a(String string, int n, int n2) {
        if (n == 0) {
            return string + " fetch first " + n2 + " rows only";
        }
        return "select * from ( select inner2_.*, rownumber() over(order by order of inner2_) as rownumber_ from ( " + string + " fetch first " + n2 + " rows only ) as inner2_ ) as inner1_ where rownumber_ > " + n + " order by rownumber_";
    }

    private static String b(String string, int n, int n2) {
        if (n == 0) {
            return "select * from ( " + string + ") where rownum <= " + n2;
        }
        return "select * from ( select row_.*, rownum rownum_ from ( " + string + " ) row_ ) where rownum_ <= " + (n + n2) + " and rownum_ > " + n;
    }

    private static String c(String string, int n, int n2) {
        if (n == 0) {
            return string + " limit " + n2;
        }
        return string + " limit " + n + "," + n2;
    }

    private static String d(String string, int n, int n2) {
        if (n == 0) {
            return string + " limit " + n2;
        }
        return string + " offset " + n + " limit " + n2;
    }

    private static String e(String string, int n, int n2) {
        if (n == 0) {
            return string + " limit " + n2;
        }
        return string + " limit " + n2 + " offset " + n;
    }

    public static String getCountSql(String string) {
        String string2 = "select count(*) TOTAL_ROWS_ from (" + string + ") ";
        if (JdbcUtils.getPlatform().indexOf("oracle") == -1) {
            string2 = string2 + " as ";
        }
        string2 = string2 + " countTable ";
        return string2;
    }

    public static String getOriginSql(String string) {
        String string2 = string.replaceAll(":\\w+", "?");
        return string2;
    }
}

