/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.editor.decision.crosstab;

import com.bstek.urule.Utils;
import com.bstek.urule.builder.resource.ResourceType;
import com.bstek.urule.console.ContextHolder;
import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.editor.decision.CellContent;
import com.bstek.urule.console.editor.decision.crosstab.CrossColumn;
import com.bstek.urule.console.editor.decision.crosstab.CrossData;
import com.bstek.urule.console.editor.decision.crosstab.CrossHeader;
import com.bstek.urule.console.editor.decision.crosstab.CrossRow;
import com.bstek.urule.console.editor.lib.VariableInfo;
import com.bstek.urule.console.editor.lib.VariableLoader;
import com.bstek.urule.console.xml.DocumentHelper;
import com.bstek.urule.dsl.DSLRuleSetBuilder;
import com.bstek.urule.model.crosstab.CrosstabDefinition;
import com.bstek.urule.model.library.variable.Variable;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.model.rule.SimpleValue;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.VariableCategoryValue;
import com.bstek.urule.model.rule.VariableValue;
import com.bstek.urule.model.rule.lhs.Criteria;
import com.bstek.urule.model.rule.lhs.Criterion;
import com.bstek.urule.model.rule.lhs.Junction;
import com.bstek.urule.model.rule.lhs.Or;
import com.bstek.urule.parse.deserializer.CrosstableDeserializer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;

public class CrossTableXmlBuilder {
    private CrossData a;
    private DSLRuleSetBuilder b;
    private CrosstableDeserializer c;
    private List<VariableInfo> d;
    private Map<Long, VariableInfo> e = new HashMap<Long, VariableInfo>();

    public CrossTableXmlBuilder(CrossData crossData) {
        this.a = crossData;
        this.d = VariableLoader.ins.load(ContextHolder.getGroupId(), ContextHolder.getProjectId());
        this.b = (DSLRuleSetBuilder)Utils.getApplicationContext().getBean("urule.dslRuleSetBuilder");
        this.c = (CrosstableDeserializer)Utils.getApplicationContext().getBean("urule.crosstableDeserializer");
    }

    public CrosstabDefinition doBuild() throws Exception {
        String string = this.a();
        Document document = DocumentHelper.parseText(string);
        return this.c.deserialize(document.getRootElement());
    }

    private String a() throws Exception {
        String string;
        String string2;
        Variable variable;
        String[] stringArray;
        String string3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        CrossHeader crossHeader = this.a.getHeader();
        stringBuilder.append("<crosstab>");
        String string4 = crossHeader.getContent();
        string4 = string4 == null ? "\u8868\u5934" : string4;
        stringBuilder.append("<header rowspan=\"" + crossHeader.getRowSpan() + "\" colspan=\"" + crossHeader.getColSpan() + "\"><![CDATA[" + string4 + "]]></header>");
        for (CrossRow object : this.a.getRows()) {
            stringBuilder.append("<row number=\"" + object.getNumber() + "\" type=\"" + (Object)((Object)object.getType()) + "\"");
            string3 = object.getContent();
            if (StringUtils.isNotBlank((String)string3)) {
                stringArray = this.a(string3);
                variable = this.a(stringArray);
                string2 = stringArray[0];
                string = "variable";
                if (string2.equals("\u53c2\u6570") || string2.equals("parameter")) {
                    string = "parameter";
                }
                stringBuilder.append(" bundle-data-type=\"" + string + "\" var-category=\"" + string2 + "\" var=\"" + variable.getName() + "\" var-label=\"" + variable.getLabel() + "\" datatype=\"" + variable.getType().name() + "\"");
            }
            stringBuilder.append("/>");
        }
        for (CrossColumn crossColumn : this.a.getColumns()) {
            stringBuilder.append("<column number=\"" + crossColumn.getNumber() + "\" type=\"" + (Object)((Object)crossColumn.getType()) + "\"");
            string3 = crossColumn.getContent();
            if (StringUtils.isNotBlank((String)string3)) {
                stringArray = this.a(string3);
                variable = this.a(stringArray);
                string2 = stringArray[0];
                string = "variable";
                if (string2.equals("\u53c2\u6570") || string2.equals("parameter")) {
                    string = "parameter";
                }
                stringBuilder.append(" bundle-data-type=\"" + string + "\" var-category=\"" + string2 + "\" var=\"" + variable.getName() + "\" var-label=\"" + variable.getLabel() + "\" datatype=\"" + variable.getType().name() + "\"");
            }
            stringBuilder.append("/>");
        }
        for (CellContent cellContent : this.a.getCells()) {
            string3 = cellContent.getType();
            stringArray = "condition-cell";
            if (string3.equals("value")) {
                stringArray = "value-cell";
            }
            stringBuilder.append("<");
            stringBuilder.append((String)stringArray);
            int n = 1;
            int n2 = 1;
            boolean bl = false;
            if (cellContent.getRow() <= this.a.getHeader().getRowSpan()) {
                n2 = cellContent.getSpan();
                bl = true;
            }
            if (cellContent.getCol() <= this.a.getHeader().getColSpan()) {
                n = cellContent.getSpan();
                bl = true;
            }
            stringBuilder.append(" row=\"" + cellContent.getRow() + "\" col=\"" + cellContent.getCol() + "\"");
            if (bl) {
                stringBuilder.append(" rowspan=\"" + n + "\" colspan=\"" + n2 + "\"");
            }
            stringBuilder.append(">");
            String string5 = cellContent.getContent();
            if (StringUtils.isNotBlank((String)string5)) {
                if (bl) {
                    Criterion criterion = this.b.buildCriterion(string5);
                    stringBuilder.append(this.a(criterion));
                } else {
                    string5 = StringEscapeUtils.escapeXml((String)string5);
                    stringBuilder.append("<value content=\"" + string5 + "\" type=\"Input\"/>");
                }
            }
            stringBuilder.append("");
            stringBuilder.append("</");
            stringBuilder.append((String)stringArray);
            stringBuilder.append(">");
        }
        for (VariableInfo variableInfo : this.e.values()) {
            if (variableInfo.getType().endsWith(ResourceType.VariableLibrary.name())) {
                stringBuilder.append("<import-variable-library id=\"" + variableInfo.getId() + "\" path=\"" + variableInfo.getPath() + "\"/>");
                continue;
            }
            stringBuilder.append("<import-parameter-library id=\"" + variableInfo.getId() + "\" path=\"" + variableInfo.getPath() + "\"/>");
        }
        stringBuilder.append("");
        stringBuilder.append("");
        stringBuilder.append("");
        stringBuilder.append("");
        stringBuilder.append("");
        stringBuilder.append("</crosstab>");
        return stringBuilder.toString();
    }

    private String a(Criterion criterion) {
        StringBuilder stringBuilder = new StringBuilder();
        if (criterion instanceof Junction) {
            Junction junction = (Junction)criterion;
            List list = junction.getCriterions();
            String string = "and";
            if (junction instanceof Or) {
                string = "or";
            }
            stringBuilder.append("<joint type=\"" + string + "\">");
            if (list != null) {
                for (Criterion criterion2 : list) {
                    if (!(criterion2 instanceof Criteria)) continue;
                    Criteria criteria = (Criteria)criterion2;
                    stringBuilder.append("<condition op=\"" + criteria.getOp().name() + "\">");
                    Value value = criteria.getValue();
                    stringBuilder.append(this.a(value));
                    stringBuilder.append("</condition>");
                }
            }
        } else {
            stringBuilder.append("<joint type=\"and\">");
            Criteria criteria = (Criteria)criterion;
            stringBuilder.append("<condition op=\"" + criteria.getOp().name() + "\">");
            Value value = criteria.getValue();
            String string = this.a(value);
            if (string != null) {
                stringBuilder.append(string);
            }
            stringBuilder.append("</condition>");
        }
        stringBuilder.append("</joint>");
        return stringBuilder.toString();
    }

    private String a(Value value) {
        String string;
        SimpleValue simpleValue;
        if (value == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (value instanceof SimpleValue) {
            simpleValue = (SimpleValue)value;
            string = StringEscapeUtils.escapeXml((String)simpleValue.getContent());
            stringBuilder.append("<value content=\"" + string + "\" type=\"Input\">");
        } else if (value instanceof VariableCategoryValue) {
            simpleValue = (VariableCategoryValue)value;
            string = simpleValue.getVariableCategory();
            String string2 = StringEscapeUtils.escapeXml((String)string);
            stringBuilder.append("<value content=\"" + string2 + "\" type=\"Input\">");
        } else if (value instanceof VariableValue) {
            simpleValue = (VariableValue)value;
            string = simpleValue.getVariableCategory() + "." + simpleValue.getVariableLabel();
            string = StringEscapeUtils.escapeXml((String)string);
            stringBuilder.append("<value content=\"" + string + "\" type=\"Input\">");
        } else {
            stringBuilder.append("<value content=\"\" type=\"Input\">");
        }
        simpleValue = value.getArithmetic();
        if (simpleValue == null) {
            stringBuilder.append("</value>");
            return stringBuilder.toString();
        }
        string = simpleValue.getType();
        stringBuilder.append("<complex-arith type=\"" + string.name() + "\">");
        stringBuilder.append(this.a(simpleValue.getValue()));
        stringBuilder.append("</complex-arith>");
        stringBuilder.append("</value>");
        return stringBuilder.toString();
    }

    private Variable a(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        for (VariableInfo variableInfo : this.d) {
            List<VariableCategory> list = variableInfo.getVariableCategories();
            for (VariableCategory variableCategory : list) {
                if (!variableCategory.getName().equals(string)) continue;
                this.e.put(variableInfo.getId(), variableInfo);
                List list2 = variableCategory.getVariables();
                if (list2 == null) continue;
                for (Variable variable : list2) {
                    if (!variable.getLabel().equals(string2) && !variable.getName().equals(string2)) continue;
                    return variable;
                }
            }
        }
        throw new InfoException("\u53d8\u91cf[" + string + "." + string2 + "]\u5728\u5f53\u524d\u9879\u76ee\u4e2d\u672a\u5b9a\u4e49!");
    }

    private String[] a(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 2) {
            throw new InfoException("\u8868\u5934[" + string + "]\u4e0d\u5408\u6cd5\uff01");
        }
        return stringArray;
    }
}

