/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.editor.decision.crosstab;

import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.editor.decision.CellContent;
import com.bstek.urule.console.editor.decision.crosstab.CrossColumn;
import com.bstek.urule.console.editor.decision.crosstab.CrossData;
import com.bstek.urule.console.editor.decision.crosstab.CrossHeader;
import com.bstek.urule.console.editor.decision.crosstab.CrossRow;
import com.bstek.urule.console.editor.decision.crosstab.CrossTableXmlBuilder;
import com.bstek.urule.console.editor.decision.crosstab.Span;
import com.bstek.urule.console.editor.decision.crosstab.Type;
import com.bstek.urule.console.util.FileUtils;
import com.bstek.urule.model.crosstab.CrosstabDefinition;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CrosstabServletHandler
extends ApiServletHandler {
    public void excel(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        InputStream inputStream = FileUtils.uploadFile(httpServletRequest).getInputStream();
        CrossData crossData = this.a(inputStream);
        inputStream.close();
        CrossTableXmlBuilder crossTableXmlBuilder = new CrossTableXmlBuilder(crossData);
        CrosstabDefinition crosstabDefinition = crossTableXmlBuilder.doBuild();
        this.a(httpServletResponse, crosstabDefinition);
    }

    private CrossData a(InputStream inputStream) throws Exception {
        Object object;
        XSSFCell xSSFCell;
        String string;
        CrossRow crossRow;
        XSSFRow xSSFRow;
        int n;
        XSSFWorkbook xSSFWorkbook = new XSSFWorkbook(inputStream);
        if (xSSFWorkbook.getNumberOfSheets() == 0) {
            xSSFWorkbook.close();
            throw new InfoException("\u5bfc\u5165Excel\u4e0d\u5408\u6cd5\uff01");
        }
        ArrayList<CrossRow> arrayList = new ArrayList<CrossRow>();
        ArrayList<CrossColumn> arrayList2 = new ArrayList<CrossColumn>();
        XSSFSheet xSSFSheet = xSSFWorkbook.getSheetAt(0);
        CrossHeader crossHeader = this.a(xSSFSheet);
        XSSFRow xSSFRow2 = xSSFSheet.getRow(0);
        int n2 = xSSFRow2.getLastCellNum();
        XSSFRow xSSFRow3 = xSSFSheet.getRow(crossHeader.getRowSpan());
        for (n = 0; n < n2; ++n) {
            CrossColumn crossColumn = new CrossColumn();
            crossColumn.setNumber(n + 1);
            if (n < crossHeader.getColSpan()) {
                crossColumn.setType(Type.left);
                xSSFRow = xSSFRow3.getCell(n);
                crossRow = xSSFRow.getCellComment();
                if (crossRow != null) {
                    string = crossRow.getString().toString().toLowerCase().trim();
                    crossColumn.setContent(string);
                }
            } else {
                crossColumn.setType(Type.top);
            }
            arrayList2.add(crossColumn);
        }
        n = xSSFSheet.getLastRowNum();
        for (int i = 0; i <= n; ++i) {
            xSSFRow = xSSFSheet.getRow(i);
            crossRow = new CrossRow();
            crossRow.setNumber(i + 1);
            if (i < crossHeader.getRowSpan()) {
                crossRow.setType(Type.top);
                string = xSSFRow.getCell(crossHeader.getColSpan());
                xSSFCell = string.getCellComment();
                if (xSSFCell != null) {
                    object = xSSFCell.getString().toString().toLowerCase().trim();
                    crossRow.setContent((String)object);
                }
            } else {
                crossRow.setType(Type.left);
            }
            arrayList.add(crossRow);
        }
        ArrayList<CellContent> arrayList3 = new ArrayList<CellContent>();
        for (int i = 0; i <= n; ++i) {
            crossRow = xSSFSheet.getRow(i);
            for (int j = 0; j < n2; ++j) {
                if (i == 0 && j == 0 || (xSSFCell = crossRow.getCell(j)) == null || (object = this.a(i, j, xSSFSheet)) == null) continue;
                String string2 = this.a(xSSFCell);
                CellContent cellContent = new CellContent();
                cellContent.setCol(j + 1);
                cellContent.setRow(i + 1);
                cellContent.setContent(string2);
                if (i < crossHeader.getRowSpan()) {
                    cellContent.setType("condition");
                    cellContent.setSpan(((Span)object).getCol());
                }
                if (j < crossHeader.getColSpan()) {
                    cellContent.setType("condition");
                    cellContent.setSpan(((Span)object).getRow());
                }
                arrayList3.add(cellContent);
            }
        }
        xSSFWorkbook.close();
        CrossData crossData = new CrossData();
        crossData.setCells(arrayList3);
        crossData.setColumns(arrayList2);
        crossData.setRows(arrayList);
        crossData.setHeader(crossHeader);
        return crossData;
    }

    private CrossHeader a(XSSFSheet xSSFSheet) {
        Span span = this.a(0, 0, xSSFSheet);
        if (span == null) {
            throw new InfoException("\u5bfc\u5165\u7684Excel\u4e0d\u5408\u6cd5!");
        }
        CrossHeader crossHeader = new CrossHeader();
        crossHeader.setRowSpan(span.getRow());
        crossHeader.setColSpan(span.getCol());
        XSSFRow xSSFRow = xSSFSheet.getRow(0);
        XSSFCell xSSFCell = xSSFRow.getCell(0);
        crossHeader.setContent(this.a(xSSFCell));
        return crossHeader;
    }

    private Span a(int n, int n2, XSSFSheet xSSFSheet) {
        List list = xSSFSheet.getMergedRegions();
        for (CellRangeAddress cellRangeAddress : list) {
            if (cellRangeAddress.getFirstColumn() == n2 && cellRangeAddress.getFirstRow() == n) {
                int n3 = cellRangeAddress.getLastRow() - cellRangeAddress.getFirstRow();
                if (n3 > 0) {
                    ++n3;
                }
                Span span = new Span();
                span.setRow(n3);
                int n4 = cellRangeAddress.getLastColumn() - cellRangeAddress.getFirstColumn();
                if (n4 > 0) {
                    ++n4;
                }
                span.setCol(n4);
                return span;
            }
            if (n2 < cellRangeAddress.getFirstColumn() || n2 > cellRangeAddress.getLastColumn() || n < cellRangeAddress.getFirstRow() || n > cellRangeAddress.getLastRow()) continue;
            return null;
        }
        Span span = new Span();
        span.setRow(1);
        span.setCol(1);
        return span;
    }

    private String a(XSSFCell xSSFCell) {
        String string = null;
        CellType cellType = xSSFCell.getCellTypeEnum();
        switch (cellType) {
            case STRING: {
                string = xSSFCell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                string = String.valueOf(xSSFCell.getBooleanCellValue());
                break;
            }
            case NUMERIC: {
                xSSFCell.setCellType(CellType.STRING);
                string = xSSFCell.getStringCellValue();
                break;
            }
        }
        return string;
    }

    @Override
    public String url() {
        return "/crosstab";
    }
}

