/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.editor.decision.table;

import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.editor.decision.CellContent;
import com.bstek.urule.console.editor.decision.table.ContentRow;
import com.bstek.urule.console.editor.decision.table.DecisionTableXmlBuilder;
import com.bstek.urule.console.editor.decision.table.Header;
import com.bstek.urule.console.editor.decision.table.HeaderType;
import com.bstek.urule.console.editor.decision.table.TableData;
import com.bstek.urule.console.util.FileUtils;
import com.bstek.urule.model.table.DecisionTable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class TableServletHandler
extends ApiServletHandler {
    public void excel(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        InputStream inputStream = FileUtils.uploadFile(httpServletRequest).getInputStream();
        TableData tableData = this.a(inputStream);
        inputStream.close();
        DecisionTableXmlBuilder decisionTableXmlBuilder = new DecisionTableXmlBuilder(tableData);
        DecisionTable decisionTable = decisionTableXmlBuilder.buildTable();
        this.a(httpServletResponse, decisionTable);
    }

    private TableData a(InputStream inputStream) throws Exception {
        XSSFWorkbook xSSFWorkbook = new XSSFWorkbook(inputStream);
        if (xSSFWorkbook.getNumberOfSheets() == 0) {
            xSSFWorkbook.close();
            throw new InfoException("\u5bfc\u5165Excel\u4e0d\u5408\u6cd5\uff01");
        }
        ArrayList<ContentRow> arrayList = new ArrayList<ContentRow>();
        XSSFSheet xSSFSheet = xSSFWorkbook.getSheetAt(0);
        int n = xSSFSheet.getLastRowNum();
        List<Header> list = this.a(xSSFSheet);
        for (int i = 1; i <= n; ++i) {
            XSSFRow xSSFRow = xSSFSheet.getRow(i);
            ContentRow contentRow = new ContentRow();
            arrayList.add(contentRow);
            ArrayList<CellContent> arrayList2 = new ArrayList<CellContent>();
            contentRow.setContents(arrayList2);
            for (int j = 0; j < list.size(); ++j) {
                int n2;
                XSSFCell xSSFCell = xSSFRow.getCell(j);
                if (xSSFCell == null || (n2 = this.a(i, j, xSSFSheet)) == 0) continue;
                Header header = list.get(j);
                CellContent cellContent = new CellContent();
                if (n2 > 0) {
                    cellContent.setSpan(n2);
                }
                cellContent.setHeader(header);
                CellType cellType = xSSFCell.getCellTypeEnum();
                switch (cellType) {
                    case STRING: {
                        cellContent.setContent(xSSFCell.getStringCellValue());
                        break;
                    }
                    case BOOLEAN: {
                        cellContent.setContent(String.valueOf(xSSFCell.getBooleanCellValue()));
                        break;
                    }
                    case NUMERIC: {
                        xSSFCell.setCellType(CellType.STRING);
                        cellContent.setContent(xSSFCell.getStringCellValue());
                        break;
                    }
                }
                cellContent.setRow(i - 1);
                cellContent.setCol(j);
                arrayList2.add(cellContent);
            }
        }
        xSSFWorkbook.close();
        return new TableData(list, arrayList);
    }

    private int a(int n, int n2, XSSFSheet xSSFSheet) {
        List list = xSSFSheet.getMergedRegions();
        for (CellRangeAddress cellRangeAddress : list) {
            if (cellRangeAddress.getFirstColumn() == n2 && cellRangeAddress.getFirstRow() == n) {
                int n3 = cellRangeAddress.getLastRow() - cellRangeAddress.getFirstRow();
                return ++n3;
            }
            if (n2 < cellRangeAddress.getFirstColumn() || n2 > cellRangeAddress.getLastColumn() || n < cellRangeAddress.getFirstRow() || n > cellRangeAddress.getLastRow()) continue;
            return 0;
        }
        return -1;
    }

    private List<Header> a(XSSFSheet xSSFSheet) {
        XSSFRow xSSFRow = xSSFSheet.getRow(0);
        ArrayList<Header> arrayList = new ArrayList<Header>();
        int n = xSSFRow.getLastCellNum();
        for (int i = 0; i < n; ++i) {
            XSSFCell xSSFCell = xSSFRow.getCell(i);
            String string = xSSFCell.getStringCellValue();
            if (StringUtils.isBlank((String)string)) continue;
            Header header = new Header();
            arrayList.add(header);
            header.setName(string);
            XSSFComment xSSFComment = xSSFCell.getCellComment();
            if (xSSFComment == null) continue;
            String string2 = xSSFComment.getString().toString().toLowerCase().trim();
            if (string2.equals("\u8d4b\u503c") || string2.equals("assign")) {
                header.setType(HeaderType.assign);
                continue;
            }
            if (!string2.equals("\u63a7\u5236\u53f0\u8f93\u51fa") && !string2.equals("out")) continue;
            header.setType(HeaderType.out);
        }
        return arrayList;
    }

    @Override
    public String url() {
        return "/table";
    }
}

