/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.editor.diagram;

import com.bstek.urule.Utils;
import com.bstek.urule.builder.KnowledgeBase;
import com.bstek.urule.builder.ResourceBase;
import com.bstek.urule.builder.resource.Resource;
import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.database.manager.packet.PacketManager;
import com.bstek.urule.console.database.manager.packet.packge.PacketPackageManager;
import com.bstek.urule.console.database.model.Packet;
import com.bstek.urule.console.database.model.PacketPackage;
import com.bstek.urule.console.database.model.PacketType;
import com.bstek.urule.console.editor.diagram.Box;
import com.bstek.urule.console.editor.diagram.Diagram;
import com.bstek.urule.console.editor.diagram.DiagramContext;
import com.bstek.urule.console.editor.diagram.Edge;
import com.bstek.urule.console.editor.diagram.NodeInfo;
import com.bstek.urule.console.editor.diagram.ReteNodeLayout;
import com.bstek.urule.console.util.ServiceUtils;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.model.Node;
import com.bstek.urule.model.rete.AndNode;
import com.bstek.urule.model.rete.CriteriaNode;
import com.bstek.urule.model.rete.Line;
import com.bstek.urule.model.rete.OrNode;
import com.bstek.urule.model.rete.Rete;
import com.bstek.urule.model.rete.TerminalNode;
import com.bstek.urule.runtime.KnowledgePackage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ReteDiagramServletHandler
extends ApiServletHandler {
    private ReteNodeLayout e = new ReteNodeLayout();
    private final int f = 30;
    private final int g = 30;

    public void buildSingleRuleReteDiagram(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("content");
        ResourceBase resourceBase = ServiceUtils.getKnowledgeBuilder().newResourceBase();
        Resource resource = new Resource(-1L, string, "singlerule", null);
        resourceBase.getResources().add(resource);
        KnowledgeBase knowledgeBase = ServiceUtils.getKnowledgeBuilder().buildKnowledgeBase(resourceBase);
        Rete rete = knowledgeBase.getRete();
        Diagram diagram = this.a(rete);
        this.a(httpServletResponse, diagram);
    }

    public void loadDiagramData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("files");
        string = Utils.decodeURL((String)string);
        ResourceBase resourceBase = ServiceUtils.getKnowledgeBuilder().newResourceBase();
        String[] knowledgePackage = string.split(";");
        Rete rete = null;
        if (StringUtils.isBlank(string)) {
            KnowledgePackage object = this.c(httpServletRequest);
            rete = object.getRete();
        } else {
            for (String string2 : knowledgePackage) {
                resourceBase.addResource(string2);
            }
            KnowledgeBase knowledgeBase = ServiceUtils.getKnowledgeBuilder().buildKnowledgeBase(resourceBase);
            rete = knowledgeBase.getRete();
        }
        Diagram diagram = this.a(rete);
        this.a(httpServletResponse, diagram);
    }

    private Diagram a(Rete rete) {
        Object object2;
        HashMap<Node, NodeInfo> hashMap = new HashMap<Node, NodeInfo>();
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        NodeInfo nodeInfo = new NodeInfo();
        DiagramContext diagramContext = new DiagramContext(arrayList, hashMap);
        nodeInfo.setId(diagramContext.nextId());
        nodeInfo.setLabel("\u5165\u53e3");
        nodeInfo.setColor("#98AFC7");
        nodeInfo.setWidth(30);
        nodeInfo.setHeight(30);
        nodeInfo.setRoundCorner(10);
        List list = rete.getObjectTypeNodes();
        int n = 1;
        for (Object object2 : list) {
            NodeInfo nodeInfo2 = new NodeInfo();
            nodeInfo2.setId(diagramContext.nextId());
            nodeInfo2.setLabel("T");
            String string = object2.getObjectTypeClass();
            if (string.equals("__*__")) {
                nodeInfo2.setTitle("\u5426\u5219");
            } else {
                nodeInfo2.setTitle(string);
            }
            nodeInfo2.setColor("#97CBFF");
            nodeInfo2.setLevel(n);
            nodeInfo2.setWidth(30);
            nodeInfo2.setHeight(30);
            nodeInfo2.setRoundCorner(5);
            nodeInfo.addChild(nodeInfo2);
            List list2 = object2.getLines();
            if (list2 == null) continue;
            int n2 = n + 1;
            for (Line line : list2) {
                Edge edge = new Edge(nodeInfo.getId(), nodeInfo2.getId());
                arrayList.add(edge);
                this.a(line, diagramContext, nodeInfo2, n2);
            }
        }
        Box box = this.e.layout(nodeInfo);
        object2 = new Diagram(arrayList, nodeInfo);
        if (box != null) {
            ((Diagram)object2).setWidth(box.getWidth() + 500);
            ((Diagram)object2).setHeight(box.getHeight() + 300);
        }
        return object2;
    }

    private void a(Line line, DiagramContext diagramContext, NodeInfo nodeInfo, int n) {
        CriteriaNode criteriaNode;
        Node node = line.getTo();
        if (node == null) {
            return;
        }
        Map<Node, NodeInfo> map = diagramContext.getNodeMap();
        NodeInfo nodeInfo2 = null;
        if (map.containsKey(node)) {
            nodeInfo2 = map.get(node);
            diagramContext.addEdge(new Edge(nodeInfo.getId(), nodeInfo2.getId()));
            return;
        }
        List list = null;
        nodeInfo2 = new NodeInfo();
        nodeInfo2.setLevel(n);
        nodeInfo2.setId(diagramContext.nextId());
        nodeInfo2.setWidth(30);
        nodeInfo2.setHeight(30);
        if (node instanceof CriteriaNode) {
            criteriaNode = (CriteriaNode)node;
            nodeInfo2.setColor("#B3D9D9");
            nodeInfo2.setLabel("C");
            nodeInfo2.setTitle(criteriaNode.getCriteriaInfo());
            nodeInfo2.setRoundCorner(30);
            list = criteriaNode.getLines();
        } else if (node instanceof AndNode) {
            criteriaNode = (AndNode)node;
            list = criteriaNode.getLines();
            nodeInfo2.setColor("#DAB1D5");
            nodeInfo2.setLabel("AND");
            nodeInfo2.setRoundCorner(15);
        } else if (node instanceof OrNode) {
            criteriaNode = (OrNode)node;
            list = criteriaNode.getLines();
            nodeInfo2.setColor("#82D900");
            nodeInfo2.setLabel("OR");
            nodeInfo2.setRoundCorner(15);
        } else if (node instanceof TerminalNode) {
            criteriaNode = (TerminalNode)node;
            nodeInfo2.setColor("orange");
            nodeInfo2.setLabel(criteriaNode.getRule().getName());
            nodeInfo2.setTitle(criteriaNode.getRule().getName());
            nodeInfo2.setRoundCorner(0);
        }
        map.put(node, nodeInfo2);
        nodeInfo.addChild(nodeInfo2);
        diagramContext.addEdge(new Edge(nodeInfo.getId(), nodeInfo2.getId()));
        if (list == null) {
            return;
        }
        int n2 = n + 1;
        for (Line line2 : list) {
            this.a(line2, diagramContext, nodeInfo2, n2);
        }
    }

    private KnowledgePackage c(HttpServletRequest httpServletRequest) {
        Packet packet;
        String string = httpServletRequest.getParameter("packetId");
        if (StringUtils.isNotBlank(string) && (packet = PacketManager.ins.load(Long.valueOf(string))).getType().equals((Object)PacketType.upload)) {
            PacketPackage packetPackage = packet.getPacketPackage();
            if (packetPackage == null || packetPackage.getId() == 0L) {
                throw new InfoException("\u8bf7\u5148\u4e0a\u4f20\u77e5\u8bc6\u5305");
            }
            String string2 = PacketPackageManager.ins.loadContent(packetPackage.getId());
            if (StringUtils.isBlank(string2)) {
                throw new InfoException("\u8bf7\u5148\u4e0a\u4f20\u77e5\u8bc6\u5305");
            }
            KnowledgePackage knowledgePackage = Utils.stringToKnowledgePackage((String)string2);
            return knowledgePackage;
        }
        return null;
    }

    @Override
    public String url() {
        return "/rete";
    }
}

