/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.editor.execute;

import com.bstek.urule.console.editor.execute.MultiData;
import com.bstek.urule.console.editor.execute.SubObject;
import com.bstek.urule.console.editor.execute.VariableCategoryNotFoundException;
import com.bstek.urule.console.editor.execute.VariableNotFoundException;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.GeneralEntity;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.library.variable.Variable;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public class JsonBuilder {
    private Logger a = Logger.getGlobal();
    private static JsonBuilder b = new JsonBuilder();

    public static JsonBuilder getInstance() {
        return b;
    }

    public Object buildComplexObject(Object object, Map<String, VariableCategory> map) throws Exception {
        if (object instanceof String) {
            String string = object.toString().trim();
            ObjectMapper objectMapper = JsonMapper.builder().build();
            if (string.startsWith("{") && string.endsWith("}")) {
                Map map2 = (Map)objectMapper.readValue(string, HashMap.class);
                Object v = map2.get("data");
                Object v2 = map2.get("name");
                Object v3 = map2.get("fields");
                if (v != null && v instanceof List) {
                    List list = (List)v;
                    return this.a(list, map);
                }
                if (v2 != null && v3 != null) {
                    return this.a(map, map2);
                }
                return map2;
            }
            if (string.startsWith("[") && string.endsWith("]")) {
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                List list = (List)objectMapper.readValue(string, ArrayList.class);
                for (Object e : list) {
                    if (e instanceof Map) {
                        Map map3 = (Map)e;
                        Object v = map3.get("name");
                        Object v4 = map3.get("fields");
                        if (v != null && v4 != null) {
                            arrayList.add(this.a(map, map3));
                            continue;
                        }
                        arrayList.add((Map<String, Object>)e);
                        continue;
                    }
                    arrayList.add((Map<String, Object>)e);
                }
                return arrayList;
            }
            if (!this.a(string)) {
                return string;
            }
            try {
                Base64 base64 = new Base64();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(base64.decode(string.getBytes("utf-8")));
                GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
                byte[] byArray = new byte[1024];
                int n = -1;
                while ((n = gZIPInputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byteArrayInputStream.close();
                gZIPInputStream.close();
                String string2 = byteArrayOutputStream.toString();
                return this.buildComplexObject(string2, map);
            }
            catch (Exception exception) {
                this.a.warning(exception.getMessage());
                this.a.warning("Fail to decode data :" + string + "");
                return string;
            }
        }
        if (object instanceof List) {
            ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
            List list = (List)object;
            for (Object e : list) {
                if (e instanceof Map) {
                    Map map4 = (Map)e;
                    arrayList.add(this.a(map, map4));
                    continue;
                }
                arrayList.add((Map<String, Object>)e);
            }
            return arrayList;
        }
        if (object instanceof Map) {
            Map map5 = (Map)object;
            Object v = map5.get("name");
            Object v5 = map5.get("fields");
            if (v != null && v5 != null) {
                return this.a(map, map5);
            }
            return map5;
        }
        return object;
    }

    private MultiData a(List<Object> list, Map<String, VariableCategory> map) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : list) {
            Object object2;
            Object object3;
            Object object4;
            if (object instanceof List) {
                object4 = new ArrayList();
                arrayList.add(object4);
                object3 = (List)object;
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    Object e = object2.next();
                    if (!(e instanceof Map)) {
                        this.a.warning("[" + e + "] is not a map data!");
                        continue;
                    }
                    Map map2 = (Map)e;
                    Object v = map2.get("name");
                    Object v2 = map2.get("fields");
                    if (v != null && v2 != null) {
                        object4.add(this.a(map, map2));
                        continue;
                    }
                    object4.add(map2);
                }
                continue;
            }
            object4 = (Map)object;
            object3 = object4.get("name");
            object2 = object4.get("fields");
            if (object3 != null && object2 != null) {
                arrayList.add(this.a(map, (Map<String, Object>)object4));
                continue;
            }
            arrayList.add(object4);
        }
        return new MultiData(arrayList);
    }

    private boolean a(String string) {
        String string2 = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        return string.matches(string2);
    }

    private Map<String, Object> a(Map<String, VariableCategory> map, Map<String, Object> map2) throws Exception {
        Object object;
        Object object2;
        Variable variable;
        Object object3;
        Object object42;
        Iterator iterator;
        String string = (String)map2.get("name");
        Object object5 = map2.get("fields");
        if (StringUtils.isBlank((String)string)) {
            if (object5 == null) {
                return map2;
            }
            if (object5 instanceof List || object5 instanceof Map) {
                throw new RuleException("\u590d\u6742\u5bf9\u8c61\u503c\u3010" + map2 + "\u3011\u9700\u8981\u4e00\u4e2a\u540d\u4e3a\"name\"\u7684\u5c5e\u6027\u503c\u6765\u6807\u660e\u5f53\u524d\u5bf9\u8c61\u7c7b\u578b");
            }
            return map2;
        }
        if (object5 == null || object5 instanceof List && object5 instanceof Map) {
            return map2;
        }
        VariableCategory variableCategory = map.get(string);
        if (variableCategory == null) {
            throw new VariableCategoryNotFoundException("\u53d8\u91cf\u5bf9\u8c61\u3010" + string + "\u3011\u672a\u5b9a\u4e49!");
        }
        GeneralEntity generalEntity = null;
        generalEntity = string.equals("\u53c2\u6570") ? new HashMap() : new GeneralEntity(variableCategory.getClazz());
        if (object5 instanceof List) {
            iterator = (List)object5;
            Iterator<Object> iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                object42 = (Map)iterator2.next();
                object3 = (String)object42.get("name");
                if (StringUtils.isBlank((String)object3)) {
                    throw new RuleException("\u5b50\u5bf9\u8c61\u9700\u8981\u6709\u4e00\u4e2a\u540d\u4e3aname\u7684\u5c5e\u6027\u6765\u6807\u660e\u5bf9\u8c61\u7684\u5177\u4f53\u5c5e\u6027\u540d");
                }
                variable = null;
                try {
                    variable = this.findVariable(variableCategory, (String)object3);
                }
                catch (Exception exception) {
                    continue;
                }
                object2 = object42.get("value");
                if (object2 == null && (object2 = variable.getDefaultValue()) == null) continue;
                object = variable.getType();
                if (object.equals((Object)Datatype.Object) || object.equals((Object)Datatype.List)) {
                    generalEntity.put(variable.getName(), this.buildComplexObject(object2, map));
                    continue;
                }
                generalEntity.put(variable.getName(), object.convert(object2));
            }
        } else if (object5 instanceof Map) {
            iterator = (Map)object5;
            for (Object object42 : iterator.keySet()) {
                object3 = iterator.get(object42);
                if (object3 == null) continue;
                variable = null;
                try {
                    variable = this.findVariable(variableCategory, (String)object42);
                }
                catch (Exception exception) {
                    continue;
                }
                object2 = variable.getType();
                object = this.findSubObject(variable.getName(), (Map<String, Object>)generalEntity);
                Map<String, Object> map3 = ((SubObject)object).getMap();
                if (object2.equals((Object)Datatype.Object) || object2.equals((Object)Datatype.List)) {
                    map3.put(((SubObject)object).getName(), this.buildComplexObject(object3, map));
                    continue;
                }
                map3.put(((SubObject)object).getName(), object2.convert(object3));
            }
        } else {
            throw new RuleException("\u590d\u6742\u5bf9\u8c61\u503c\u3010" + map2 + "\u3011\u7684\"fields\"\u7684\u5c5e\u6027\u503c\u5fc5\u987b\u662f\u4e00\u4e2a\u5bf9\u8c61\u7c7b\u578b\u6216\u96c6\u5408\u7c7b\u578b.");
        }
        for (Iterator<Object> iterator2 : variableCategory.getVariables()) {
            object42 = iterator2.getName();
            if (generalEntity.containsKey(object42) || (object3 = iterator2.getDefaultValue()) == null) continue;
            variable = iterator2.getType();
            object3 = variable.equals((Object)Datatype.String) ? variable.convert(object3) : (variable.equals((Object)Datatype.List) || variable.equals((Object)Datatype.Object) || variable.equals((Object)Datatype.Set) || variable.equals((Object)Datatype.Map) ? JsonBuilder.getInstance().buildComplexObject(object3, map) : variable.convert(object3));
            generalEntity.put(object42, object3);
        }
        return generalEntity;
    }

    public SubObject findSubObject(String string, Map<String, Object> map) {
        Map map2 = map;
        String[] stringArray = string.split("\\.");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            String string2 = stringArray[i];
            if (map.containsKey(string2)) {
                map2 = (Map)map.get(string2);
                continue;
            }
            map2.put(string2, new HashMap());
            map2 = (Map)map.get(string2);
        }
        string = stringArray[stringArray.length - 1];
        return new SubObject(string, map2);
    }

    public VariableCategory findVariableCategory(List<VariableCategory> list, String string) {
        for (VariableCategory variableCategory : list) {
            if (!string.equals(variableCategory.getName()) && !string.equals(variableCategory.getClazz())) continue;
            return variableCategory;
        }
        throw new VariableCategoryNotFoundException("\u53d8\u91cf\u5bf9\u8c61\u3010" + string + "\u3011\u672a\u5b9a\u4e49!");
    }

    public Variable findVariable(VariableCategory variableCategory, String string) {
        if (variableCategory.getVariableNames().containsKey(string)) {
            return (Variable)variableCategory.getVariableNames().get(string);
        }
        if (variableCategory.getVariableLabels().containsKey(string)) {
            return (Variable)variableCategory.getVariableLabels().get(string);
        }
        throw new VariableNotFoundException("\u53d8\u91cf\u5bf9\u8c61\u3010" + variableCategory.getName() + "\u3011\u4e2d\u672a\u5b9a\u4e49\u540d\u4e3a\u3010" + string + "\u3011\u5b57\u6bb5\uff01");
    }

    public Map<String, VariableCategory> buildVariableCategoriesMap(List<VariableCategory> list) {
        HashMap<String, VariableCategory> hashMap = new HashMap<String, VariableCategory>();
        for (VariableCategory variableCategory : list) {
            hashMap.put(variableCategory.getName(), variableCategory);
        }
        return hashMap;
    }
}

