/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.editor.jar;

import com.bstek.urule.Utils;
import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.database.manager.jar.DynamicJarManager;
import com.bstek.urule.console.database.model.DynamicJar;
import com.bstek.urule.console.database.model.UrlConfig;
import com.bstek.urule.console.database.model.UrlType;
import com.bstek.urule.console.database.service.url.UrlService;
import com.bstek.urule.console.editor.jar.HostJarCacheAdapter;
import com.bstek.urule.console.editor.jar.JarCacheAdapter;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.security.URuleAuthorization;
import com.bstek.urule.console.util.FileUtils;
import com.bstek.urule.console.util.ServiceUtils;
import com.bstek.urule.console.util.UploadFile;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.runtime.DynamicSpringConfigLoader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class JarServletHandler
extends ApiServletHandler {
    private DynamicSpringConfigLoader e = ServiceUtils.getDynamicSpringConfigLoader();
    private JarCacheAdapter f = null;

    public JarCacheAdapter getJarCacheAdapter() {
        if (this.f == null) {
            try {
                this.f = (JarCacheAdapter)Utils.getApplicationContext().getBean(JarCacheAdapter.BEAN_ID);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                this.f = new HostJarCacheAdapter();
            }
        }
        return this.f;
    }

    @URuleAuthorization(authType="group", model="dynamicJar", code="manager")
    public void deploy(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = this.e.buildDynamicJarsStoreDirectPath();
        int n = DynamicJarManager.ins.createJarFiles(string);
        HashMap<String, List<Object>> hashMap = new HashMap<String, List<Object>>();
        String string2 = httpServletRequest.getParameter("groupId");
        if (n > 0) {
            this.e.loadDynamicJars(string);
            List<Map<String, Object>> list = this.getJarCacheAdapter().loadDynamicJars(string2, UrlType.cluster);
            List<UrlConfig> list2 = UrlService.ins.load(UrlType.client, string2).getList();
            hashMap.put("clients", list2);
            hashMap.put("result", list);
        }
        this.a(httpServletResponse, hashMap);
    }

    @URuleAuthorization(authType="group", model="dynamicJar", code="manager")
    public void sendToClients(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("groupId");
        List<Map<String, Object>> list = this.getJarCacheAdapter().loadDynamicJars(string, UrlType.client);
        this.a(httpServletResponse, list);
    }

    public void load(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("groupId");
        this.a(httpServletResponse, DynamicJarManager.ins.newQuery().groupId(string).list());
    }

    @URuleAuthorization(authType="group", model="dynamicJar", code="manager")
    public void add(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        DynamicJar dynamicJar = new DynamicJar();
        dynamicJar.setGroupId(httpServletRequest.getParameter("groupId"));
        dynamicJar.setDesc(httpServletRequest.getParameter("desc"));
        dynamicJar.setCreateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        DynamicJarManager.ins.add(dynamicJar);
        this.a(httpServletResponse, dynamicJar);
    }

    @URuleAuthorization(authType="group", model="dynamicJar", code="manager")
    public void update(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        DynamicJar dynamicJar = new DynamicJar();
        dynamicJar.setDesc(httpServletRequest.getParameter("desc"));
        dynamicJar.setId(Long.valueOf(httpServletRequest.getParameter("id")));
        dynamicJar.setUpdateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        DynamicJarManager.ins.update(dynamicJar);
    }

    @URuleAuthorization(authType="group", model="dynamicJar", code="manager")
    public void download(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("id"));
        byte[] byArray = DynamicJarManager.ins.loadJar(l);
        DynamicJar dynamicJar = DynamicJarManager.ins.load(l);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        FileUtils.downloadFile(dynamicJar.getName(), byteArrayInputStream, httpServletResponse);
        IOUtils.closeQuietly((InputStream)byteArrayInputStream);
    }

    @URuleAuthorization(authType="group", model="dynamicJar", code="manager")
    public void upload(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("id"));
        String string = SecurityUtils.getLoginUsername(httpServletRequest);
        UploadFile uploadFile = FileUtils.uploadFile(httpServletRequest);
        if (!uploadFile.getName().toLowerCase().endsWith(".jar")) {
            throw new RuleException("\u8bf7\u4e0a\u4f20\u540e\u7f00\u540d\u4e3a.jar\u7684\u6587\u4ef6");
        }
        InputStream inputStream = uploadFile.getInputStream();
        byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        DynamicJarManager.ins.updateJar(l, uploadFile.getName(), string, byArray);
        this.a(httpServletResponse, uploadFile.getName());
    }

    @URuleAuthorization(authType="group", model="dynamicJar", code="manager")
    public void delete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("id"));
        DynamicJarManager.ins.delete(l);
    }

    @Override
    public String url() {
        return "/jar";
    }
}

