/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.editor.packet;

import com.bstek.urule.Utils;
import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.ContextHolder;
import com.bstek.urule.console.Transactional;
import com.bstek.urule.console.admin.log.SystemLogUtils;
import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.file.FileManager;
import com.bstek.urule.console.database.manager.packet.PacketBuilder;
import com.bstek.urule.console.database.manager.packet.PacketManager;
import com.bstek.urule.console.database.manager.packet.apply.PacketApplyManager;
import com.bstek.urule.console.database.manager.packet.apply.PacketApplyQuery;
import com.bstek.urule.console.database.manager.packet.deploy.PacketDeployManager;
import com.bstek.urule.console.database.manager.packet.deploy.file.PacketDeployFileManager;
import com.bstek.urule.console.database.manager.project.ProjectManager;
import com.bstek.urule.console.database.model.ApplyStatus;
import com.bstek.urule.console.database.model.ApplyType;
import com.bstek.urule.console.database.model.Packet;
import com.bstek.urule.console.database.model.PacketApply;
import com.bstek.urule.console.database.model.PacketDeploy;
import com.bstek.urule.console.database.model.PacketDeployFile;
import com.bstek.urule.console.database.model.PacketFile;
import com.bstek.urule.console.database.model.Page;
import com.bstek.urule.console.database.model.RuleFile;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.security.URuleAuthorization;
import com.bstek.urule.console.type.RuleFileType;
import com.bstek.urule.console.util.MD5Utils;
import com.bstek.urule.exception.RuleAssertException;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.runtime.KnowledgePackage;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PacketApplyServletHandler
extends ApiServletHandler {
    public void get(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("applyId"));
        this.a(httpServletResponse, PacketApplyManager.ins.load(l));
    }

    public void load(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("packetId"));
        ApplyType applyType = ApplyType.valueOf(httpServletRequest.getParameter("type"));
        int n = Integer.valueOf(httpServletRequest.getParameter("pageIndex"));
        int n2 = Integer.valueOf(httpServletRequest.getParameter("pageSize"));
        PacketApplyQuery packetApplyQuery = PacketApplyManager.ins.newQuery();
        packetApplyQuery.titleLike(httpServletRequest.getParameter("title"));
        packetApplyQuery.createUserLike(httpServletRequest.getParameter("createUser"));
        Page<PacketApply> page = packetApplyQuery.packetId(l).type(applyType).projectId(ContextHolder.getProjectId()).paging(n, n2);
        List<PacketApply> list = PacketApplyManager.ins.newQuery().packetId(l).projectId(ContextHolder.getProjectId()).type(applyType).statusIn(new ApplyStatus[]{ApplyStatus.pending, ApplyStatus.reject}).list();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("page", page);
        if (list.size() == 0) {
            hashMap.put("add", true);
        } else {
            hashMap.put("add", false);
        }
        this.a(httpServletResponse, hashMap);
    }

    @Transactional
    @URuleAuthorization(authType="project", code="manager", model="rule_knowledge")
    public void add(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string;
        long l = Long.valueOf(httpServletRequest.getParameter("packetId"));
        Packet packet = PacketManager.ins.load(l);
        PacketApply packetApply = new PacketApply();
        ApplyType applyType = ApplyType.valueOf(httpServletRequest.getParameter("type"));
        packetApply.setType(applyType);
        packetApply.setTitle(httpServletRequest.getParameter("title"));
        packetApply.setDesc(httpServletRequest.getParameter("desc"));
        packetApply.setPacketId(l);
        packetApply.setProjectId(packet.getProjectId());
        long l2 = IDGenerator.getInstance().nextId(IDType.DEPLOYED_PACKET);
        packetApply.setDeployedPacketId(l2);
        packetApply.setCreateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        packetApply.setApprover(ProjectManager.ins.getApproveUser(PacketManager.ins.load(l).getProjectId(), applyType));
        PacketApplyManager.ins.add(packetApply);
        if (applyType.equals((Object)ApplyType.deploy)) {
            string = PacketBuilder.ins.buildKnowledgePackage(l);
            String string2 = Utils.knowledgePackageToString((KnowledgePackage)string);
            try {
                Utils.stringToKnowledgePackageWrapper((String)string2);
            }
            catch (RuleException ruleException) {
                Exception exception = (Exception)ruleException.getCause();
                throw new RuleAssertException("\u77e5\u8bc6\u5305[" + l + "]\u5bf9\u5e94\u7684\u89c4\u5219\u683c\u5f0f\u975e\u6cd5!", exception);
            }
            PacketDeploy packetDeploy = new PacketDeploy();
            packetDeploy.setId(l2);
            packetDeploy.setApplyId(packetApply.getId());
            packetDeploy.setDigest(MD5Utils.stringToMD5(string2));
            packetDeploy.setContent(string2);
            packetDeploy.setCreateUser(packetApply.getCreateUser());
            packetDeploy.setDesc(httpServletRequest.getParameter("deployDesc"));
            packetDeploy.setPacketId(l);
            packetDeploy.setStatus(ApplyStatus.pending);
            packetDeploy.setProjectId(packet.getProjectId());
            PacketDeployManager.ins.add(packetDeploy);
            for (PacketFile packetFile : packet.getFiles()) {
                RuleFile ruleFile = FileManager.ins.get(packetFile.getFileId());
                PacketDeployFile packetDeployFile = new PacketDeployFile();
                packetDeployFile.setPacketDeployId(packetDeploy.getId());
                packetDeployFile.setFileId(packetFile.getFileId());
                packetDeployFile.setProjectId(packet.getProjectId());
                packetDeployFile.setDigest(ruleFile.getDigest());
                packetDeployFile.setPath(packetFile.getPath());
                packetDeployFile.setVersion(packetFile.getVersion());
                String string3 = FileManager.ins.loadContent(packetFile.getFileId());
                packetDeployFile.setContent(string3);
                packetDeployFile.setCreateUser(packetApply.getCreateUser());
                packetDeployFile.setDigest(MD5Utils.stringToMD5(string3));
                PacketDeployFileManager.ins.add(packetDeployFile);
            }
        }
        string = "";
        if (applyType.equals((Object)ApplyType.deploy)) {
            string = "\u7533\u8bf7\u53d1\u5e03\u77e5\u8bc6\u5305[" + packet.getName() + "]";
        } else if (applyType.equals((Object)ApplyType.disable)) {
            string = "\u7533\u8bf7\u7981\u7528\u77e5\u8bc6\u5305[" + packet.getName() + "]";
        } else if (applyType.equals((Object)ApplyType.enable)) {
            string = "\u7533\u8bf7\u542f\u7528\u77e5\u8bc6\u5305[" + packet.getName() + "]";
        }
        SystemLogUtils.addProjectOperationLog(RuleFileType.Knowledge.name(), applyType.name(), packet.getId(), string);
        this.a(httpServletResponse, packetApply);
    }

    @Transactional
    @URuleAuthorization(authType="project", code="manager", model="rule_knowledge")
    public void delete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("id"));
        PacketApply packetApply = PacketApplyManager.ins.load(l);
        if (!packetApply.getStatus().equals((Object)ApplyStatus.pending)) {
            throw new RuleException("\u5f53\u524d\u7533\u8bf7\u3010" + packetApply.getTitle() + "\u3011\u4e0d\u5904\u4e8e\u3010\u5f85\u5ba1\u6279\u3011\u72b6\u6001\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\uff01");
        }
        PacketApplyManager.ins.delete(l);
        if (packetApply.getType().equals((Object)ApplyType.deploy)) {
            PacketDeployManager.ins.deleteByApplyId(l);
        }
    }

    @Override
    public String url() {
        return "/apply";
    }
}

