/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.editor.packet;

import com.bstek.urule.Utils;
import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.TransactionalInvoke;
import com.bstek.urule.console.admin.log.SystemLogUtils;
import com.bstek.urule.console.cache.packet.PacketCache;
import com.bstek.urule.console.cache.packet.PacketCacheImpl;
import com.bstek.urule.console.cache.packet.PacketConfig;
import com.bstek.urule.console.cache.packet.PacketData;
import com.bstek.urule.console.database.manager.packet.PacketManager;
import com.bstek.urule.console.database.manager.packet.deploy.PacketDeployManager;
import com.bstek.urule.console.database.manager.packet.deploy.PacketDeployQuery;
import com.bstek.urule.console.database.manager.packet.packge.PacketPackageManager;
import com.bstek.urule.console.database.model.ApplyStatus;
import com.bstek.urule.console.database.model.ApplyType;
import com.bstek.urule.console.database.model.Packet;
import com.bstek.urule.console.database.model.PacketDeploy;
import com.bstek.urule.console.database.model.PacketPackage;
import com.bstek.urule.console.database.model.PacketType;
import com.bstek.urule.console.database.model.Page;
import com.bstek.urule.console.database.model.UrlConfig;
import com.bstek.urule.console.database.model.UrlType;
import com.bstek.urule.console.database.service.url.UrlService;
import com.bstek.urule.console.editor.todo.PacketPublishListener;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.security.URuleAuthorization;
import com.bstek.urule.console.type.RuleFileType;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.runtime.KnowledgePackageImpl;
import com.bstek.urule.runtime.KnowledgePackageWrapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class PacketDeployedServletHandler
extends ApiServletHandler {
    PacketPublishListener e = null;

    @Override
    public void init() {
        super.init();
        if (this.e == null) {
            try {
                this.e = (PacketPublishListener)Utils.getApplicationContext().getBean("urule.packetPublishListener");
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
    }

    public void load(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        int n = Integer.valueOf(httpServletRequest.getParameter("pageIndex"));
        int n2 = Integer.valueOf(httpServletRequest.getParameter("pageSize"));
        PacketDeployQuery packetDeployQuery = PacketDeployManager.ins.newQuery();
        packetDeployQuery.versionLike(httpServletRequest.getParameter("version"));
        packetDeployQuery.descLike(httpServletRequest.getParameter("desc"));
        String string = httpServletRequest.getParameter("status");
        if (StringUtils.isNotBlank(string)) {
            packetDeployQuery.status(ApplyStatus.valueOf(string));
        }
        Page<PacketDeploy> page = packetDeployQuery.packetId(Long.valueOf(httpServletRequest.getParameter("packetId"))).paging(n, n2);
        this.a(httpServletResponse, page);
    }

    public void loadCompareContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("leftId"));
        PacketDeploy packetDeploy = PacketDeployManager.ins.load(l);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("left", packetDeploy.getContent());
        long l2 = Long.valueOf(httpServletRequest.getParameter("rightId"));
        PacketDeploy packetDeploy2 = PacketDeployManager.ins.load(l2);
        hashMap.put("right", packetDeploy2.getContent());
        this.a(httpServletResponse, hashMap);
    }

    @URuleAuthorization(authType="project", code="manager", model="rule_knowledge")
    public void enable(final HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        final long l = Long.valueOf(httpServletRequest.getParameter("id"));
        final PacketDeploy packetDeploy = PacketDeployManager.ins.load(l);
        final Packet packet = PacketManager.ins.load(packetDeploy.getPacketId());
        this.a(new TransactionalInvoke(){

            @Override
            public void doTransactional() {
                if (PacketDeployedServletHandler.this.e != null) {
                    PacketDeployedServletHandler.this.e.beforeActive(packet, packetDeploy.getVersion());
                }
                PacketDeployManager.ins.disableAll(packetDeploy.getPacketId());
                PacketDeployManager.ins.updateEnable(l, true);
                packet.setUpdateDate(new Date());
                packet.setUpdateUser(SecurityUtils.getLoginUsername(httpServletRequest));
                PacketManager.ins.update(packet);
                if (PacketDeployedServletHandler.this.e != null) {
                    PacketDeployedServletHandler.this.e.afterActive(packet, packetDeploy.getVersion());
                }
                String string = "\u77e5\u8bc6\u5305[" + packet.getName() + "]\u7248\u672c\u5207\u6362\u4e3a:" + packetDeploy.getVersion();
                SystemLogUtils.addProjectOperationLog(RuleFileType.Knowledge.name(), ApplyType.enable.name(), packet.getId(), string);
            }
        });
        List<Map<String, Object>> list = PacketCache.ins.refreshPacket(packetDeploy.getPacketId());
        this.a(httpServletResponse, list);
    }

    @URuleAuthorization(authType="project", code="manager", model="rule_knowledge")
    public void export(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("id"));
        PacketDeploy packetDeploy = PacketDeployManager.ins.load(l);
        String string = packetDeploy.getPacketId() + ".data";
        httpServletResponse.setHeader("Content-Disposition", "attachment; filename=" + new String(string.getBytes("UTF-8"), "ISO8859-1"));
        byte[] byArray = Utils.compress((String)packetDeploy.getContent());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        IOUtils.copy((InputStream)byteArrayInputStream, (OutputStream)servletOutputStream);
        IOUtils.closeQuietly((InputStream)byteArrayInputStream);
        IOUtils.closeQuietly((OutputStream)servletOutputStream);
    }

    public void clients(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("groupId");
        List<UrlConfig> list = UrlService.ins.load(UrlType.client, string).getList();
        this.a(httpServletResponse, list);
    }

    @URuleAuthorization(authType="project", code="manager", model="rule_knowledge")
    public void push(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        long l = Long.valueOf(httpServletRequest.getParameter("packetId"));
        String string = httpServletRequest.getParameter("id");
        String string2 = null;
        String string3 = null;
        if (StringUtils.isNotBlank(string)) {
            long l2 = Long.valueOf(string);
            object = PacketDeployManager.ins.load(l2);
            string2 = ((PacketDeploy)object).getContent();
            string3 = ((PacketDeploy)object).getVersion();
        } else {
            string2 = this.c(httpServletRequest);
        }
        KnowledgePackageWrapper knowledgePackageWrapper = Utils.stringToKnowledgePackageWrapper((String)string2);
        KnowledgePackageImpl knowledgePackageImpl = (KnowledgePackageImpl)knowledgePackageWrapper.getKnowledgePackage();
        knowledgePackageImpl.initForActiveVersion();
        object = PacketManager.ins.load(l);
        PacketData packetData = new PacketData((Packet)object, knowledgePackageWrapper);
        PacketConfig packetConfig = packetData.getPacket();
        knowledgePackageImpl.setMonitor(((Packet)object).isAuditEnable());
        knowledgePackageImpl.setInputData(packetConfig.getAuditInput());
        knowledgePackageImpl.setOutputData(packetConfig.getAuditOutput());
        knowledgePackageImpl.setPackageInfo(String.valueOf(l));
        knowledgePackageImpl.setVersion(string3);
        String string4 = httpServletRequest.getParameter("groupId");
        List<Map<String, Object>> list = ((PacketCacheImpl)PacketCache.ins).getClientPacketCacheAdapter().pushPacketToClients(string4, packetData);
        this.a(httpServletResponse, list);
    }

    private String c(HttpServletRequest httpServletRequest) {
        Packet packet;
        String string = httpServletRequest.getParameter("packetId");
        if (StringUtils.isNotBlank(string) && (packet = PacketManager.ins.load(Long.valueOf(string))).getType().equals((Object)PacketType.upload)) {
            PacketPackage packetPackage = packet.getPacketPackage();
            if (packetPackage == null || packetPackage.getId() == 0L) {
                throw new InfoException("\u8bf7\u5148\u4e0a\u4f20\u77e5\u8bc6\u5305");
            }
            String string2 = PacketPackageManager.ins.loadContent(packetPackage.getId());
            if (StringUtils.isBlank(string2)) {
                throw new InfoException("\u8bf7\u5148\u4e0a\u4f20\u77e5\u8bc6\u5305");
            }
            return string2;
        }
        return null;
    }

    @Override
    public String url() {
        return "/deploy";
    }
}

