/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.editor.packet;

import com.bstek.urule.Utils;
import com.bstek.urule.builder.KnowledgeBase;
import com.bstek.urule.builder.KnowledgeBuilder;
import com.bstek.urule.builder.ResourceBase;
import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.ContextHolder;
import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.database.manager.packet.PacketManager;
import com.bstek.urule.console.database.manager.packet.packge.PacketPackageManager;
import com.bstek.urule.console.database.manager.packet.scenario.ScenarioManager;
import com.bstek.urule.console.database.model.Packet;
import com.bstek.urule.console.database.model.PacketPackage;
import com.bstek.urule.console.database.model.PacketType;
import com.bstek.urule.console.database.model.Scenario;
import com.bstek.urule.console.editor.execute.JsonBuilder;
import com.bstek.urule.console.editor.packet.scenario.DataField;
import com.bstek.urule.console.editor.packet.scenario.ResultWrapper;
import com.bstek.urule.console.editor.packet.scenario.ScenarioTestExecuting;
import com.bstek.urule.console.editor.packet.scenario.SimulateData;
import com.bstek.urule.console.editor.packet.scenario.TestScenario;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.security.URuleAuthorization;
import com.bstek.urule.console.util.FileUtils;
import com.bstek.urule.console.util.ServiceUtils;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.console.util.UploadFile;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.model.rule.Op;
import com.bstek.urule.runtime.KnowledgePackage;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;

public class PacketScenarioServletHandler
extends ApiServletHandler {
    private ScenarioTestExecuting e = new ScenarioTestExecuting();

    public void doTest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        TestScenario testScenario = this.c(httpServletRequest);
        String string = httpServletRequest.getParameter("packageName");
        String string2 = httpServletRequest.getParameter("enableLog");
        boolean bl = false;
        if (StringUtils.isNotBlank(string2)) {
            bl = Boolean.valueOf(string2);
        }
        string = Utils.decodeURL((String)string);
        List list = null;
        KnowledgePackage knowledgePackage = this.f(httpServletRequest);
        if (knowledgePackage != null) {
            list = knowledgePackage.getVariableCategories();
        } else {
            object = this.e(httpServletRequest);
            knowledgePackage = object.getKnowledgePackage();
            list = object.getResourceLibrary().getVariableCategories();
        }
        object = JsonBuilder.getInstance().buildVariableCategoriesMap(list);
        ResultWrapper resultWrapper = this.e.doTest(testScenario, knowledgePackage, (Map<String, VariableCategory>)object, bl);
        resultWrapper.setPackageName(string);
        resultWrapper.setScenarioName(testScenario.getName());
        this.a(httpServletResponse, resultWrapper);
    }

    private TestScenario c(HttpServletRequest httpServletRequest) throws Exception {
        DataField dataField;
        ArrayList<DataField> arrayList;
        SimulateData simulateData;
        long l = Long.valueOf(httpServletRequest.getParameter("id"));
        Scenario scenario = ScenarioManager.ins.load(l);
        TestScenario testScenario = new TestScenario();
        testScenario.setName(scenario.getName());
        testScenario.setId(scenario.getId());
        testScenario.setCreateUser(scenario.getCreateUser());
        testScenario.setCreateDate(scenario.getCreateDate());
        testScenario.setDesc(scenario.getDesc());
        ObjectMapper objectMapper = JsonMapper.builder().build();
        List list = (List)objectMapper.readValue(scenario.getInputData(), ArrayList.class);
        List list2 = (List)objectMapper.readValue(scenario.getOutputData(), ArrayList.class);
        ArrayList<SimulateData> arrayList2 = new ArrayList<SimulateData>();
        ArrayList<SimulateData> arrayList3 = new ArrayList<SimulateData>();
        testScenario.setInputData(arrayList2);
        testScenario.setOutputData(arrayList3);
        for (Map map : list) {
            simulateData = new SimulateData();
            simulateData.setUuid((String)map.get("categoryUuid"));
            simulateData.setName((String)map.get("name"));
            arrayList = new ArrayList<DataField>();
            simulateData.setFields(arrayList);
            arrayList2.add(simulateData);
            for (Map map2 : (List)map.get("fields")) {
                dataField = new DataField();
                dataField.setUuid((String)map2.get("uuid"));
                dataField.setName((String)map2.get("name"));
                dataField.setLabel((String)map2.get("label"));
                dataField.setDatatype(Datatype.valueOf((String)((String)map2.get("datatype"))));
                arrayList.add(dataField);
            }
        }
        for (Map map : list2) {
            simulateData = new SimulateData();
            simulateData.setUuid((String)map.get("categoryUuid"));
            simulateData.setName((String)map.get("name"));
            arrayList = new ArrayList();
            simulateData.setFields(arrayList);
            arrayList3.add(simulateData);
            for (Map map2 : (List)map.get("fields")) {
                dataField = new DataField();
                dataField.setUuid((String)map2.get("uuid"));
                dataField.setName((String)map2.get("name"));
                dataField.setLabel((String)map2.get("label"));
                dataField.setDatatype(Datatype.valueOf((String)((String)map2.get("datatype"))));
                dataField.setOp(Op.valueOf((String)((String)map2.get("op"))));
                arrayList.add(dataField);
            }
        }
        return testScenario;
    }

    public void load(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Long l = Long.valueOf(httpServletRequest.getParameter("packetId"));
        List<Scenario> list = ScenarioManager.ins.newQuery().packetId(l).list();
        this.a(httpServletResponse, list);
    }

    @URuleAuthorization(authType="project", code="manager", model="rule_knowledge")
    public void add(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Scenario scenario = new Scenario();
        scenario.setName(httpServletRequest.getParameter("name"));
        scenario.setDesc(httpServletRequest.getParameter("desc"));
        scenario.setProjectId(ContextHolder.getProjectId());
        scenario.setInputData(httpServletRequest.getParameter("inputData"));
        scenario.setOutputData(httpServletRequest.getParameter("outputData"));
        scenario.setPacketId(Long.valueOf(httpServletRequest.getParameter("packetId")));
        scenario.setCreateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        scenario.setUpdateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        Scenario scenario2 = ScenarioManager.ins.add(scenario);
        this.a(httpServletResponse, scenario2);
    }

    @URuleAuthorization(authType="project", code="manager", model="rule_knowledge")
    public void update(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("id"));
        Scenario scenario = ScenarioManager.ins.load(l);
        scenario.setName(httpServletRequest.getParameter("name"));
        scenario.setDesc(httpServletRequest.getParameter("desc"));
        scenario.setInputData(httpServletRequest.getParameter("inputData"));
        scenario.setOutputData(httpServletRequest.getParameter("outputData"));
        scenario.setUpdateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        ScenarioManager.ins.update(scenario);
    }

    @URuleAuthorization(authType="project", code="manager", model="rule_knowledge")
    public void delete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ScenarioManager.ins.delete(Long.valueOf(httpServletRequest.getParameter("id")));
    }

    @URuleAuthorization(authType="project", code="manager", model="rule_knowledge")
    public void uploadExcel(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Long l = Long.valueOf(httpServletRequest.getParameter("id"));
        UploadFile uploadFile = FileUtils.uploadFile(httpServletRequest);
        InputStream inputStream = uploadFile.getInputStream();
        byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
        inputStream.close();
        String string = SecurityUtils.getLoginUsername(httpServletRequest);
        ScenarioManager.ins.uploadExcel(l, string, byArray);
        Scenario scenario = ScenarioManager.ins.load(l);
        scenario.setExcelFileName(uploadFile.getName());
        ScenarioManager.ins.update(scenario);
    }

    @URuleAuthorization(authType="project", code="manager", model="rule_knowledge")
    public void downloadExcel(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Long l = Long.valueOf(httpServletRequest.getParameter("id"));
        Scenario scenario = ScenarioManager.ins.load(l);
        byte[] byArray = ScenarioManager.ins.loadExcelFile(l);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        FileUtils.downloadFile(scenario.getExcelFileName(), byteArrayInputStream, httpServletResponse);
        byteArrayInputStream.close();
    }

    public void loadLibs(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        KnowledgePackage knowledgePackage = this.f(httpServletRequest);
        if (knowledgePackage != null) {
            this.a(httpServletResponse, knowledgePackage.getVariableCategories());
            return;
        }
        List<VariableCategory> list = this.d(httpServletRequest);
        this.a(httpServletResponse, list);
    }

    private List<VariableCategory> d(HttpServletRequest httpServletRequest) throws IOException {
        KnowledgePackage knowledgePackage = this.f(httpServletRequest);
        if (knowledgePackage != null) {
            return knowledgePackage.getVariableCategories();
        }
        KnowledgeBase knowledgeBase = this.e(httpServletRequest);
        List list = knowledgeBase.getResourceLibrary().getVariableCategories();
        return list;
    }

    private KnowledgeBase e(HttpServletRequest httpServletRequest) throws IOException {
        KnowledgeBase knowledgeBase;
        String string = httpServletRequest.getParameter("files");
        string = Utils.decodeURL((String)string);
        KnowledgeBuilder knowledgeBuilder = ServiceUtils.getKnowledgeBuilder();
        ResourceBase resourceBase = knowledgeBuilder.newResourceBase();
        for (String string2 : knowledgeBase = string.split(";")) {
            resourceBase.addResource(string2);
        }
        KnowledgeBase knowledgeBase2 = knowledgeBuilder.buildKnowledgeBase(resourceBase);
        return knowledgeBase2;
    }

    public void generateTemplateExcel(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("input");
        String string2 = httpServletRequest.getParameter("output");
        string = URLDecoder.decode(string, "utf-8");
        string2 = URLDecoder.decode(string2, "utf-8");
        ObjectMapper objectMapper = new ObjectMapper();
        List list = (List)objectMapper.readValue(string, ArrayList.class);
        List list2 = (List)objectMapper.readValue(string2, ArrayList.class);
        SXSSFWorkbook sXSSFWorkbook = new SXSSFWorkbook();
        this.a(list, sXSSFWorkbook);
        this.b(list2, sXSSFWorkbook);
        httpServletResponse.setContentType("application/x-xls");
        httpServletResponse.setHeader("Content-Disposition", "attachment; filename=urule-scenario-test-template.xlsx");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        sXSSFWorkbook.write((OutputStream)servletOutputStream);
        servletOutputStream.flush();
        servletOutputStream.close();
        sXSSFWorkbook.close();
    }

    /*
     * WARNING - void declaration
     */
    private void a(List<Map<String, Object>> list, SXSSFWorkbook sXSSFWorkbook) {
        Object object;
        List list2;
        Object object2;
        String string;
        Cell cell;
        XSSFCellStyle xSSFCellStyle;
        XSSFCellStyle xSSFCellStyle2 = (XSSFCellStyle)sXSSFWorkbook.createCellStyle();
        xSSFCellStyle2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        xSSFCellStyle2.setFillForegroundColor(new XSSFColor(new Color(147, 228, 15)));
        this.a(xSSFCellStyle2);
        XSSFCellStyle xSSFCellStyle3 = (XSSFCellStyle)sXSSFWorkbook.createCellStyle();
        xSSFCellStyle3.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        xSSFCellStyle3.setFillForegroundColor(new XSSFColor(new Color(111, 208, 215)));
        this.a(xSSFCellStyle3);
        SXSSFSheet sXSSFSheet = sXSSFWorkbook.createSheet("\u573a\u666f");
        Row row = sXSSFSheet.createRow(0);
        row.createCell(0);
        row.createCell(1);
        int n = 2;
        int n2 = 0;
        for (Map<String, Object> xSSFColor2 : list) {
            xSSFCellStyle = xSSFCellStyle2;
            if (n2 % 2 == 0) {
                xSSFCellStyle = xSSFCellStyle3;
            }
            ++n2;
            cell = row.createCell(n);
            cell.setCellStyle((CellStyle)xSSFCellStyle);
            string = (String)xSSFColor2.get("name");
            cell.setCellValue(string);
            object2 = (List)xSSFColor2.get("fields");
            if (object2.size() > 1) {
                void var15_18;
                boolean bl = false;
                while (var15_18 < object2.size() - 1) {
                    void var16_22 = var15_18 + n + true;
                    row.createCell((int)var16_22).setCellStyle((CellStyle)xSSFCellStyle);
                    ++var15_18;
                }
                CellRangeAddress i = new CellRangeAddress(0, 0, n, n + object2.size() - 1);
                sXSSFSheet.addMergedRegion(i);
            }
            n += object2.size();
        }
        XSSFCellStyle xSSFCellStyle4 = (XSSFCellStyle)sXSSFWorkbook.createCellStyle();
        XSSFColor xSSFColor = new XSSFColor(new Color(197, 218, 115));
        xSSFCellStyle4.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        xSSFCellStyle4.setFillForegroundColor(xSSFColor);
        this.a(xSSFCellStyle4);
        xSSFCellStyle = sXSSFSheet.createRow(1);
        cell = xSSFCellStyle.createCell(0);
        cell.setCellStyle((CellStyle)xSSFCellStyle4);
        cell.setCellValue("\u65b9\u6848\u6807\u8bc6");
        string = xSSFCellStyle.createCell(1);
        string.setCellStyle((CellStyle)xSSFCellStyle4);
        string.setCellValue("\u63cf\u8ff0");
        sXSSFSheet.setColumnWidth(1, 3000);
        n = 2;
        n2 = 0;
        for (Map map : list) {
            XSSFCellStyle xSSFCellStyle5 = xSSFCellStyle2;
            if (n2 % 2 == 0) {
                xSSFCellStyle5 = xSSFCellStyle3;
            }
            ++n2;
            list2 = (List)map.get("fields");
            for (Map map2 : list2) {
                object = xSSFCellStyle.createCell(n);
                object.setCellStyle((CellStyle)xSSFCellStyle5);
                sXSSFSheet.setColumnWidth(n, 3300);
                String string2 = (String)map2.get("label");
                object.setCellValue(string2);
                ++n;
            }
        }
        object2 = sXSSFSheet.createRow(2);
        XSSFCellStyle xSSFCellStyle6 = (XSSFCellStyle)sXSSFWorkbook.createCellStyle();
        this.a(xSSFCellStyle6);
        Cell cell2 = object2.createCell(0);
        cell2.setCellStyle((CellStyle)xSSFCellStyle6);
        this.a(xSSFCellStyle6);
        cell2.setCellValue("1");
        list2 = object2.createCell(1);
        list2.setCellStyle((CellStyle)xSSFCellStyle6);
        list2.setCellValue("\u63cf\u8ff0\u5185\u5bb9");
        n = 2;
        for (Map map : list) {
            object = (List)map.get("fields");
            for (int i = 0; i < object.size(); ++i) {
                Cell cell3 = object2.createCell(n);
                cell3.setCellStyle((CellStyle)xSSFCellStyle6);
                ++n;
            }
        }
    }

    private void b(List<Map<String, Object>> list, SXSSFWorkbook sXSSFWorkbook) {
        String string;
        XSSFCellStyle xSSFCellStyle;
        Object object;
        Cell cell;
        XSSFCellStyle xSSFCellStyle2;
        XSSFCellStyle xSSFCellStyle3 = (XSSFCellStyle)sXSSFWorkbook.createCellStyle();
        xSSFCellStyle3.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        xSSFCellStyle3.setFillForegroundColor(new XSSFColor(new Color(255, 235, 69)));
        this.a(xSSFCellStyle3);
        XSSFCellStyle xSSFCellStyle4 = (XSSFCellStyle)sXSSFWorkbook.createCellStyle();
        xSSFCellStyle4.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        xSSFCellStyle4.setFillForegroundColor(new XSSFColor(new Color(248, 255, 217)));
        this.a(xSSFCellStyle4);
        SXSSFSheet sXSSFSheet = sXSSFWorkbook.createSheet("\u9884\u671f\u7ed3\u679c");
        Row row = sXSSFSheet.createRow(0);
        row.createCell(0);
        int n = 1;
        int n2 = 0;
        for (Map<String, Object> xSSFColor2 : list) {
            xSSFCellStyle2 = xSSFCellStyle3;
            if (n2 % 2 == 0) {
                xSSFCellStyle2 = xSSFCellStyle4;
            }
            ++n2;
            cell = row.createCell(n);
            cell.setCellStyle((CellStyle)xSSFCellStyle2);
            object = (String)xSSFColor2.get("name");
            cell.setCellValue((String)object);
            List list2 = (List)xSSFColor2.get("fields");
            if (list2.size() > 1) {
                for (int i = 0; i < list2.size() - 1; ++i) {
                    int n3 = i + n + 1;
                    row.createCell(n3).setCellStyle((CellStyle)xSSFCellStyle2);
                }
                xSSFCellStyle = new CellRangeAddress(0, 0, n, n + list2.size() - 1);
                sXSSFSheet.addMergedRegion((CellRangeAddress)xSSFCellStyle);
            }
            n += list2.size();
        }
        XSSFCellStyle xSSFCellStyle5 = (XSSFCellStyle)sXSSFWorkbook.createCellStyle();
        XSSFColor xSSFColor = new XSSFColor(new Color(197, 218, 115));
        xSSFCellStyle5.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        xSSFCellStyle5.setFillForegroundColor(xSSFColor);
        this.a(xSSFCellStyle5);
        xSSFCellStyle2 = sXSSFSheet.createRow(1);
        cell = xSSFCellStyle2.createCell(0);
        cell.setCellStyle((CellStyle)xSSFCellStyle5);
        cell.setCellValue("\u65b9\u6848\u6807\u8bc6");
        n = 1;
        n2 = 0;
        for (Map map : list) {
            xSSFCellStyle = xSSFCellStyle3;
            if (n2 % 2 == 0) {
                xSSFCellStyle = xSSFCellStyle4;
            }
            ++n2;
            List list3 = (List)map.get("fields");
            for (Object object2 : list3) {
                Cell cell2 = xSSFCellStyle2.createCell(n);
                cell2.setCellStyle((CellStyle)xSSFCellStyle);
                sXSSFSheet.setColumnWidth(n, 4000);
                string = (String)object2.get("label");
                String string2 = (String)object2.get("op");
                Op op = Op.valueOf((String)string2);
                String string3 = "\"" + string + "\"" + op.toString();
                cell2.setCellValue(string3);
                ++n;
            }
        }
        object = sXSSFSheet.createRow(2);
        XSSFCellStyle xSSFCellStyle6 = (XSSFCellStyle)sXSSFWorkbook.createCellStyle();
        this.a(xSSFCellStyle6);
        xSSFCellStyle = object.createCell(0);
        xSSFCellStyle.setCellStyle((CellStyle)xSSFCellStyle6);
        xSSFCellStyle.setCellValue("1");
        n = 1;
        for (Map<String, Object> map : list) {
            Object object2;
            object2 = (List)map.get("fields");
            for (int i = 0; i < object2.size(); ++i) {
                string = object.createCell(n);
                string.setCellStyle((CellStyle)xSSFCellStyle6);
                ++n;
            }
        }
    }

    private void a(XSSFCellStyle xSSFCellStyle) {
        xSSFCellStyle.setBorderLeft(BorderStyle.THIN);
        xSSFCellStyle.setBorderRight(BorderStyle.THIN);
        xSSFCellStyle.setBorderTop(BorderStyle.THIN);
        xSSFCellStyle.setBorderBottom(BorderStyle.THIN);
        xSSFCellStyle.setWrapText(true);
    }

    private KnowledgePackage f(HttpServletRequest httpServletRequest) {
        Packet packet;
        String string = httpServletRequest.getParameter("packetId");
        if (StringUtils.isNotBlank(string) && (packet = PacketManager.ins.load(Long.valueOf(string))).getType().equals((Object)PacketType.upload)) {
            PacketPackage packetPackage = packet.getPacketPackage();
            if (packetPackage == null || packetPackage.getId() == 0L) {
                throw new InfoException("\u8bf7\u5148\u4e0a\u4f20\u77e5\u8bc6\u5305");
            }
            String string2 = PacketPackageManager.ins.loadContent(packetPackage.getId());
            if (StringUtils.isBlank(string2)) {
                throw new InfoException("\u8bf7\u5148\u4e0a\u4f20\u77e5\u8bc6\u5305");
            }
            KnowledgePackage knowledgePackage = Utils.stringToKnowledgePackage((String)string2);
            return knowledgePackage;
        }
        return null;
    }

    @Override
    public String url() {
        return "/scenario";
    }
}

