/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.editor.packet;

import com.bstek.urule.Utils;
import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.ContextHolder;
import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.Transactional;
import com.bstek.urule.console.TransactionalInvoke;
import com.bstek.urule.console.admin.log.SystemLogUtils;
import com.bstek.urule.console.cache.packet.PacketCache;
import com.bstek.urule.console.cache.packet.PacketCacheImpl;
import com.bstek.urule.console.database.manager.packet.PacketManager;
import com.bstek.urule.console.database.manager.packet.PacketQuery;
import com.bstek.urule.console.database.manager.packet.file.PacketFileManager;
import com.bstek.urule.console.database.manager.packet.packge.PacketPackageManager;
import com.bstek.urule.console.database.manager.project.ProjectManager;
import com.bstek.urule.console.database.model.Packet;
import com.bstek.urule.console.database.model.PacketFile;
import com.bstek.urule.console.database.model.PacketPackage;
import com.bstek.urule.console.database.model.PacketType;
import com.bstek.urule.console.database.model.Page;
import com.bstek.urule.console.database.model.Project;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.security.URuleAuthorization;
import com.bstek.urule.console.type.RuleFileType;
import com.bstek.urule.console.util.StringUtils;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;

public class PacketServletHandler
extends ApiServletHandler {
    public void load(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string;
        String string2;
        String string3;
        String string4;
        int n = Integer.valueOf(httpServletRequest.getParameter("pageIndex"));
        int n2 = Integer.valueOf(httpServletRequest.getParameter("pageSize"));
        PacketQuery packetQuery = PacketManager.ins.newQuery();
        packetQuery.nameLike(httpServletRequest.getParameter("name"));
        packetQuery.descLike(httpServletRequest.getParameter("desc"));
        packetQuery.createUserLike(httpServletRequest.getParameter("createUser"));
        packetQuery.projectId(Long.valueOf(httpServletRequest.getParameter("projectId")));
        packetQuery.typeLike(httpServletRequest.getParameter("type"));
        String string5 = httpServletRequest.getParameter("enable");
        if (StringUtils.isNotBlank(string5)) {
            packetQuery.enable(Boolean.valueOf(string5));
        }
        if (StringUtils.isNotBlank(string4 = httpServletRequest.getParameter("id"))) {
            packetQuery.idLike(string4);
        }
        if (StringUtils.isNotBlank(string3 = httpServletRequest.getParameter("code"))) {
            packetQuery.codeLike(string3);
        }
        if (StringUtils.isNotBlank(string2 = httpServletRequest.getParameter("restEnable"))) {
            packetQuery.restEnable(Boolean.valueOf(string2));
        }
        if (StringUtils.isNotBlank(string = httpServletRequest.getParameter("auditEnable"))) {
            packetQuery.auditEnable(Boolean.valueOf(string));
        }
        Page<Packet> page = packetQuery.paging(n, n2);
        this.a(httpServletResponse, page);
    }

    @URuleAuthorization(authType="project", code="manager", model="rule_knowledge")
    public void add(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        Packet packet = new Packet();
        String string = httpServletRequest.getParameter("code");
        if (StringUtils.isNotBlank(string)) {
            if (StringUtils.hasChineseChar(string = string.trim())) {
                throw new InfoException("\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u4e2d\u6587\u5b57\u7b26<br>The code cannot contain Chinese characters.");
            }
            if (StringUtils.hasSpecialChar(string)) {
                throw new InfoException("\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26.<br/>The code cannot contain special characters.");
            }
            packet.setCode(string);
            object = PacketManager.ins.newQuery().code(string).list();
            if (object.size() > 0) {
                Project project = ProjectManager.ins.get(object.get(0).getProjectId());
                String string2 = "Duplicate packet code " + string + "!<br/>The code under " + project.getName() + "(" + packet.getProjectId() + ") of " + project.getGroupId() + " repeated";
                throw new InfoException(string2);
            }
        }
        packet.setCreateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        packet.setProjectId(ContextHolder.getProjectId());
        packet.setName(httpServletRequest.getParameter("name"));
        packet.setDesc(httpServletRequest.getParameter("desc"));
        object = PacketType.valueOf(httpServletRequest.getParameter("type"));
        packet.setType((PacketType)((Object)object));
        packet.setInputData(httpServletRequest.getParameter("inputData"));
        packet.setOutputData(httpServletRequest.getParameter("outputData"));
        packet.setEnable(Boolean.valueOf(httpServletRequest.getParameter("enable")));
        packet.setProjectId(Long.valueOf(httpServletRequest.getParameter("projectId")));
        PacketManager.ins.add(packet);
        SystemLogUtils.addProjectOperationLog(RuleFileType.Knowledge.name(), "add", packet.getId(), "\u6dfb\u52a0\u77e5\u8bc6\u5305[" + packet.getName() + "]");
        this.a(httpServletResponse, packet);
    }

    @URuleAuthorization(authType="project", code="manager", model="rule_knowledge")
    public void update(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Packet packet = new Packet();
        Long l = Long.valueOf(httpServletRequest.getParameter("id"));
        String string = httpServletRequest.getParameter("code");
        Packet packet2 = PacketManager.ins.load(l);
        packet.setId(l);
        packet.setUpdateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        packet.setName(httpServletRequest.getParameter("name"));
        packet.setCode(string);
        packet.setDesc(httpServletRequest.getParameter("desc"));
        packet.setInputData(httpServletRequest.getParameter("inputData"));
        packet.setOutputData(httpServletRequest.getParameter("outputData"));
        packet.setEnable(Boolean.valueOf(httpServletRequest.getParameter("enable")));
        packet.setUpdateDate(new Date());
        if (packet2 != null) {
            PacketManager.ins.update(packet);
            if (StringUtils.isNotBlank(packet2.getCode()) && !packet2.getCode().equals(string)) {
                String string2 = packet2.getCode();
                ((PacketCacheImpl)PacketCache.ins).removePacket(string2);
                PacketCache.ins.refreshPacket(l);
            }
        }
        packet = PacketManager.ins.load(packet.getId());
        SystemLogUtils.addProjectOperationLog(RuleFileType.Knowledge.name(), "update", packet.getId(), "\u66f4\u65b0\u77e5\u8bc6\u5305[" + packet.getName() + "]");
        this.a(httpServletResponse, packet);
    }

    @URuleAuthorization(authType="project", code="manager", model="rule_knowledge")
    public void updateAuditConfig(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Packet packet = new Packet();
        packet.setId(Long.valueOf(httpServletRequest.getParameter("id")));
        packet.setUpdateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        packet.setAuditEnable(Boolean.valueOf(httpServletRequest.getParameter("auditEnable")));
        if (packet.isAuditEnable()) {
            packet.setAuditInput(httpServletRequest.getParameter("auditInput"));
            packet.setAuditOutput(httpServletRequest.getParameter("auditOutput"));
        }
        packet.setUpdateDate(new Date());
        PacketManager.ins.updateAuditConfig(packet);
        PacketCache.ins.refreshPacketConfig(packet.getId());
        PacketCache.ins.refreshPacket(packet.getId());
        this.a(httpServletResponse, packet);
    }

    @URuleAuthorization(authType="project", code="manager", model="rule_knowledge")
    public void delete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("id"));
        Packet packet = PacketManager.ins.load(l);
        PacketManager.ins.delete(l);
        ((PacketCacheImpl)PacketCache.ins).removePacket(l);
        ((PacketCacheImpl)PacketCache.ins).removePacket(packet.getCode());
        SystemLogUtils.addProjectOperationLog(RuleFileType.Knowledge.name(), "delete", packet.getId(), "\u5220\u9664\u77e5\u8bc6\u5305[" + packet.getName() + "]");
    }

    @Transactional
    @URuleAuthorization(authType="project", code="manager", model="rule_knowledge")
    public void addFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PacketFile packetFile = new PacketFile();
        packetFile.setCreateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        packetFile.setFileId(Long.valueOf(httpServletRequest.getParameter("fileId")));
        packetFile.setPacketId(Long.valueOf(httpServletRequest.getParameter("packetId")));
        packetFile.setDesc(httpServletRequest.getParameter("desc"));
        packetFile.setPath(httpServletRequest.getParameter("path"));
        packetFile.setVersion(httpServletRequest.getParameter("version"));
        Packet packet = PacketManager.ins.load(packetFile.getPacketId());
        packetFile.setProjectId(packet.getProjectId());
        PacketFileManager.ins.add(packetFile);
        packet.setUpdateDate(new Date());
        packet.setUpdateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        PacketManager.ins.update(packet);
        SystemLogUtils.addProjectOperationLog(RuleFileType.Knowledge.name(), "update", packet.getId(), "\u6dfb\u52a0\u89c4\u5219\u6587\u4ef6\u5230\u77e5\u8bc6\u5305[" + packet.getName() + "]");
        this.a(httpServletResponse, packetFile);
    }

    @URuleAuthorization(authType="project", code="manager", model="rule_knowledge")
    public void uploadPackage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        List<Map<String, Object>> list;
        Object object;
        Object object22;
        PacketPackage packetPackage = new PacketPackage();
        packetPackage.setCreateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        packetPackage.setUpdateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        packetPackage.setPacketId(Long.valueOf(httpServletRequest.getParameter("packetId")));
        packetPackage.setUpdateDate(new Date());
        Packet packet = PacketManager.ins.load(packetPackage.getPacketId());
        packetPackage.setProjectId(packet.getProjectId());
        DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
        ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
        servletFileUpload.setHeaderEncoding("UTF-8");
        List list2 = servletFileUpload.parseRequest(httpServletRequest);
        for (Object object22 : list2) {
            object = object22.getFieldName();
            if (((String)object).equals("file")) {
                list = object22.getInputStream();
                String string = Utils.uncompress((byte[])IOUtils.toByteArray((InputStream)((Object)list)));
                packetPackage.setContent(string);
                continue;
            }
            if (!((String)object).contentEquals("desc")) continue;
            list = object22.getString("utf-8");
            packetPackage.setDesc((String)((Object)list));
        }
        if (StringUtils.isBlank(packetPackage.getContent())) {
            throw new InfoException("\u8bf7\u4e0a\u4f20\u5bfc\u51fa\u7684\u77e5\u8bc6\u5305\u6587\u4ef6");
        }
        object22 = httpServletRequest.getParameter("id");
        this.a(new TransactionalInvoke((String)object22, packetPackage, packet, httpServletRequest){
            final /* synthetic */ String a;
            final /* synthetic */ PacketPackage b;
            final /* synthetic */ Packet c;
            final /* synthetic */ HttpServletRequest d;
            {
                this.a = string;
                this.b = packetPackage;
                this.c = packet;
                this.d = httpServletRequest;
            }

            @Override
            public void doTransactional() {
                if (StringUtils.isBlank(this.a)) {
                    PacketPackageManager.ins.add(this.b);
                } else {
                    this.b.setId(Long.valueOf(this.a));
                    PacketPackageManager.ins.update(this.b);
                }
                this.c.setUpdateDate(new Date());
                this.c.setUpdateUser(SecurityUtils.getLoginUsername(this.d));
                PacketManager.ins.update(this.c);
            }
        });
        SystemLogUtils.addProjectOperationLog(RuleFileType.Knowledge.name(), "update", packet.getId(), "\u4e0a\u4f20\u5bfc\u51fa\u77e5\u8bc6\u5305\u6587\u4ef6\u5230\u77e5\u8bc6\u5305[" + packet.getName() + "]");
        packetPackage.setContent(null);
        object = new HashMap();
        if (packet.isEnable()) {
            PacketCache.ins.cacheUploadPacketPackage(packet.getId());
            list = PacketCache.ins.refreshPacket(packet.getId());
            object.put("sendResult", list);
        } else {
            object.put("pk", packetPackage);
        }
        this.a(httpServletResponse, object);
    }

    @Transactional
    @URuleAuthorization(authType="project", code="manager", model="rule_knowledge")
    public void updateFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("id"));
        PacketFile packetFile = PacketFileManager.ins.load(l);
        packetFile.setUpdateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        packetFile.setDesc(httpServletRequest.getParameter("desc"));
        packetFile.setFileId(Long.valueOf(httpServletRequest.getParameter("fileId")));
        packetFile.setPath(httpServletRequest.getParameter("path"));
        packetFile.setVersion(httpServletRequest.getParameter("version"));
        packetFile.setUpdateDate(new Date());
        PacketFileManager.ins.update(packetFile);
        Packet packet = PacketManager.ins.load(packetFile.getPacketId());
        packet.setUpdateDate(new Date());
        packet.setUpdateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        PacketManager.ins.update(packet);
        this.a(httpServletResponse, packetFile);
    }

    @Transactional
    @URuleAuthorization(authType="project", code="manager", model="rule_knowledge")
    public void deleteFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("id"));
        PacketFile packetFile = PacketFileManager.ins.load(l);
        if (packetFile != null) {
            PacketFileManager.ins.delete(l);
            Packet packet = PacketManager.ins.load(packetFile.getPacketId());
            packet.setUpdateDate(new Date());
            packet.setUpdateUser(SecurityUtils.getLoginUsername(httpServletRequest));
            PacketManager.ins.update(packet);
        }
    }

    @Transactional
    @URuleAuthorization(authType="project", code="manager", model="rule_knowledge")
    public void updateRestConfig(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Packet packet = new Packet();
        packet.setId(Long.valueOf(httpServletRequest.getParameter("id")));
        packet.setRestEnable(Boolean.valueOf(httpServletRequest.getParameter("restEnable")));
        if (packet.isRestEnable()) {
            packet.setRestInput(httpServletRequest.getParameter("restInput"));
            packet.setRestOutput(httpServletRequest.getParameter("restOutput"));
            packet.setRestSecurityEnable(Boolean.valueOf(httpServletRequest.getParameter("restSecurityEnable")));
            packet.setRestSecurityUser(httpServletRequest.getParameter("restSecurityUser"));
            packet.setRestSecurityPassword(httpServletRequest.getParameter("restSecurityPassword"));
        }
        packet.setUpdateDate(new Date());
        packet.setUpdateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        PacketManager.ins.updateRestConfig(packet);
        PacketCache.ins.refreshPacketConfig(packet.getId());
        PacketCache.ins.refreshPacket(packet.getId());
        packet = PacketManager.ins.load(packet.getId());
        SystemLogUtils.addProjectOperationLog(RuleFileType.Knowledge.name(), "update", packet.getId(), "\u66f4\u65b0\u77e5\u8bc6\u5305[" + packet.getName() + "]");
    }

    @Override
    public String url() {
        return "/packet";
    }
}

