/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.editor.reference.file;

import com.bstek.urule.action.Action;
import com.bstek.urule.action.ExecuteMethodAction;
import com.bstek.urule.action.InvokeFile;
import com.bstek.urule.action.InvokeKnowledgePackage;
import com.bstek.urule.builder.resource.ResourceType;
import com.bstek.urule.console.database.manager.file.FileManager;
import com.bstek.urule.console.database.model.RuleFile;
import com.bstek.urule.console.editor.reference.FileReference;
import com.bstek.urule.console.editor.reference.file.ActionTemplateReference;
import com.bstek.urule.console.editor.reference.file.ComplexScorecardReference;
import com.bstek.urule.console.editor.reference.file.ConditionTemplateReference;
import com.bstek.urule.console.editor.reference.file.CrosstableReference;
import com.bstek.urule.console.editor.reference.file.DecisionTableReference;
import com.bstek.urule.console.editor.reference.file.DecisionTreeReference;
import com.bstek.urule.console.editor.reference.file.RuleSetReference;
import com.bstek.urule.console.editor.reference.file.RuleflowReference;
import com.bstek.urule.console.editor.reference.file.ScorecardReference;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.table.Cell;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class Reference {
    public abstract FileReference build(Object var1);

    public abstract boolean exist(Object var1, Long var2);

    public abstract boolean support(Object var1);

    public static Reference loadReference(Object object) {
        for (Reference reference : ReferenceInstances.a) {
            if (!reference.support(object)) continue;
            return reference;
        }
        return null;
    }

    protected List<FileReference> a(Map<String, Cell> map) {
        if (map == null) {
            return null;
        }
        ArrayList<FileReference> arrayList = new ArrayList<FileReference>();
        for (Cell cell : map.values()) {
            Action action = cell.getAction();
            FileReference fileReference = this.a(action);
            if (fileReference == null) continue;
            arrayList.add(fileReference);
        }
        return arrayList;
    }

    protected List<FileReference> a(List<Action> list) {
        ArrayList<FileReference> arrayList = new ArrayList<FileReference>();
        if (list == null) {
            return arrayList;
        }
        for (Action action : list) {
            FileReference fileReference = this.a(action);
            if (fileReference == null) continue;
            arrayList.add(fileReference);
        }
        return arrayList;
    }

    protected FileReference a(Action action) {
        if (!(action instanceof ExecuteMethodAction)) {
            return null;
        }
        ExecuteMethodAction executeMethodAction = (ExecuteMethodAction)action;
        InvokeFile invokeFile = executeMethodAction.getInvokeFile();
        InvokeKnowledgePackage invokeKnowledgePackage = executeMethodAction.getInvokeKnowledgePackage();
        if (invokeKnowledgePackage != null) {
            FileReference fileReference = new FileReference();
            fileReference.setType(ResourceType.Packet);
            fileReference.setId(invokeKnowledgePackage.getId());
            fileReference.setName(invokeKnowledgePackage.getName());
            fileReference.setPathInfo(ResourceType.Packet + ":" + invokeKnowledgePackage.getProject() + "/" + invokeKnowledgePackage.getName());
            return fileReference;
        }
        if (invokeFile != null) {
            FileReference fileReference = new FileReference();
            RuleFile ruleFile = FileManager.ins.get(invokeFile.getId());
            fileReference.setId(ruleFile.getId());
            fileReference.setType(ResourceType.valueOf((String)ruleFile.getType()));
            fileReference.setName(ruleFile.getName());
            fileReference.setPathInfo(ruleFile.getPath());
            return fileReference;
        }
        return null;
    }

    protected FileReference b(List<Library> list) {
        if (list == null) {
            return null;
        }
        FileReference fileReference = new FileReference();
        fileReference.setPathInfo("libs");
        fileReference.setName("libs");
        fileReference.setType(ResourceType.Library);
        ArrayList<FileReference> arrayList = new ArrayList<FileReference>();
        fileReference.setChildren(arrayList);
        for (Library library : list) {
            RuleFile ruleFile = FileManager.ins.get(library.getId());
            FileReference fileReference2 = this.a(ruleFile);
            fileReference2.setVersion(library.getVersion());
            arrayList.add(fileReference2);
        }
        return fileReference;
    }

    protected FileReference a(RuleFile ruleFile) {
        FileReference fileReference = new FileReference();
        fileReference.setId(ruleFile.getId());
        ResourceType resourceType = ResourceType.valueOf((String)ruleFile.getType());
        fileReference.setType(resourceType);
        fileReference.setName(ruleFile.getName());
        fileReference.setPathInfo(ruleFile.getPath());
        return fileReference;
    }

    protected boolean a(List<Action> list, Long l) {
        if (list == null) {
            return false;
        }
        for (Action action : list) {
            ExecuteMethodAction executeMethodAction;
            InvokeFile invokeFile;
            if (!(action instanceof ExecuteMethodAction) || (invokeFile = (executeMethodAction = (ExecuteMethodAction)action).getInvokeFile()) == null || invokeFile.getId() != l.longValue()) continue;
            return true;
        }
        return false;
    }

    public static class ReferenceInstances {
        private static List<Reference> a = new ArrayList<Reference>();

        static {
            a.add(new RuleSetReference());
            a.add(new DecisionTableReference());
            a.add(new CrosstableReference());
            a.add(new ComplexScorecardReference());
            a.add(new DecisionTreeReference());
            a.add(new RuleflowReference());
            a.add(new ScorecardReference());
            a.add(new ConditionTemplateReference());
            a.add(new ActionTemplateReference());
        }
    }
}

