/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.editor.ruleset;

import com.bstek.urule.Utils;
import com.bstek.urule.action.Action;
import com.bstek.urule.action.ConsolePrintAction;
import com.bstek.urule.action.ExecuteCommonFunctionAction;
import com.bstek.urule.action.ExecuteMethodAction;
import com.bstek.urule.action.ScoringAction;
import com.bstek.urule.action.TemplateAction;
import com.bstek.urule.action.VariableAssignAction;
import com.bstek.urule.builder.CopyLibPhaseHolder;
import com.bstek.urule.builder.ResourceBase;
import com.bstek.urule.builder.ResourceLibraryBuilder;
import com.bstek.urule.builder.resource.Resource;
import com.bstek.urule.console.editor.ruleset.LibInfo;
import com.bstek.urule.console.editor.ruleset.LibraryIndex;
import com.bstek.urule.console.util.ServiceUtils;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.library.ResourceLibrary;
import com.bstek.urule.model.rule.CommonFunctionValue;
import com.bstek.urule.model.rule.ConstantValue;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.LibraryType;
import com.bstek.urule.model.rule.MethodValue;
import com.bstek.urule.model.rule.Other;
import com.bstek.urule.model.rule.Parameter;
import com.bstek.urule.model.rule.ParameterValue;
import com.bstek.urule.model.rule.ParenValue;
import com.bstek.urule.model.rule.Rhs;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.VariableCategoryValue;
import com.bstek.urule.model.rule.VariableValue;
import com.bstek.urule.model.rule.lhs.AccumulateLeftPart;
import com.bstek.urule.model.rule.lhs.CalculateItem;
import com.bstek.urule.model.rule.lhs.CommonFunctionLeftPart;
import com.bstek.urule.model.rule.lhs.CommonFunctionParameter;
import com.bstek.urule.model.rule.lhs.ConditionItem;
import com.bstek.urule.model.rule.lhs.ConditionTemplateCriterion;
import com.bstek.urule.model.rule.lhs.Criteria;
import com.bstek.urule.model.rule.lhs.Criterion;
import com.bstek.urule.model.rule.lhs.FunctionLeftPart;
import com.bstek.urule.model.rule.lhs.Junction;
import com.bstek.urule.model.rule.lhs.Left;
import com.bstek.urule.model.rule.lhs.LeftPart;
import com.bstek.urule.model.rule.lhs.Lhs;
import com.bstek.urule.model.rule.lhs.MethodLeftPart;
import com.bstek.urule.model.rule.lhs.VariableLeftPart;
import com.bstek.urule.model.rule.loop.LoopRule;
import com.bstek.urule.model.rule.loop.LoopRuleUnit;
import com.bstek.urule.model.rule.loop.LoopTarget;
import com.bstek.urule.model.scorecard.runtime.ScoreRule;
import com.bstek.urule.model.template.ActionTemplate;
import com.bstek.urule.model.template.ActionTemplateUnit;
import com.bstek.urule.parse.deserializer.ActionTemplateDeserializer;
import com.bstek.urule.parse.deserializer.ConditionTemplateDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CopyLibsAnalysis {
    private ResourceLibraryBuilder a = (ResourceLibraryBuilder)Utils.getApplicationContext().getBean("urule.resourceLibraryBuilder");
    private ActionTemplateDeserializer b = (ActionTemplateDeserializer)Utils.getApplicationContext().getBean("urule.actionTemplateDeserializer");
    private ConditionTemplateDeserializer c = (ConditionTemplateDeserializer)Utils.getApplicationContext().getBean("urule.conditionTemplateDeserializer");
    public static final CopyLibsAnalysis ins = new CopyLibsAnalysis();

    private CopyLibsAnalysis() {
    }

    public String doAnalysis(String string, Object object) throws Exception {
        List list;
        HashMap<String, List<Map<String, Object>>> hashMap = new HashMap<String, List<Map<String, Object>>>();
        hashMap.put("parameters", new ArrayList());
        hashMap.put("variables", new ArrayList());
        hashMap.put("constants", new ArrayList());
        hashMap.put("actions", new ArrayList());
        hashMap.put("conditionTemplates", new ArrayList());
        hashMap.put("actionTemplates", new ArrayList());
        LibraryIndex libraryIndex = this.b(string);
        if (object instanceof List) {
            list = (List)object;
            this.a((Criterion)list.get(0), hashMap, libraryIndex);
        } else if (object instanceof Criterion) {
            list = (Criterion)object;
            this.a((Criterion)list, hashMap, libraryIndex);
        } else if (object instanceof Action) {
            list = (Action)object;
            this.a((Action)list, hashMap, libraryIndex);
        } else if (object instanceof Rule) {
            list = (Rule)object;
            if (list instanceof LoopRule) {
                LoopRule loopRule = (LoopRule)list;
                LoopTarget loopTarget = loopRule.getLoopTarget();
                Value value = loopTarget.getValue();
                this.a(value, hashMap, libraryIndex);
                List list2 = loopRule.getUnits();
                for (LoopRuleUnit loopRuleUnit : list2) {
                    this.a(hashMap, libraryIndex, loopRuleUnit.getLhs());
                    this.a(hashMap, libraryIndex, loopRuleUnit.getRhs());
                    Other other = loopRuleUnit.getOther();
                    if (other == null) continue;
                    this.a(hashMap, libraryIndex, other.getActions());
                }
            } else if (list instanceof ScoreRule) {
                ScoreRule scoreRule = (ScoreRule)list;
                String string2 = scoreRule.getVariableCategory();
                LibInfo libInfo = libraryIndex.variableContains(string2);
                this.a(hashMap, libInfo);
            } else {
                this.a((Rule)list, hashMap, libraryIndex);
            }
        } else {
            throw new RuleException("Unknow object :" + object.getClass().getName());
        }
        list = JsonMapper.builder().build();
        return list.writeValueAsString(hashMap);
    }

    private void a(Rule rule, Map<String, List<Map<String, Object>>> map, LibraryIndex libraryIndex) {
        Lhs lhs = rule.getLhs();
        this.a(map, libraryIndex, lhs);
        Rhs rhs = rule.getRhs();
        this.a(map, libraryIndex, rhs);
        Other other = rule.getOther();
        if (other != null) {
            List list = other.getActions();
            this.a(map, libraryIndex, list);
        }
    }

    private void a(Map<String, List<Map<String, Object>>> map, LibraryIndex libraryIndex, List<Action> list) {
        if (list == null) {
            return;
        }
        for (Action action : list) {
            this.a(action, map, libraryIndex);
        }
    }

    private void a(Map<String, List<Map<String, Object>>> map, LibraryIndex libraryIndex, Rhs rhs) {
        if (rhs == null) {
            return;
        }
        List list = rhs.getActions();
        this.a(map, libraryIndex, list);
    }

    private void a(Map<String, List<Map<String, Object>>> map, LibraryIndex libraryIndex, Lhs lhs) {
        if (lhs == null) {
            return;
        }
        Criterion criterion = lhs.getCriterion();
        this.a(criterion, map, libraryIndex);
    }

    private void a(Action action, Map<String, List<Map<String, Object>>> map, LibraryIndex libraryIndex) {
        if (action instanceof ConsolePrintAction) {
            ConsolePrintAction consolePrintAction = (ConsolePrintAction)action;
            Value value = consolePrintAction.getValue();
            this.a(value, map, libraryIndex);
        } else if (action instanceof ExecuteCommonFunctionAction) {
            ExecuteCommonFunctionAction executeCommonFunctionAction = (ExecuteCommonFunctionAction)action;
            CommonFunctionParameter commonFunctionParameter = executeCommonFunctionAction.getParameter();
            this.a(map, libraryIndex, commonFunctionParameter);
        } else if (action instanceof ExecuteMethodAction) {
            ExecuteMethodAction executeMethodAction = (ExecuteMethodAction)action;
            String string = executeMethodAction.getBeanLabel();
            LibInfo libInfo = libraryIndex.actionContains(string);
            this.a(map, libInfo);
            List list = executeMethodAction.getParameters();
            if (list != null) {
                for (Parameter parameter : list) {
                    Value value = parameter.getValue();
                    this.a(value, map, libraryIndex);
                }
            }
        } else if (action instanceof ScoringAction) {
            ScoringAction scoringAction = (ScoringAction)action;
            Value value = scoringAction.getValue();
            this.a(value, map, libraryIndex);
        } else if (action instanceof TemplateAction) {
            TemplateAction templateAction = (TemplateAction)action;
            String string = templateAction.getId();
            LibInfo libInfo = libraryIndex.templateContains(string);
            this.a(map, libInfo);
        } else if (action instanceof VariableAssignAction) {
            VariableAssignAction variableAssignAction = (VariableAssignAction)action;
            String string = variableAssignAction.getVariableCategory();
            LibInfo libInfo = libraryIndex.variableContains(string);
            this.a(map, libInfo);
            Value value = variableAssignAction.getValue();
            this.a(value, map, libraryIndex);
        }
    }

    private void a(Criterion criterion, Map<String, List<Map<String, Object>>> map, LibraryIndex libraryIndex) {
        if (criterion == null) {
            return;
        }
        if (criterion instanceof Junction) {
            Junction junction = (Junction)criterion;
            if (junction.getCriterions() != null) {
                for (Criterion criterion2 : junction.getCriterions()) {
                    this.a(criterion2, map, libraryIndex);
                }
            }
        } else if (criterion instanceof ConditionTemplateCriterion) {
            ConditionTemplateCriterion conditionTemplateCriterion = (ConditionTemplateCriterion)criterion;
            LibInfo libInfo = libraryIndex.templateContains(conditionTemplateCriterion.getId());
            this.a(map, libInfo);
        } else if (criterion instanceof Criteria) {
            Criteria criteria = (Criteria)criterion;
            Left left = criteria.getLeft();
            if (left != null) {
                LeftPart leftPart = left.getLeftPart();
                this.a(leftPart, map, libraryIndex);
            }
            this.a(criteria.getValue(), map, libraryIndex);
        }
    }

    private void a(LeftPart leftPart, Map<String, List<Map<String, Object>>> map, LibraryIndex libraryIndex) {
        if (leftPart == null) {
            return;
        }
        if (leftPart instanceof AccumulateLeftPart) {
            Object object;
            String string;
            Junction junction;
            Object object2;
            AccumulateLeftPart accumulateLeftPart = (AccumulateLeftPart)leftPart;
            List list = accumulateLeftPart.getCalculateItems();
            if (list != null) {
                object2 = list.iterator();
                while (object2.hasNext()) {
                    junction = (CalculateItem)object2.next();
                    string = junction.getAssignVariableCategory();
                    if (string == null) continue;
                    object = libraryIndex.variableContains(string);
                    this.a(map, (LibInfo)object);
                    Value value = junction.getValue();
                    this.a(value, map, libraryIndex);
                }
            }
            if ((object2 = accumulateLeftPart.getConditionItems()) != null) {
                junction = object2.iterator();
                while (junction.hasNext()) {
                    string = (ConditionItem)junction.next();
                    object = string.getValue();
                    this.a((Value)object, map, libraryIndex);
                }
            }
            junction = accumulateLeftPart.getJunction();
            this.a((Criterion)junction, map, libraryIndex);
            string = accumulateLeftPart.getLoopTarget();
            if (string != null) {
                this.a(string.getValue(), map, libraryIndex);
            }
        } else if (leftPart instanceof CommonFunctionLeftPart) {
            CommonFunctionLeftPart commonFunctionLeftPart = (CommonFunctionLeftPart)leftPart;
            CommonFunctionParameter commonFunctionParameter = commonFunctionLeftPart.getParameter();
            this.a(map, libraryIndex, commonFunctionParameter);
        } else if (leftPart instanceof FunctionLeftPart) {
            FunctionLeftPart functionLeftPart = (FunctionLeftPart)leftPart;
            List list = functionLeftPart.getParameters();
            if (list != null) {
                for (Parameter parameter : list) {
                    Value value = parameter.getValue();
                    this.a(value, map, libraryIndex);
                }
            }
        } else if (leftPart instanceof MethodLeftPart) {
            MethodLeftPart methodLeftPart = (MethodLeftPart)leftPart;
            String string = methodLeftPart.getBeanLabel();
            LibInfo libInfo = libraryIndex.actionContains(string);
            this.a(map, libInfo);
            List list = methodLeftPart.getParameters();
            if (list != null) {
                for (Parameter parameter : list) {
                    Value value = parameter.getValue();
                    this.a(value, map, libraryIndex);
                }
            }
        } else if (leftPart instanceof VariableLeftPart) {
            VariableLeftPart variableLeftPart = (VariableLeftPart)leftPart;
            String string = variableLeftPart.getVariableCategory();
            LibInfo libInfo = libraryIndex.variableContains(string);
            this.a(map, libInfo);
        }
    }

    private void a(Map<String, List<Map<String, Object>>> map, LibraryIndex libraryIndex, CommonFunctionParameter commonFunctionParameter) {
        if (commonFunctionParameter != null) {
            Value value = commonFunctionParameter.getObjectParameter();
            this.a(value, map, libraryIndex);
        }
    }

    private void a(Value value, Map<String, List<Map<String, Object>>> map, LibraryIndex libraryIndex) {
        Object object;
        Object object2;
        if (value == null) {
            return;
        }
        if (value instanceof CommonFunctionValue) {
            object2 = (CommonFunctionValue)value;
            object = object2.getLabel();
            LibInfo libInfo = libraryIndex.actionContains((String)object);
            this.a(map, libInfo);
            CommonFunctionParameter commonFunctionParameter = object2.getParameter();
            this.a(map, libraryIndex, commonFunctionParameter);
        } else if (value instanceof ConstantValue) {
            object2 = (ConstantValue)value;
            object = object2.getConstantCategory();
            LibInfo libInfo = libraryIndex.constantContains((String)object);
            this.a(map, libInfo);
        } else if (value instanceof MethodValue) {
            object2 = (MethodValue)value;
            object = object2.getBeanLabel();
            LibInfo libInfo = libraryIndex.actionContains((String)object);
            this.a(map, libInfo);
            List list = object2.getParameters();
            if (list != null) {
                for (Parameter parameter : list) {
                    Value value2 = parameter.getValue();
                    this.a(value2, map, libraryIndex);
                }
            }
        } else if (value instanceof ParameterValue) {
            object2 = libraryIndex.variableContains("\u53c2\u6570");
            this.a(map, (LibInfo)object2);
        } else if (value instanceof ParenValue) {
            object2 = (ParenValue)value;
            object = object2.getValue();
            this.a((Value)object, map, libraryIndex);
        } else if (value instanceof VariableCategoryValue) {
            object2 = (VariableCategoryValue)value;
            object = libraryIndex.variableContains(object2.getVariableCategory());
            this.a(map, (LibInfo)object);
        } else if (value instanceof VariableValue) {
            object2 = (VariableValue)value;
            object = object2.getVariableCategory();
            LibInfo libInfo = libraryIndex.variableContains((String)object);
            this.a(map, libInfo);
        }
        object2 = value.getArithmetic();
        if (object2 != null) {
            object = object2.getValue();
            this.a((Value)object, map, libraryIndex);
        }
    }

    private void a(Map<String, List<Map<String, Object>>> map, LibInfo libInfo) {
        if (libInfo == null) {
            return;
        }
        List<Object> list = null;
        if (map.containsKey(libInfo.getType())) {
            list = map.get(libInfo.getType());
        } else {
            list = new ArrayList();
            map.put(libInfo.getType(), list);
        }
        if (list.contains(libInfo.getMap())) {
            return;
        }
        list.add(libInfo.getMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LibraryIndex b(String string) throws Exception {
        ObjectMapper objectMapper = JsonMapper.builder().build();
        LibraryIndex libraryIndex = new LibraryIndex();
        Map map = (Map)objectMapper.readValue(string, HashMap.class);
        for (String string2 : map.keySet()) {
            LibraryType libraryType = null;
            boolean bl = false;
            if (string2.contentEquals("parameters")) {
                libraryType = LibraryType.Parameter;
            } else if (string2.contentEquals("variables")) {
                libraryType = LibraryType.Variable;
            } else if (string2.contentEquals("constants")) {
                libraryType = LibraryType.Constant;
            } else if (string2.contentEquals("actions")) {
                libraryType = LibraryType.Action;
            } else if (string2.contentEquals("conditionTemplates")) {
                libraryType = LibraryType.ActionTemplate;
                bl = true;
            } else {
                if (!string2.contentEquals("actionTemplates")) continue;
                libraryType = LibraryType.ConditionTemplate;
                bl = true;
            }
            List list = (List)map.get(string2);
            for (Map map2 : list) {
                ResourceBase resourceBase;
                Object object;
                long l = ((Integer)map2.get("id")).intValue();
                Library library = new Library();
                library.setType(libraryType);
                library.setId(l);
                library.setPath(map2.get("path").toString());
                library.setVersion((String)map2.get("version"));
                if (bl) {
                    ActionTemplate actionTemplate;
                    object = ServiceUtils.getKnowledgeBuilder();
                    resourceBase = object.newResourceBase();
                    resourceBase.addResource(l, library.getVersion());
                    Element element = this.a(((Resource)resourceBase.getResources().get(0)).getContent());
                    if (libraryType.equals((Object)LibraryType.ActionTemplate)) {
                        actionTemplate = this.b.deserialize(element);
                        for (ActionTemplateUnit actionTemplateUnit : actionTemplate.getTemplates()) {
                            libraryIndex.buildTemplateIndex(actionTemplateUnit.getId(), map2);
                        }
                        continue;
                    }
                    actionTemplate = this.c.deserialize(element);
                    for (ActionTemplateUnit actionTemplateUnit : actionTemplate.getTemplates()) {
                        libraryIndex.buildTemplateIndex(actionTemplateUnit.getId(), map2);
                    }
                    continue;
                }
                object = new ArrayList();
                object.add(library);
                CopyLibPhaseHolder.set();
                try {
                    resourceBase = this.a.buildResourceLibrary((Collection)object);
                    libraryIndex.buildIndex((ResourceLibrary)resourceBase, map2, libraryType);
                }
                finally {
                    CopyLibPhaseHolder.clean();
                }
            }
        }
        return libraryIndex;
    }

    protected Element a(String string) {
        try {
            Document document = DocumentHelper.parseText((String)string);
            Element element = document.getRootElement();
            return element;
        }
        catch (DocumentException documentException) {
            throw new RuleException((Exception)((Object)documentException));
        }
    }
}

