/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.editor.ruleset;

import com.bstek.urule.Utils;
import com.bstek.urule.action.Action;
import com.bstek.urule.builder.resource.ResourceType;
import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.SimpleDataProvider;
import com.bstek.urule.console.database.manager.file.FileManager;
import com.bstek.urule.console.database.manager.packet.PacketManager;
import com.bstek.urule.console.database.manager.project.ProjectManager;
import com.bstek.urule.console.database.model.Packet;
import com.bstek.urule.console.database.model.Project;
import com.bstek.urule.console.database.model.ProjectType;
import com.bstek.urule.console.database.model.RuleFile;
import com.bstek.urule.console.editor.ruleset.CopyAction;
import com.bstek.urule.console.editor.ruleset.CopyCriterion;
import com.bstek.urule.console.editor.ruleset.CopyLibsAnalysis;
import com.bstek.urule.console.editor.ruleset.CopyRule;
import com.bstek.urule.console.editor.store.StoreTools;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.console.xml.DocumentHelper;
import com.bstek.urule.console.xml.XXESAXReader;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.lhs.Criterion;
import com.bstek.urule.model.rule.loop.LoopRule;
import com.bstek.urule.model.table.Joint;
import com.bstek.urule.parse.ActionParser;
import com.bstek.urule.parse.ExecuteMethodActionParser;
import com.bstek.urule.parse.JunctionParser;
import com.bstek.urule.parse.LoopRuleParser;
import com.bstek.urule.parse.RuleParser;
import com.bstek.urule.parse.ValueParser;
import com.bstek.urule.parse.table.JointParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.springframework.context.ApplicationContext;

public class RulesetServletHandler
extends ApiServletHandler {
    public static final String IMPORT_DATA = "_import_data_";
    public static final String ACTION_CELL_DATA = "__action_cell_data_";
    public static final String ACTION_RULE_DATA = "__action_rule_data_";
    public static final String CONDITION_RULE_DATA = "_condition_rule_data_";
    public static final String CONDITION_CELL_DATA = "_condition_cell_data_";
    public static final String VALUE_CELL_DATA = "_value_cell_data_";
    private static final String e = "_loop_rule_for_copy_";
    private static final String f = "_rule_for_copy_";
    private RuleParser g;
    private LoopRuleParser h;
    private ValueParser i;
    private ExecuteMethodActionParser j;
    private JointParser k;
    private JunctionParser l;
    private Collection<ActionParser> m;

    @Override
    public void init() {
        super.init();
        ApplicationContext applicationContext = Utils.getApplicationContext();
        this.g = (RuleParser)applicationContext.getBean(RuleParser.class);
        this.h = (LoopRuleParser)applicationContext.getBean(LoopRuleParser.class);
        this.i = (ValueParser)applicationContext.getBean(ValueParser.class);
        this.j = (ExecuteMethodActionParser)applicationContext.getBean(ExecuteMethodActionParser.class);
        this.k = (JointParser)applicationContext.getBean(JointParser.class);
        this.l = (JunctionParser)applicationContext.getBean(JunctionParser.class);
        this.m = applicationContext.getBeansOfType(ActionParser.class).values();
    }

    public void copyRule(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("type");
        String string2 = Utils.decodeContent((String)httpServletRequest.getParameter("xml"));
        String string3 = Utils.decodeContent((String)httpServletRequest.getParameter("libs"));
        Document document = DocumentHelper.parseText(string2);
        Element element = document.getRootElement();
        LoopRule loopRule = null;
        if (string.equals("loop")) {
            loopRule = this.h.parse(element);
            string3 = CopyLibsAnalysis.ins.doAnalysis(string3, loopRule);
            StoreTools.setAttribute(e, new CopyRule((Rule)loopRule, string3));
        } else {
            loopRule = this.g.parse(element);
            string3 = CopyLibsAnalysis.ins.doAnalysis(string3, loopRule);
            StoreTools.setAttribute(f, new CopyRule((Rule)loopRule, string3));
        }
    }

    public void pasteRule(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("type");
        if (string.equals("loop")) {
            Object object = StoreTools.getAttribute(e);
            this.a(httpServletResponse, object);
        } else {
            Object object = StoreTools.getAttribute(f);
            this.a(httpServletResponse, object);
        }
    }

    public void parseRuleData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("type");
        String string2 = Utils.decodeContent((String)httpServletRequest.getParameter("xml"));
        String string3 = Utils.decodeContent((String)httpServletRequest.getParameter("libs"));
        Document document = DocumentHelper.parseText(string2);
        if (string.equals("condition")) {
            Element element = document.getRootElement();
            if (this.l.support(element.getName())) {
                Criterion criterion = this.l.parse(element);
                string3 = CopyLibsAnalysis.ins.doAnalysis(string3, criterion);
                StoreTools.setAttribute(CONDITION_RULE_DATA, new CopyCriterion(criterion, string3));
            } else {
                List list = this.l.parseCriterion(element);
                string3 = CopyLibsAnalysis.ins.doAnalysis(string3, list);
                StoreTools.setAttribute(CONDITION_RULE_DATA, new CopyCriterion((Criterion)list.get(0), string3));
            }
        } else if (string.equals("action")) {
            Element element = document.getRootElement();
            for (ActionParser actionParser : this.m) {
                if (!actionParser.support(element.getName())) continue;
                Action action = (Action)actionParser.parse(element);
                string3 = CopyLibsAnalysis.ins.doAnalysis(string3, action);
                StoreTools.setAttribute(ACTION_RULE_DATA, new CopyAction(action, string3));
                break;
            }
        }
    }

    public void loadRuleData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("type");
        Object object = null;
        if (string.equals("condition")) {
            object = StoreTools.getAttribute(CONDITION_RULE_DATA);
        } else if (string.equals("action")) {
            object = StoreTools.getAttribute(ACTION_RULE_DATA);
        }
        if (object != null) {
            this.a(httpServletResponse, object);
        }
    }

    public void parseCellData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Document document;
        String string = httpServletRequest.getParameter("type");
        String string2 = Utils.decodeContent((String)httpServletRequest.getParameter("xml"));
        try {
            document = DocumentHelper.parseText(string2);
        }
        catch (DocumentException documentException) {
            throw new ServletException((Throwable)documentException);
        }
        if (string.equals("condition")) {
            Joint joint = this.k.parse(document.getRootElement());
            StoreTools.setAttribute(CONDITION_CELL_DATA, joint);
        } else if (string.equals("value")) {
            Value value = this.i.parse(document.getRootElement());
            StoreTools.setAttribute(VALUE_CELL_DATA, value);
        } else if (string.equals("action")) {
            Action action = this.j.parse(document.getRootElement());
            StoreTools.setAttribute(ACTION_CELL_DATA, action);
        }
    }

    public void loadCellData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("type");
        Object object = null;
        if (string.equals("condition")) {
            object = StoreTools.getAttribute(CONDITION_CELL_DATA);
        } else if (string.equals("value")) {
            object = StoreTools.getAttribute(VALUE_CELL_DATA);
        } else if (string.equals("action")) {
            object = StoreTools.getAttribute(ACTION_CELL_DATA);
        }
        if (object != null) {
            this.a(httpServletResponse, object);
        }
    }

    public void loadSimpleData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        Collection collection = Utils.getApplicationContext().getBeansOfType(SimpleDataProvider.class).values();
        for (SimpleDataProvider simpleDataProvider : collection) {
            hashMap.put(simpleDataProvider.name(), simpleDataProvider.data());
        }
        this.a(httpServletResponse, hashMap);
    }

    public void loadPackets(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("projectId"));
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        Project project = ProjectManager.ins.get(l);
        Map<String, Object> map = this.a(project);
        if (map != null) {
            arrayList.add(map);
        }
        List<Project> list = ProjectManager.ins.newQuery().type(ProjectType.common.name()).groupId(project.getGroupId()).list();
        for (Project project2 : list) {
            map = this.a(project2);
            if (map == null) continue;
            arrayList.add(map);
        }
        this.a(httpServletResponse, arrayList);
    }

    private Map<String, Object> a(Project project) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList arrayList = new ArrayList();
        hashMap.put("project", project.getName());
        hashMap.put("packets", arrayList);
        List<Packet> list = PacketManager.ins.newQuery().projectId(project.getId()).enable(true).list();
        for (Packet packet : list) {
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap2.put("name", packet.getName());
            hashMap2.put("code", packet.getCode());
            hashMap2.put("id", packet.getId());
            arrayList.add(hashMap2);
        }
        if (arrayList.size() > 0) {
            return hashMap;
        }
        return null;
    }

    public void pendedGroups(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("groupName");
        String string2 = httpServletRequest.getParameter("fileName");
        long l = Long.valueOf(httpServletRequest.getParameter("projectId"));
        List<RuleFile> list = FileManager.ins.newQuery().nameLike(string2).deleted(false).type(ResourceType.RuleSet.name()).asc("NAME_").list(l);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (RuleFile object : list) {
            this.a(object, hashMap);
        }
        ArrayList arrayList = new ArrayList();
        for (String string3 : hashMap.keySet()) {
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            if (StringUtils.isNotBlank(string) && string3.toLowerCase().indexOf(string.toLowerCase()) == -1) continue;
            hashMap2.put("name", string3);
            hashMap2.put("path", (String)hashMap.get(string3));
            arrayList.add(hashMap2);
        }
        this.a(httpServletResponse, arrayList);
    }

    protected void a(RuleFile ruleFile, Map<String, String> map) throws Exception {
        String string = FileManager.ins.loadContent(ruleFile.getId());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("utf-8"));
        XXESAXReader xXESAXReader = new XXESAXReader();
        Document document = xXESAXReader.read(byteArrayInputStream);
        Element element = document.getRootElement();
        for (Object e : element.elements()) {
            Element element2;
            String string2;
            if (e == null || !(e instanceof Element) || !(string2 = (element2 = (Element)e).getName()).equals("rule") && !string2.equals("loop-rule")) continue;
            String string3 = element2.attributeValue("pended-group");
            String string4 = ruleFile.getPath() + "(" + ruleFile.getId() + ")";
            if (!StringUtils.isNotBlank(string3)) continue;
            if (map.containsKey(string3)) {
                String string5 = map.get(string3);
                if (string5.indexOf(string4) != -1) continue;
                map.put(string3, string5 + "\uff0c" + string4);
                continue;
            }
            map.put(string3, string4);
        }
        IOUtils.closeQuietly((InputStream)byteArrayInputStream);
    }

    @Override
    public String url() {
        return "/ruleset";
    }
}

