/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.editor.scorecard.complex;

import com.bstek.urule.Utils;
import com.bstek.urule.builder.resource.ResourceType;
import com.bstek.urule.console.ContextHolder;
import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.editor.lib.VariableInfo;
import com.bstek.urule.console.editor.lib.VariableLoader;
import com.bstek.urule.console.editor.scorecard.complex.CellData;
import com.bstek.urule.console.editor.scorecard.complex.RowData;
import com.bstek.urule.console.editor.scorecard.complex.ScoreTableData;
import com.bstek.urule.console.editor.scorecard.complex.TableHeader;
import com.bstek.urule.console.xml.DocumentHelper;
import com.bstek.urule.dsl.DSLRuleSetBuilder;
import com.bstek.urule.model.library.variable.Variable;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.model.rule.SimpleValue;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.VariableCategoryValue;
import com.bstek.urule.model.rule.VariableValue;
import com.bstek.urule.model.rule.lhs.Criteria;
import com.bstek.urule.model.rule.lhs.Criterion;
import com.bstek.urule.model.rule.lhs.Junction;
import com.bstek.urule.model.rule.lhs.Or;
import com.bstek.urule.model.scorecard.ComplexScorecardDefinition;
import com.bstek.urule.parse.deserializer.ComplexScorecardDeserializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;

public class ComplexScoreTableBuilder {
    private ScoreTableData a;
    private DSLRuleSetBuilder b;
    private List<VariableInfo> c;
    private ComplexScorecardDeserializer d;
    private Map<Long, VariableInfo> e = new HashMap<Long, VariableInfo>();

    public ComplexScoreTableBuilder(ScoreTableData scoreTableData) {
        this.a = scoreTableData;
        this.c = VariableLoader.ins.load(ContextHolder.getGroupId(), ContextHolder.getProjectId());
        this.b = (DSLRuleSetBuilder)Utils.getApplicationContext().getBean("urule.dslRuleSetBuilder");
        this.d = (ComplexScorecardDeserializer)Utils.getApplicationContext().getBean("urule.complexScorecardDeserializer");
    }

    public ComplexScorecardDefinition buildTable() {
        try {
            String string = this.a();
            Document document = DocumentHelper.parseText(string);
            return this.d.deserialize(document.getRootElement());
        }
        catch (Exception exception) {
            throw new InfoException(exception);
        }
    }

    private String a() throws IOException {
        int n;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuilder.append("<complex-scorecard scoring-type=\"sum\" assign-target-type=\"none\">");
        List<TableHeader> list = this.a.getHeaders();
        for (int i = 0; i < list.size(); ++i) {
            TableHeader tableHeader = list.get(i);
            String object22 = tableHeader.getName();
            if (tableHeader.isScore()) {
                stringBuilder.append("<col num=\"" + i + "\" width=\"120\" type=\"Score\"/>");
                continue;
            }
            object = this.a(object22);
            stringBuilder.append("<col num=\"" + i + "\" width=\"120\" type=\"Criteria\" uuid=\"" + object.getUuid() + "\" var-category=\"" + object22 + "\"/>");
        }
        List<RowData> list2 = this.a.getRows();
        for (n = 0; n < list2.size(); ++n) {
            stringBuilder.append("<row num=\"" + n + "\" height=\"40\"/>");
        }
        for (n = 0; n < list2.size(); ++n) {
            RowData rowData = list2.get(n);
            object = rowData.getCells();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Variable variable;
                CellData cellData = (CellData)iterator.next();
                TableHeader tableHeader = cellData.getHeader();
                String string = cellData.getContent();
                int n2 = cellData.getSpan();
                if (n2 == 0) {
                    n2 = 1;
                }
                stringBuilder.append("<cell row=\"" + cellData.getRow() + "\" col=\"" + cellData.getCol() + "\" rowspan=\"" + n2 + "\"");
                if (tableHeader.isScore()) {
                    stringBuilder.append(">");
                } else {
                    variable = this.a(new String[]{tableHeader.getName(), cellData.getProperty()});
                    stringBuilder.append(" var-label=\"" + variable.getLabel() + "\" var=\"" + variable.getName() + "\" datatype=\"" + variable.getDataType() + "\" uuid=\"" + variable.getUuid() + "\">");
                }
                if (StringUtils.isNotBlank((String)string)) {
                    if (tableHeader.isScore()) {
                        string = StringEscapeUtils.escapeXml((String)string);
                        stringBuilder.append("<value content=\"" + string + "\" type=\"Input\"/>");
                    } else {
                        variable = this.b.buildCriterion(string);
                        stringBuilder.append(this.a((Criterion)variable));
                    }
                }
                stringBuilder.append("</cell>");
            }
        }
        for (VariableInfo variableInfo : this.e.values()) {
            if (variableInfo.getType().endsWith(ResourceType.VariableLibrary.name())) {
                stringBuilder.append("<import-variable-library id=\"" + variableInfo.getId() + "\" path=\"" + variableInfo.getPath() + "\"/>");
                continue;
            }
            stringBuilder.append("<import-parameter-library id=\"" + variableInfo.getId() + "\" path=\"" + variableInfo.getPath() + "\"/>");
        }
        stringBuilder.append("</complex-scorecard>");
        return stringBuilder.toString();
    }

    private VariableCategory a(String string) {
        for (VariableInfo variableInfo : this.c) {
            List<VariableCategory> list = variableInfo.getVariableCategories();
            for (VariableCategory variableCategory : list) {
                if (!variableCategory.getName().equals(string)) continue;
                this.e.put(variableInfo.getId(), variableInfo);
                return variableCategory;
            }
        }
        throw new InfoException("\u53d8\u91cf\u5206\u7c7b[" + string + "]\u5728\u5f53\u524d\u9879\u76ee\u4e2d\u672a\u5b9a\u4e49!");
    }

    private Variable a(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        for (VariableInfo variableInfo : this.c) {
            List<VariableCategory> list = variableInfo.getVariableCategories();
            for (VariableCategory variableCategory : list) {
                if (!variableCategory.getName().equals(string)) continue;
                this.e.put(variableInfo.getId(), variableInfo);
                List list2 = variableCategory.getVariables();
                if (list2 == null) continue;
                for (Variable variable : list2) {
                    if (!variable.getLabel().equals(string2) && !variable.getName().equals(string2)) continue;
                    return variable;
                }
            }
        }
        throw new InfoException("\u53d8\u91cf[" + string + "." + string2 + "]\u5728\u5f53\u524d\u9879\u76ee\u4e2d\u672a\u5b9a\u4e49!");
    }

    private String a(Criterion criterion) {
        StringBuilder stringBuilder = new StringBuilder();
        if (criterion instanceof Junction) {
            Junction junction = (Junction)criterion;
            List list = junction.getCriterions();
            String string = "and";
            if (junction instanceof Or) {
                string = "or";
            }
            stringBuilder.append("<joint type=\"" + string + "\">");
            if (list != null) {
                for (Criterion criterion2 : list) {
                    if (!(criterion2 instanceof Criteria)) continue;
                    Criteria criteria = (Criteria)criterion2;
                    stringBuilder.append("<condition op=\"" + criteria.getOp().name() + "\">");
                    Value value = criteria.getValue();
                    String string2 = this.a(value);
                    if (string2 != null) {
                        stringBuilder.append(string2);
                    }
                    stringBuilder.append("</condition>");
                }
            }
        } else {
            stringBuilder.append("<joint type=\"and\">");
            Criteria criteria = (Criteria)criterion;
            stringBuilder.append("<condition op=\"" + criteria.getOp().name() + "\">");
            Value value = criteria.getValue();
            stringBuilder.append(this.a(value));
            stringBuilder.append("</condition>");
        }
        stringBuilder.append("</joint>");
        return stringBuilder.toString();
    }

    private String a(Value value) {
        String string;
        SimpleValue simpleValue;
        if (value == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (value instanceof SimpleValue) {
            simpleValue = (SimpleValue)value;
            string = StringEscapeUtils.escapeXml((String)simpleValue.getContent());
            stringBuilder.append("<value content=\"" + string + "\" type=\"Input\">");
        } else if (value instanceof VariableCategoryValue) {
            simpleValue = (VariableCategoryValue)value;
            string = simpleValue.getVariableCategory();
            String string2 = StringEscapeUtils.escapeXml((String)string);
            stringBuilder.append("<value content=\"" + string2 + "\" type=\"Input\">");
        } else if (value instanceof VariableValue) {
            simpleValue = (VariableValue)value;
            string = simpleValue.getVariableCategory() + "." + simpleValue.getVariableLabel();
            string = StringEscapeUtils.escapeXml((String)string);
            stringBuilder.append("<value content=\"" + string + "\" type=\"Input\">");
        } else {
            stringBuilder.append("<value content=\"\" type=\"Input\">");
        }
        simpleValue = value.getArithmetic();
        if (simpleValue == null) {
            stringBuilder.append("</value>");
            return stringBuilder.toString();
        }
        string = simpleValue.getType();
        stringBuilder.append("<complex-arith type=\"" + string.name() + "\">");
        stringBuilder.append(this.a(simpleValue.getValue()));
        stringBuilder.append("</complex-arith>");
        stringBuilder.append("</value>");
        return stringBuilder.toString();
    }
}

