/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.editor.scorecard.simple;

import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.editor.scorecard.simple.CellData;
import com.bstek.urule.console.editor.scorecard.simple.RowData;
import com.bstek.urule.console.editor.scorecard.simple.ScoreTableBuilder;
import com.bstek.urule.console.editor.scorecard.simple.ScoreTableData;
import com.bstek.urule.console.editor.scorecard.simple.TableHeader;
import com.bstek.urule.console.util.FileUtils;
import com.bstek.urule.model.scorecard.ScorecardDefinition;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SimpleScorecardServletHandler
extends ApiServletHandler {
    public void excel(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        InputStream inputStream = FileUtils.uploadFile(httpServletRequest).getInputStream();
        ScoreTableData scoreTableData = this.a(inputStream);
        inputStream.close();
        ScoreTableBuilder scoreTableBuilder = new ScoreTableBuilder(scoreTableData);
        ScorecardDefinition scorecardDefinition = scoreTableBuilder.buildTable();
        this.a(httpServletResponse, scorecardDefinition);
    }

    private ScoreTableData a(InputStream inputStream) throws Exception {
        XSSFWorkbook xSSFWorkbook = new XSSFWorkbook(inputStream);
        if (xSSFWorkbook.getNumberOfSheets() == 0) {
            xSSFWorkbook.close();
            throw new InfoException("\u5bfc\u5165Excel\u4e0d\u5408\u6cd5\uff01");
        }
        ArrayList<RowData> arrayList = new ArrayList<RowData>();
        XSSFSheet xSSFSheet = xSSFWorkbook.getSheetAt(xSSFWorkbook.getActiveSheetIndex());
        int n = xSSFSheet.getLastRowNum();
        List<TableHeader> list = this.a(xSSFSheet);
        for (int i = 1; i <= n; ++i) {
            XSSFRow xSSFRow = xSSFSheet.getRow(i);
            RowData rowData = new RowData();
            arrayList.add(rowData);
            ArrayList<CellData> arrayList2 = new ArrayList<CellData>();
            rowData.setCells(arrayList2);
            for (int j = 0; j < list.size(); ++j) {
                int n2;
                XSSFCell xSSFCell = xSSFRow.getCell(j);
                if (xSSFCell == null || (n2 = this.a(i, j, xSSFSheet)) == 0) continue;
                TableHeader tableHeader = list.get(j);
                CellData cellData = new CellData();
                if (n2 > 0) {
                    cellData.setSpan(n2);
                }
                cellData.setHeader(tableHeader);
                CellType cellType = xSSFCell.getCellTypeEnum();
                switch (cellType) {
                    case STRING: {
                        cellData.setContent(xSSFCell.getStringCellValue());
                        break;
                    }
                    case BOOLEAN: {
                        cellData.setContent(String.valueOf(xSSFCell.getBooleanCellValue()));
                        break;
                    }
                    case NUMERIC: {
                        xSSFCell.setCellType(CellType.STRING);
                        cellData.setContent(xSSFCell.getStringCellValue());
                        break;
                    }
                }
                cellData.setRow(i - 1);
                cellData.setCol(j);
                arrayList2.add(cellData);
            }
        }
        xSSFWorkbook.close();
        return new ScoreTableData(list, arrayList);
    }

    private int a(int n, int n2, XSSFSheet xSSFSheet) {
        List list = xSSFSheet.getMergedRegions();
        for (CellRangeAddress cellRangeAddress : list) {
            if (cellRangeAddress.getFirstColumn() == n2 && cellRangeAddress.getFirstRow() == n) {
                int n3 = cellRangeAddress.getLastRow() - cellRangeAddress.getFirstRow();
                return ++n3;
            }
            if (n2 < cellRangeAddress.getFirstColumn() || n2 > cellRangeAddress.getLastColumn() || n < cellRangeAddress.getFirstRow() || n > cellRangeAddress.getLastRow()) continue;
            return 0;
        }
        return -1;
    }

    private List<TableHeader> a(XSSFSheet xSSFSheet) {
        XSSFRow xSSFRow = xSSFSheet.getRow(0);
        ArrayList<TableHeader> arrayList = new ArrayList<TableHeader>();
        int n = xSSFRow.getLastCellNum();
        for (int i = 0; i < n; ++i) {
            XSSFCell xSSFCell = xSSFRow.getCell(i);
            String string = xSSFCell.getStringCellValue();
            if (StringUtils.isBlank((String)string)) continue;
            TableHeader tableHeader = new TableHeader();
            arrayList.add(tableHeader);
            tableHeader.setName(string);
        }
        return arrayList;
    }

    @Override
    public String url() {
        return "/scorecard";
    }
}

