/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.editor.todo;

import com.bstek.urule.Utils;
import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.ContextHolder;
import com.bstek.urule.console.Transactional;
import com.bstek.urule.console.TransactionalInvoke;
import com.bstek.urule.console.admin.log.SystemLogUtils;
import com.bstek.urule.console.cache.packet.PacketCache;
import com.bstek.urule.console.database.manager.file.FileManager;
import com.bstek.urule.console.database.manager.packet.PacketBuilder;
import com.bstek.urule.console.database.manager.packet.PacketManager;
import com.bstek.urule.console.database.manager.packet.apply.PacketApplyManager;
import com.bstek.urule.console.database.manager.packet.apply.PacketApplyQuery;
import com.bstek.urule.console.database.manager.packet.apply.detail.PacketApplyDetailManager;
import com.bstek.urule.console.database.manager.packet.deploy.PacketDeployManager;
import com.bstek.urule.console.database.manager.packet.deploy.file.PacketDeployFileManager;
import com.bstek.urule.console.database.model.ApplyStatus;
import com.bstek.urule.console.database.model.ApplyType;
import com.bstek.urule.console.database.model.Packet;
import com.bstek.urule.console.database.model.PacketApply;
import com.bstek.urule.console.database.model.PacketApplyDetail;
import com.bstek.urule.console.database.model.PacketDeploy;
import com.bstek.urule.console.database.model.PacketDeployFile;
import com.bstek.urule.console.database.model.PacketFile;
import com.bstek.urule.console.database.model.RuleFile;
import com.bstek.urule.console.editor.todo.PacketPublishListener;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.type.RuleFileType;
import com.bstek.urule.console.util.MD5Utils;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.runtime.KnowledgePackage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class TodoServletHandler
extends ApiServletHandler {
    PacketPublishListener e = null;

    @Override
    public void init() {
        super.init();
        if (this.e == null) {
            try {
                this.e = (PacketPublishListener)Utils.getApplicationContext().getBean("urule.packetPublishListener");
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
    }

    public void load(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        String string;
        String string2;
        int n = Integer.valueOf(httpServletRequest.getParameter("pageIndex"));
        int n2 = Integer.valueOf(httpServletRequest.getParameter("pageSize"));
        PacketApplyQuery packetApplyQuery = PacketApplyManager.ins.newQuery();
        packetApplyQuery.projectId(ContextHolder.getProjectId());
        packetApplyQuery.titleLike(httpServletRequest.getParameter("title"));
        packetApplyQuery.descLike(httpServletRequest.getParameter("desc"));
        packetApplyQuery.createUserLike(httpServletRequest.getParameter("createUser"));
        String string3 = httpServletRequest.getParameter("currentType");
        if (string3.contentEquals("pending")) {
            packetApplyQuery.approver(SecurityUtils.getLoginUsername(httpServletRequest));
            packetApplyQuery.status(ApplyStatus.pending);
        } else if (string3.contentEquals("my")) {
            packetApplyQuery.createUser(SecurityUtils.getLoginUsername(httpServletRequest));
        } else if (string3.contentEquals("processed")) {
            packetApplyQuery.approver(SecurityUtils.getLoginUsername(httpServletRequest));
            packetApplyQuery.notStatus(ApplyStatus.pending);
        }
        String string4 = httpServletRequest.getParameter("approver");
        if (StringUtils.isNotBlank(string4)) {
            packetApplyQuery.approver(string4);
        }
        if (StringUtils.isNotBlank(string2 = httpServletRequest.getParameter("type"))) {
            packetApplyQuery.type(ApplyType.valueOf(string2));
        }
        if (StringUtils.isNotBlank(string = httpServletRequest.getParameter("status"))) {
            object = ApplyStatus.valueOf(string);
            packetApplyQuery.status((ApplyStatus)((Object)object));
        }
        object = packetApplyQuery.paging(n, n2);
        this.a(httpServletResponse, object);
    }

    public void detail(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ApplyType applyType = ApplyType.valueOf(httpServletRequest.getParameter("type"));
        long l = Long.valueOf(httpServletRequest.getParameter("packetId"));
        long l2 = -1L;
        if (applyType.equals((Object)ApplyType.deploy)) {
            l2 = Long.valueOf(httpServletRequest.getParameter("deployedPacketId"));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Packet packet = PacketManager.ins.load(l);
        hashMap.put("name", packet.getName());
        hashMap.put("desc", packet.getDesc());
        if (l2 > -1L) {
            PacketDeploy packetDeploy = PacketDeployManager.ins.load(l2);
            hashMap.put("files", packetDeploy.getFiles());
        } else {
            hashMap.put("files", packet.getFiles());
        }
        this.a(httpServletResponse, hashMap);
    }

    public void submit(final HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        final long l = Long.valueOf(httpServletRequest.getParameter("applyId"));
        final ApplyStatus applyStatus = ApplyStatus.valueOf(httpServletRequest.getParameter("result"));
        final String string = httpServletRequest.getParameter("desc");
        String string2 = httpServletRequest.getParameter("groupId");
        final PacketApplyDetail packetApplyDetail = new PacketApplyDetail();
        packetApplyDetail.setApplyId(l);
        packetApplyDetail.setProjectId(ContextHolder.getProjectId());
        packetApplyDetail.setDesc(string);
        packetApplyDetail.setCreateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        final ApplyType applyType = ApplyType.valueOf(httpServletRequest.getParameter("applyType"));
        final PacketApply packetApply = PacketApplyManager.ins.load(l);
        final Packet packet = PacketManager.ins.load(packetApply.getPacketId());
        this.a(new TransactionalInvoke(){

            @Override
            public void doTransactional() {
                PacketApplyDetailManager.ins.add(packetApplyDetail);
                PacketApplyManager.ins.update(l, applyStatus);
                String string2 = null;
                if (applyStatus.equals((Object)ApplyStatus.pass)) {
                    long l2 = Long.valueOf(httpServletRequest.getParameter("packetId"));
                    if (applyType.equals((Object)ApplyType.enable)) {
                        string2 = "\u542f\u7528\u77e5\u8bc6\u5305[" + packet.getName() + "]\u5ba1\u6279\u901a\u8fc7";
                        if (TodoServletHandler.this.e != null) {
                            TodoServletHandler.this.e.beforeEnable(packet, string);
                        }
                        PacketManager.ins.update(l2, true);
                        if (TodoServletHandler.this.e != null) {
                            TodoServletHandler.this.e.afterEnable(packet, string);
                        }
                    } else if (applyType.equals((Object)ApplyType.disable)) {
                        string2 = "\u7981\u7528\u77e5\u8bc6\u5305[" + packet.getName() + "]\u5ba1\u6279\u901a\u8fc7";
                        if (TodoServletHandler.this.e != null) {
                            TodoServletHandler.this.e.beforeDisable(packet, string);
                        }
                        PacketManager.ins.update(l2, false);
                        if (TodoServletHandler.this.e != null) {
                            TodoServletHandler.this.e.afterDisable(packet, string);
                        }
                    } else if (applyType.equals((Object)ApplyType.deploy)) {
                        List<PacketDeploy> list;
                        string2 = "\u53d1\u5e03\u77e5\u8bc6\u5305[" + packet.getName() + "]\u5ba1\u6279\u901a\u8fc7";
                        if (TodoServletHandler.this.e != null) {
                            TodoServletHandler.this.e.beforePublish(packet, string);
                        }
                        if ((list = PacketDeployManager.ins.newQuery().enable(true).packetId(l2).listWithContent()).size() == 0) {
                            PacketDeployManager.ins.updateEnable(packetApply.getDeployedPacketId(), true);
                        }
                        PacketDeployManager.ins.updateStatus(packetApply.getDeployedPacketId(), applyStatus);
                        if (TodoServletHandler.this.e != null) {
                            TodoServletHandler.this.e.afterPublish(packet, string);
                        }
                    }
                    if (StringUtils.isNotBlank(string2)) {
                        SystemLogUtils.addProjectOperationLog(RuleFileType.Knowledge.name(), applyType.name(), packet.getId(), string2);
                    }
                } else {
                    PacketDeployManager.ins.updateStatus(packetApply.getDeployedPacketId(), applyStatus);
                }
            }
        });
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        boolean bl = false;
        boolean bl2 = false;
        if (applyStatus.equals((Object)ApplyStatus.pass)) {
            List<PacketDeploy> list;
            long l2 = Long.valueOf(httpServletRequest.getParameter("packetId"));
            if (applyType.equals((Object)ApplyType.enable)) {
                List<Map<String, Object>> list2 = PacketCache.ins.refreshPacket(l2);
                List<Map<String, Object>> list3 = PacketCache.ins.enableClientsPacket(string2, l2);
                if (list2.size() > 0) {
                    bl2 = true;
                }
                if (list3.size() > 0) {
                    bl = true;
                }
                arrayList.addAll(list2);
                arrayList.addAll(list3);
            } else if (applyType.equals((Object)ApplyType.disable)) {
                List<Map<String, Object>> list4 = PacketCache.ins.refreshPacket(l2);
                List<Map<String, Object>> list5 = PacketCache.ins.disableClientsPacket(string2, l2);
                if (list4.size() > 0) {
                    bl2 = true;
                }
                if (list5.size() > 0) {
                    bl = true;
                }
                arrayList.addAll(list4);
                arrayList.addAll(list5);
            } else if (applyType.equals((Object)ApplyType.deploy) && (list = PacketDeployManager.ins.newQuery().enable(true).packetId(l2).listWithContent()).size() > 0) {
                List<Map<String, Object>> list6 = PacketCache.ins.refreshPacket(l2);
                if (list6.size() > 0) {
                    bl2 = true;
                }
                arrayList.addAll(list6);
            }
        }
        if (arrayList.size() > 0) {
            hashMap.put("result", arrayList);
            String string3 = "";
            if (bl2) {
                string3 = "\u96c6\u7fa4\u670d\u52a1\u5668";
            }
            if (bl) {
                if (string3.length() > 0) {
                    string3 = string3 + "\u53ca";
                }
                string3 = string3 + "\u5ba2\u6237\u7aef";
            }
            string3 = string3 + "\u540c\u6b65\u7ed3\u679c";
            hashMap.put("title", string3);
        }
        this.a(httpServletResponse, hashMap);
    }

    @Transactional
    public void reapply(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("applyId"));
        String string = httpServletRequest.getParameter("desc");
        PacketApplyDetail packetApplyDetail = new PacketApplyDetail();
        packetApplyDetail.setApplyId(l);
        packetApplyDetail.setProjectId(ContextHolder.getProjectId());
        packetApplyDetail.setDesc(string);
        packetApplyDetail.setCreateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        PacketApplyDetailManager.ins.add(packetApplyDetail);
        PacketApplyManager.ins.update(l, ApplyStatus.pending);
        ApplyType applyType = ApplyType.valueOf(httpServletRequest.getParameter("type"));
        if (applyType.equals((Object)ApplyType.deploy)) {
            long l2 = Long.valueOf(httpServletRequest.getParameter("deployedPacketId"));
            PacketDeploy packetDeploy = PacketDeployManager.ins.load(l2);
            long l3 = Long.valueOf(httpServletRequest.getParameter("packetId"));
            KnowledgePackage knowledgePackage = PacketBuilder.ins.buildKnowledgePackage(l3);
            String string2 = Utils.knowledgePackageToString((KnowledgePackage)knowledgePackage);
            PacketDeploy packetDeploy2 = new PacketDeploy();
            packetDeploy2.setContent(string2);
            packetDeploy2.setDigest(MD5Utils.stringToMD5(string2));
            packetDeploy2.setStatus(ApplyStatus.pending);
            packetDeploy2.setCreateUser(SecurityUtils.getLoginUsername(httpServletRequest));
            packetDeploy2.setApplyId(l);
            packetDeploy2.setVersion(packetDeploy.getVersion());
            packetDeploy2.setDesc(packetDeploy.getDesc());
            packetDeploy2.setPacketId(l3);
            packetDeploy2.setProjectId(ContextHolder.getProjectId());
            PacketDeployManager.ins.add(packetDeploy2);
            Packet packet = PacketManager.ins.load(l3);
            for (PacketFile packetFile : packet.getFiles()) {
                RuleFile ruleFile = FileManager.ins.get(packetFile.getFileId());
                PacketDeployFile packetDeployFile = new PacketDeployFile();
                packetDeployFile.setFileId(packetFile.getFileId());
                packetDeployFile.setProjectId(ContextHolder.getProjectId());
                packetDeployFile.setDigest(ruleFile.getDigest());
                packetDeployFile.setPath(packetFile.getPath());
                packetDeployFile.setVersion(packetFile.getVersion());
                packetDeployFile.setPacketDeployId(packetDeploy2.getId());
                packetDeployFile.setContent(FileManager.ins.loadContent(packetFile.getFileId()));
                packetDeployFile.setCreateUser(SecurityUtils.getLoginUsername(httpServletRequest));
                PacketDeployFileManager.ins.add(packetDeployFile);
            }
            PacketDeployManager.ins.delete(l2);
            PacketApplyManager.ins.updateDeployedPacketId(l, packetDeploy2.getId());
        }
    }

    @Override
    public String url() {
        return "/todo";
    }
}

