/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.editor.url;

import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.database.manager.url.UrlManager;
import com.bstek.urule.console.database.model.UrlConfig;
import com.bstek.urule.console.database.model.UrlType;
import com.bstek.urule.console.database.service.url.UrlData;
import com.bstek.urule.console.database.service.url.UrlService;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.security.URuleAuthorization;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.exception.RuleException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UrlServletHandler
extends ApiServletHandler {
    public void load(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        UrlType urlType = UrlType.valueOf(httpServletRequest.getParameter("type"));
        String string = httpServletRequest.getParameter("groupId");
        UrlData urlData = UrlService.ins.load(urlType, string);
        this.a(httpServletResponse, urlData);
    }

    @URuleAuthorization(authType="group", model="clientUrls", code="manager")
    public void add(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        UrlType urlType = UrlType.valueOf(httpServletRequest.getParameter("type"));
        UrlConfig urlConfig = new UrlConfig();
        urlConfig.setType(urlType);
        urlConfig.setName(httpServletRequest.getParameter("name"));
        urlConfig.setGroupId(httpServletRequest.getParameter("groupId"));
        String string = httpServletRequest.getParameter("url");
        if (StringUtils.isNotBlank(string) && string.endsWith("/")) {
            throw new RuleException("URL\u4e0d\u80fd\u4ee5'/'\u7ed3\u5c3e");
        }
        urlConfig.setUrl(string);
        urlConfig.setCreateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        UrlManager.ins.add(urlConfig);
    }

    @URuleAuthorization(authType="group", model="clientUrls", code="manager")
    public void update(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        UrlConfig urlConfig = new UrlConfig();
        urlConfig.setName(httpServletRequest.getParameter("name"));
        String string = httpServletRequest.getParameter("url");
        if (StringUtils.isNotBlank(string) && string.endsWith("/")) {
            throw new RuleException("URL\u4e0d\u80fd\u4ee5'/'\u7ed3\u5c3e");
        }
        urlConfig.setUrl(string);
        urlConfig.setId(Long.valueOf(httpServletRequest.getParameter("id")));
        urlConfig.setUpdateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        UrlManager.ins.update(urlConfig);
    }

    @URuleAuthorization(authType="group", model="clientUrls", code="manager")
    public void delete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("id"));
        UrlManager.ins.delete(l);
    }

    @Override
    public String url() {
        return "/url";
    }
}

