/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.file;

import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.ContextHolder;
import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.Transactional;
import com.bstek.urule.console.admin.log.SystemLogUtils;
import com.bstek.urule.console.database.manager.file.DirectoryManager;
import com.bstek.urule.console.database.model.FileInfo;
import com.bstek.urule.console.database.model.RuleFile;
import com.bstek.urule.console.database.service.file.FileService;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.security.URuleAuthorization;
import com.bstek.urule.console.util.StringUtils;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DirectoryServletHandler
extends ApiServletHandler {
    @URuleAuthorization(authType="project", code="add", ruleDir=true)
    @Transactional
    public void add(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String[] stringArray;
        String string = httpServletRequest.getParameter("name");
        String string2 = httpServletRequest.getParameter("type");
        long l = Long.valueOf(httpServletRequest.getParameter("parentId"));
        long l2 = ContextHolder.getProjectId();
        if (l > 0L) {
            stringArray = DirectoryManager.ins.get(l);
            if (null == stringArray) {
                throw new InfoException("\u7236\u76ee\u5f55\u4e0d\u5b58\u5728!");
            }
            l2 = stringArray.getProjectId();
        }
        if (StringUtils.isBlank(string) || StringUtils.isBlank(string2)) {
            throw new InfoException("\u6587\u4ef6\u540d\u79f0\u6216\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        stringArray = (string = string.trim()).split("\\.");
        if (stringArray.length == 1) {
            stringArray = string.split("/");
        }
        RuleFile ruleFile = null;
        FileInfo fileInfo = null;
        for (String string3 : stringArray) {
            boolean bl = DirectoryManager.ins.checkExist(l2, l, string2, string3);
            if (bl) {
                throw new InfoException("\u76ee\u5f55\u3010" + string + "\u3011\u5df2\u5b58\u5728\uff01");
            }
            if (fileInfo != null) {
                l = fileInfo.getId();
            }
            if (!StringUtils.isLetterDigitOrChinese(string3)) {
                throw new InfoException("\u65e0\u6548\u540d\u79f0,\u53ea\u80fd\u4f7f\u7528\u4e2d\u82f1\u6587\u5b57\u6bcd,\u6570\u5b57\u548c\u4e0b\u5212\u7ebf");
            }
            RuleFile ruleFile2 = new RuleFile();
            ruleFile2.setDirectory(true);
            ruleFile2.setProjectId(l2);
            ruleFile2.setParentId(l);
            ruleFile2.setName(string3);
            ruleFile2.setType(string2);
            ruleFile2.setCreateUser(SecurityUtils.getLoginUsername(httpServletRequest));
            DirectoryManager.ins.add(ruleFile2);
            SystemLogUtils.addRuleFileOperationLog(string2, "add", ruleFile2.getId(), "\u6dfb\u52a0{type}\u76ee\u5f55[" + string + "]");
            if (ruleFile == null) {
                ruleFile = ruleFile2;
                fileInfo = ruleFile2;
                continue;
            }
            ArrayList<RuleFile> arrayList = new ArrayList<RuleFile>();
            arrayList.add(ruleFile2);
            if (fileInfo != null) {
                ((RuleFile)fileInfo).setChildren(arrayList);
            }
            fileInfo = ruleFile2;
        }
        this.a(httpServletResponse, ruleFile);
    }

    @URuleAuthorization(authType="project", code="remove", ruleDir=true)
    @Transactional
    public void remove(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("id"));
        RuleFile ruleFile = DirectoryManager.ins.get(l);
        if (ruleFile != null) {
            FileService.ins.removeDir(ruleFile);
            SystemLogUtils.addRuleFileOperationLog(ruleFile.getType(), "remove", ruleFile.getId(), "\u5220\u9664{type}\u76ee\u5f55[" + ruleFile.getName() + "]");
        }
    }

    @URuleAuthorization(authType="project", code="update", ruleDir=true)
    public void move(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("id"));
        long l2 = Long.valueOf(httpServletRequest.getParameter("parentId"));
        DirectoryManager.ins.changeParent(l, l2);
    }

    @URuleAuthorization(authType="project", code="update", ruleDir=true)
    public void rename(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("newName");
        long l = Long.valueOf(httpServletRequest.getParameter("id"));
        RuleFile ruleFile = DirectoryManager.ins.get(l);
        if (ruleFile != null) {
            boolean bl = DirectoryManager.ins.checkExist(ContextHolder.getProjectId(), l, ruleFile.getType(), string);
            if (bl) {
                throw new InfoException("\u6587\u4ef6\u3010" + string + "\u3011\u5df2\u5b58\u5728\uff01");
            }
            DirectoryManager.ins.changeName(l, string, SecurityUtils.getLoginUsername(httpServletRequest));
            SystemLogUtils.addRuleFileOperationLog(ruleFile.getType(), "rename", l, "\u91cd\u547d\u540d{type}\u76ee\u5f55[" + ruleFile.getName() + "]\u4e3a[" + string + "]");
        }
    }

    @Override
    public String url() {
        return "/directory";
    }
}

