/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.file;

import com.bstek.urule.builder.resource.ResourceType;
import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.ContextHolder;
import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.ParameterInvaidException;
import com.bstek.urule.console.Transactional;
import com.bstek.urule.console.admin.log.SystemLogUtils;
import com.bstek.urule.console.database.manager.file.FileManager;
import com.bstek.urule.console.database.manager.file.FileQuery;
import com.bstek.urule.console.database.manager.file.version.VersionFileManager;
import com.bstek.urule.console.database.manager.file.version.VersionFileQuery;
import com.bstek.urule.console.database.manager.project.ProjectManager;
import com.bstek.urule.console.database.manager.project.role.ProjectRoleManager;
import com.bstek.urule.console.database.model.FileInfo;
import com.bstek.urule.console.database.model.Project;
import com.bstek.urule.console.database.model.Role;
import com.bstek.urule.console.database.model.RuleFile;
import com.bstek.urule.console.database.model.VersionFile;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.security.URuleAuthorization;
import com.bstek.urule.console.type.ProjectRoleEnum;
import com.bstek.urule.console.util.FileUtils;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.exception.RuleException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class FileServletHandler
extends ApiServletHandler {
    private Map<String, String> e = new HashMap<String, String>();
    private static final String f = "urule_file_copy";

    public void load(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("id"));
        RuleFile ruleFile = FileManager.ins.get(l);
        this.a(httpServletResponse, ruleFile);
    }

    public void list(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        this.loadFiles("list", httpServletRequest, httpServletResponse);
    }

    public void searchRuleName(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = "<rule\\s+name=\\\"([^\\\"]*)";
        String string2 = "<loop-rule\\s+name=\\\"([^\\\"]*)";
        Pattern pattern = Pattern.compile(string);
        Pattern pattern2 = Pattern.compile(string2);
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        arrayList.add(pattern);
        arrayList.add(pattern2);
        String string3 = httpServletRequest.getParameter("projectId");
        String string4 = httpServletRequest.getParameter("nameLike");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(ResourceType.RuleSet.name());
        List<RuleFile> list = this.a(arrayList, arrayList2, string3, string4);
        this.a(httpServletResponse, list);
    }

    public void searchRemark(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = "<remark><!\\[CDATA\\[([^\\]]*)";
        Pattern pattern = Pattern.compile(string);
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        arrayList.add(pattern);
        String string2 = httpServletRequest.getParameter("projectId");
        String string3 = httpServletRequest.getParameter("nameLike");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(ResourceType.RuleSet.name());
        arrayList2.add(ResourceType.DecisionTree.name());
        arrayList2.add(ResourceType.DecisionTable.name());
        arrayList2.add(ResourceType.CrossDecisionTable.name());
        arrayList2.add(ResourceType.Scorecard.name());
        arrayList2.add(ResourceType.ComplexScorecard.name());
        arrayList2.add(ResourceType.ActionTemplate.name());
        arrayList2.add(ResourceType.ConditionTemplate.name());
        List<RuleFile> list = this.a(arrayList, arrayList2, string2, string3);
        this.a(httpServletResponse, list);
    }

    private List<RuleFile> a(List<Pattern> list, List<String> list2, String string, String string2) throws Exception {
        Object object;
        FileQuery fileQuery = FileManager.ins.newQuery();
        if (list2.size() > 0) {
            object = new String[list2.size()];
            fileQuery.types(list2.toArray((T[])object));
        }
        fileQuery.asc("NAME_");
        fileQuery.deleted(false);
        fileQuery.containCommonProject(true);
        object = new ArrayList();
        List<RuleFile> list3 = fileQuery.list(Long.valueOf(string));
        block0: for (RuleFile ruleFile : list3) {
            String string3 = FileManager.ins.loadContent(ruleFile.getId());
            boolean bl = false;
            for (Pattern pattern : list) {
                Matcher matcher = pattern.matcher(string3);
                while (matcher.find()) {
                    String string4 = matcher.group(1);
                    if (string4.indexOf(string2) <= -1) continue;
                    object.add(ruleFile);
                    bl = true;
                    break;
                }
                if (!bl) continue;
                continue block0;
            }
        }
        return object;
    }

    public void tree(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        this.loadFiles("tree", httpServletRequest, httpServletResponse);
    }

    public void content(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("fileId");
        String string2 = httpServletRequest.getParameter("versionFileId");
        if (StringUtils.isNotBlank(string)) {
            long l = Long.valueOf(string);
            String string3 = FileManager.ins.loadContent(l);
            this.a(httpServletResponse, FileUtils.formatXml(string3));
        } else if (StringUtils.isNotBlank(string2)) {
            long l = Long.valueOf(string2);
            String string4 = VersionFileManager.ins.loadFileContent(l);
            this.a(httpServletResponse, FileUtils.formatXml(string4));
        }
    }

    @Override
    public void info(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = httpServletRequest.getParameter("fileId");
        long l = Long.valueOf(string);
        String string2 = FileManager.ins.loadContent(l);
        hashMap.put("size", string2.length());
        RuleFile ruleFile = FileManager.ins.get(l);
        hashMap.put("updateUser", ruleFile.getUpdateUser());
        hashMap.put("createDate", ruleFile.getCreateDate());
        hashMap.put("path", ruleFile.getPath());
        hashMap.put("latestVersion", ruleFile.getLatestVersion());
        this.a(httpServletResponse, hashMap);
    }

    public void versionFiles(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("fileId"));
        VersionFileQuery versionFileQuery = VersionFileManager.ins.newQuery().fileId(l);
        versionFileQuery.versionLike(httpServletRequest.getParameter("version")).noteLike(httpServletRequest.getParameter("note"));
        int n = Integer.valueOf(httpServletRequest.getParameter("pageIndex"));
        int n2 = Integer.valueOf(httpServletRequest.getParameter("pageSize"));
        this.a(httpServletResponse, versionFileQuery.paging(n, n2));
    }

    public void loadFiles(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        FileQuery fileQuery = FileManager.ins.newQuery();
        String string2 = httpServletRequest.getParameter("projectId");
        fileQuery.name(httpServletRequest.getParameter("name"));
        String string3 = httpServletRequest.getParameter("nameLike");
        if (StringUtils.isNotBlank(string3)) {
            fileQuery.nameLike(string3);
        }
        fileQuery.type(httpServletRequest.getParameter("type"));
        String string4 = httpServletRequest.getParameter("types");
        if (string4 != null) {
            object = string4.split(",");
            fileQuery.types((String[])object);
        }
        fileQuery.lockedUser(httpServletRequest.getParameter("lockedUser"));
        fileQuery.asc("NAME_");
        fileQuery.deleted(false);
        object = httpServletRequest.getParameter("removeEmpty");
        if (StringUtils.isNotBlank(object)) {
            fileQuery.removeEmpty(Boolean.valueOf((String)object));
        }
        fileQuery.containCommonProject(true);
        if (string.contentEquals("list")) {
            this.a(httpServletResponse, fileQuery.list(Long.valueOf(string2)));
        } else {
            this.a(httpServletResponse, fileQuery.tree(Long.valueOf(string2)));
        }
    }

    private void a(String string, long l, long l2, String string2) {
        if (StringUtils.isBlank(string)) {
            throw new InfoException("\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (FileManager.ins.checkExist(l2, l, string2, string)) {
            throw new InfoException("\u6587\u4ef6\u3010" + string + "\u3011\u5df2\u5b58\u5728\uff01");
        }
        if (!StringUtils.isLetterDigitOrChinese(string)) {
            throw new InfoException("\u65e0\u6548\u540d\u79f0,\u53ea\u80fd\u4f7f\u7528\u4e2d\u82f1\u6587\u5b57\u6bcd,\u6570\u5b57\u548c\u4e0b\u5212\u7ebf");
        }
    }

    @URuleAuthorization(authType="project", code="add", ruleFile=true)
    public void add(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("parentId"));
        long l2 = ContextHolder.getProjectId();
        String string = httpServletRequest.getParameter("type");
        String string2 = httpServletRequest.getParameter("name");
        if (StringUtils.isNotBlank(string2)) {
            string2 = string2.trim();
        }
        this.a(string2, l, l2, string);
        String string3 = this.a(string);
        RuleFile ruleFile = new RuleFile();
        ruleFile.setDirectory(false);
        ruleFile.setParentId(l);
        ruleFile.setProjectId(l2);
        ruleFile.setName(string2);
        ruleFile.setType(string);
        ruleFile.setContent(string3);
        ruleFile.setCreateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        FileManager.ins.add(ruleFile);
        this.a(httpServletResponse, ruleFile);
        SystemLogUtils.addRuleFileOperationLog(ruleFile.getType(), "add", ruleFile.getId(), "\u6dfb\u52a0{type}\u6587\u4ef6[" + ruleFile.getName() + "]");
    }

    @URuleAuthorization(authType="project", code="update", ruleFile=true)
    public void saveFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("id"));
        String string = httpServletRequest.getParameter("xml");
        if (StringUtils.isBlank(string)) {
            throw new RuleException("\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58!<br>The file content is empty, can't save!");
        }
        string = URLDecoder.decode(string, "utf-8");
        RuleFile ruleFile = FileManager.ins.get(l);
        String string2 = SecurityUtils.getLoginUsername(httpServletRequest);
        if (!StringUtils.isBlank(ruleFile.getLockedUser()) && !ruleFile.getLockedUser().equals(string2)) {
            throw new RuleException("\u6587\u4ef6\u5df2\u88ab[" + ruleFile.getLockedUser() + "]\u9501\u5b9a,\u65e0\u6cd5\u4fdd\u5b58,\u8bf7\u5148\u89e3\u9501!<br>The file has been locked by [" + ruleFile.getLockedUser() + "]. Please unlock it first!");
        }
        FileManager.ins.updateContent(l, string2, string);
        FileManager.ins.lock(l, string2);
        SystemLogUtils.addRuleFileOperationLog(ruleFile.getType(), "update", ruleFile.getId(), "\u4fdd\u5b58{type}\u6587\u4ef6[" + ruleFile.getName() + "]");
    }

    @URuleAuthorization(authType="project", code="update", ruleFile=true)
    public void copy(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Long l = Long.valueOf(httpServletRequest.getParameter("id"));
        httpServletRequest.getSession().setAttribute(f, (Object)l);
    }

    @URuleAuthorization(authType="project", code="add", ruleDir=true)
    public void paste(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("id"));
        String string = httpServletRequest.getParameter("name");
        Object object = httpServletRequest.getSession().getAttribute(f);
        if (object == null) {
            throw new InfoException("No File for Paste!");
        }
        RuleFile ruleFile = FileManager.ins.get((Long)object);
        String string2 = FileManager.ins.loadContent((Long)object);
        if (ruleFile.getType().contentEquals(ResourceType.ActionLibrary.name())) {
            String string3 = "uuid=\"(.*?)\"";
            string2 = this.a(string2, "uuid", string3);
        } else if (ruleFile.getType().contentEquals(ResourceType.VariableLibrary.name())) {
            String string4 = "uuid=\"(.*?)\"";
            string2 = this.a(string2, "uuid", string4);
        } else if (ruleFile.getType().contentEquals(ResourceType.ParameterLibrary.name())) {
            String string5 = "uuid=\"(.*?)\"";
            string2 = this.a(string2, "uuid", string5);
        } else if (ruleFile.getType().contentEquals(ResourceType.ConstantLibrary.name())) {
            String string6 = "uuid=\"(.*?)\"";
            string2 = this.a(string2, "uuid", string6);
        } else if (ruleFile.getType().contentEquals(ResourceType.ConditionTemplate.name())) {
            String string7 = "id=\"(.*?)\"";
            string2 = this.a(string2, "id", string7);
        } else if (ruleFile.getType().contentEquals(ResourceType.ActionTemplate.name())) {
            String string8 = "id=\"(.*?)\"";
            string2 = this.a(string2, "id", string8);
        }
        ruleFile.setName(string);
        ruleFile.setLatestVersion(null);
        ruleFile.setDigest(null);
        ruleFile.setDeleted(false);
        ruleFile.setContent(string2);
        ruleFile.setCreateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        if (l == 0L) {
            ruleFile.setParentId(0L);
            FileManager.ins.add(ruleFile);
        } else {
            ruleFile.setParentId(l);
            FileManager.ins.add(ruleFile);
        }
        this.a(httpServletResponse, ruleFile);
        SystemLogUtils.addRuleFileOperationLog(ruleFile.getType(), "add", ruleFile.getId(), "\u65b0\u5efa{type}\u6587\u4ef6[" + ruleFile.getName() + "]");
    }

    private String a(String string, String string2, String string3) throws Exception {
        Pattern pattern = Pattern.compile(string3);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string4 = string2 + "=\"" + UUID.randomUUID().toString() + "\"";
            matcher.appendReplacement(stringBuffer, string4);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    @URuleAuthorization(authType="project", code="remove", ruleFile=true)
    public void remove(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("id"));
        RuleFile ruleFile = FileManager.ins.get(l);
        String string = SecurityUtils.getLoginUsername(httpServletRequest);
        if (!StringUtils.isBlank(ruleFile.getLockedUser()) && !ruleFile.getLockedUser().equals(string)) {
            throw new RuleException("\u6587\u4ef6\u5df2\u88ab[" + ruleFile.getLockedUser() + "]\u9501\u5b9a,\u65e0\u6cd5\u5220\u9664,\u8bf7\u5148\u89e3\u9501!<br>The file has been locked by [" + ruleFile.getLockedUser() + "]. Please unlock it first!");
        }
        FileManager.ins.updateDeleteFlag(l, true, SecurityUtils.getLoginUsername(httpServletRequest));
        SystemLogUtils.addRuleFileOperationLog(ruleFile.getType(), "remove", ruleFile.getId(), "\u5220\u9664{type}\u6587\u4ef6[" + ruleFile.getName() + "]");
    }

    @URuleAuthorization(authType="project", code="update", ruleFile=true)
    public void move(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("id"));
        long l2 = Long.valueOf(httpServletRequest.getParameter("parentId"));
        RuleFile ruleFile = FileManager.ins.get(l);
        String string = SecurityUtils.getLoginUsername(httpServletRequest);
        if (!StringUtils.isBlank(ruleFile.getLockedUser()) && !ruleFile.getLockedUser().equals(string)) {
            throw new RuleException("\u6587\u4ef6\u5df2\u88ab[" + ruleFile.getLockedUser() + "]\u9501\u5b9a,\u65e0\u6cd5\u79fb\u52a8,\u8bf7\u5148\u89e3\u9501!<br>The file has been locked by [" + ruleFile.getLockedUser() + "]. Please unlock it first!");
        }
        FileManager.ins.changeParent(l, l2);
        SystemLogUtils.addRuleFileOperationLog(ruleFile.getType(), "update", ruleFile.getId(), "\u79fb\u52a8{type}\u6587\u4ef6[" + ruleFile.getName() + "]");
    }

    @URuleAuthorization(authType="project", code="update", ruleFile=true)
    public void rename(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l;
        RuleFile ruleFile;
        String string = httpServletRequest.getParameter("newName");
        if (StringUtils.isNotBlank(string)) {
            string = string.trim();
        }
        if ((ruleFile = FileManager.ins.get(l = Long.valueOf(httpServletRequest.getParameter("id")).longValue())).getName().equals(string)) {
            return;
        }
        this.a(string, ruleFile.getParentId(), ruleFile.getProjectId(), ruleFile.getType());
        String string2 = SecurityUtils.getLoginUsername(httpServletRequest);
        if (!StringUtils.isBlank(ruleFile.getLockedUser()) && !ruleFile.getLockedUser().equals(string2)) {
            throw new RuleException("\u6587\u4ef6\u5df2\u88ab[" + ruleFile.getLockedUser() + "]\u9501\u5b9a,\u65e0\u6cd5\u91cd\u547d\u540d,\u8bf7\u5148\u89e3\u9501!<br>The file has been locked by [" + ruleFile.getLockedUser() + "]. Please unlock it first!");
        }
        FileManager.ins.rename(l, SecurityUtils.getLoginUsername(httpServletRequest), string);
        SystemLogUtils.addRuleFileOperationLog(ruleFile.getType(), "rename", ruleFile.getId(), "\u91cd\u547d\u540d{type}\u6587\u4ef6[" + ruleFile.getName() + "]");
    }

    @Transactional
    @URuleAuthorization(authType="project", code="update", ruleFile=true)
    public void unlock(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        Object object2;
        long l = Long.valueOf(httpServletRequest.getParameter("id"));
        String string = httpServletRequest.getParameter("note");
        Project project = ProjectManager.ins.get(ContextHolder.getProjectId());
        String string2 = SecurityUtils.getLoginUsername(httpServletRequest);
        List<Role> list = ProjectRoleManager.ins.loadUserRoles(ContextHolder.getProjectId(), string2);
        boolean bl = project.getCreateUser().equals(string2);
        if (!bl) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (Role)object2.next();
                if (!((Role)object).getName().equals(ProjectRoleEnum.Manager.name())) continue;
                bl = true;
                break;
            }
        }
        if (!StringUtils.isNotBlank(((RuleFile)(object2 = FileManager.ins.get(l))).getLockedUser()) || !((RuleFile)object2).getLockedUser().equals(string2) && !bl) {
            throw new ParameterInvaidException();
        }
        object = FileUtils.getMaxVersion(((RuleFile)object2).getLatestVersion());
        VersionFile versionFile = new VersionFile();
        versionFile.setContent(((FileInfo)object2).getContent());
        versionFile.setFileId(l);
        versionFile.setProjectId(((RuleFile)object2).getProjectId());
        versionFile.setName(((FileInfo)object2).getName());
        versionFile.setNote(string);
        versionFile.setVersion((String)object);
        versionFile.setCreateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        versionFile.setContent(FileManager.ins.loadContent(l));
        VersionFileManager.ins.saveFile(versionFile);
        FileManager.ins.unlock(l, (String)object, SecurityUtils.getLoginUsername(httpServletRequest));
        SystemLogUtils.addRuleFileOperationLog(((RuleFile)object2).getType(), "unlock", ((FileInfo)object2).getId(), "\u89e3\u9501{type}\u6587\u4ef6[" + ((FileInfo)object2).getName() + "]");
    }

    private String a(String string) {
        if (this.e.containsKey(string)) {
            return this.e.get(string);
        }
        String string2 = null;
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getClassLoader().getResourceAsStream("com/bstek/urule/console/file/template/" + string + ".xml");
            string2 = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
        }
        catch (Exception exception) {
            try {
                throw new RuleException(exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        this.e.put(string, string2);
        return string2;
    }

    @URuleAuthorization(authType="project", code="update", ruleFile=true)
    public void newVersion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.parseLong(httpServletRequest.getParameter("id"));
        RuleFile ruleFile = FileManager.ins.get(l);
        String string = FileUtils.getMaxVersion(ruleFile.getLatestVersion());
        this.a(httpServletResponse, string);
    }

    @Override
    public String url() {
        return "/file";
    }
}

