/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.security;

import com.bstek.urule.console.ContextHolder;
import com.bstek.urule.console.config.Configure;
import com.bstek.urule.console.database.manager.authority.AuthorityManager;
import com.bstek.urule.console.database.manager.group.role.GroupRoleManager;
import com.bstek.urule.console.database.manager.project.role.ProjectRoleManager;
import com.bstek.urule.console.database.model.Authority;
import com.bstek.urule.console.database.model.Role;
import com.bstek.urule.console.security.entity.User;
import com.bstek.urule.console.type.GroupRoleEnum;
import com.bstek.urule.console.type.ProjectRoleEnum;
import com.bstek.urule.console.type.RoleCategory;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthenticationManager {
    private static final Log a = LogFactory.getLog(AuthenticationManager.class);
    public static final int NO_AUTHORITYS = 2;
    public static final int NO_GRANT = 0;
    public static final int GRANT = 1;

    private static boolean a() {
        return Configure.getConfigure().getBoolean("urule.security.useConservativeStrategy", true);
    }

    public static boolean isGranted(int n) {
        if (n == 1) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        if (n == 2) {
            return !AuthenticationManager.a();
        }
        return true;
    }

    public static boolean decide(User user, RoleCategory roleCategory, String string, String string2) {
        a.debug((Object)("user:" + user + ",roleType:" + roleCategory.toString() + ",modelCode:" + string + ",resourceCode:" + string2));
        try {
            String string3 = string + "_" + string2;
            int n = AuthenticationManager.a(user, roleCategory, string3);
            return AuthenticationManager.isGranted(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            a.error((Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public static boolean decide(Role role, RoleCategory roleCategory, String string, String string2) {
        a.debug((Object)("role:" + role + ",roleType:" + roleCategory.toString() + ",modelCode:" + string + ",resourceCode:" + string2));
        try {
            String string3 = string + "_" + string2;
            List<Authority> list = AuthorityManager.ins.getAuthoritysByCode(roleCategory.toString(), string3);
            int n = AuthenticationManager.a(list, role, roleCategory, string3);
            return n == 1;
        }
        catch (Exception exception) {
            a.error((Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    private static int a(User user, RoleCategory roleCategory, String string) throws Exception {
        Role role;
        int n = 2;
        List<Authority> list = AuthorityManager.ins.getAuthoritysByCode(roleCategory.toString(), string);
        List<Role> list2 = null;
        list2 = roleCategory == RoleCategory.group ? GroupRoleManager.ins.loadUserRoles(ContextHolder.getGroupId(), user.getName()) : ProjectRoleManager.ins.loadUserRoles(ContextHolder.getProjectId(), user.getName());
        a.debug((Object)("roles:" + list2));
        Iterator<Role> iterator = list2.iterator();
        while (iterator.hasNext() && (n = AuthenticationManager.a(list, role = iterator.next(), roleCategory, string)) != 1) {
        }
        if (n == 1) {
            return 1;
        }
        return 0;
    }

    private static int a(List<Authority> list, Role role, RoleCategory roleCategory, String string) throws Exception {
        if (role.getName().equals(GroupRoleEnum.Owner.name()) || role.getName().equals(ProjectRoleEnum.Manager.name())) {
            return 1;
        }
        int n = 2;
        if (list.size() == 0) {
            return 2;
        }
        for (Authority authority : list) {
            if (authority.getRoleId() != role.getId()) continue;
            n = 1;
            break;
        }
        if (n == 1) {
            return 1;
        }
        return 0;
    }
}

