/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.util;

import com.bstek.urule.console.config.Configure;
import com.bstek.urule.console.util.MailInfo;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class MailUtils {
    public static void sendHtmlMail(MailInfo mailInfo) throws Exception {
        mailInfo.setHost(Configure.getConfigure().getProperty("urule.mail.smtp.host"));
        mailInfo.setFormName(Configure.getConfigure().getProperty("urule.mail.smtp.user"));
        mailInfo.setFormPassword(Configure.getConfigure().getProperty("urule.mail.smtp.pass"));
        mailInfo.setAuth(Configure.getConfigure().getBoolean("urule.mail.smtp.auth", true));
        Message message = MailUtils.a(mailInfo);
        MimeMultipart mimeMultipart = new MimeMultipart();
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent((Object)mailInfo.getContent(), "text/html; charset=utf-8");
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        message.setContent((Multipart)mimeMultipart);
        Transport.send((Message)message);
    }

    private static Message a(MailInfo mailInfo) throws Exception {
        final Properties properties = System.getProperties();
        properties.setProperty("mail.smtp.host", mailInfo.getHost());
        properties.setProperty("mail.smtp.auth", Boolean.toString(mailInfo.isAuth()));
        properties.setProperty("mail.smtp.user", mailInfo.getFormName());
        properties.setProperty("mail.smtp.pass", mailInfo.getFormPassword());
        Session session = null;
        session = mailInfo.isAuth() ? Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(properties.getProperty("mail.smtp.user"), properties.getProperty("mail.smtp.pass"));
            }
        }) : Session.getInstance((Properties)properties);
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setSubject(MimeUtility.encodeText((String)mailInfo.getSubject(), (String)"UTF-8", (String)"B"));
        mimeMessage.setFrom((Address)new InternetAddress(properties.getProperty("mail.smtp.user"), Configure.getConfigure().getProperty("urule.application.title", "URULE")));
        mimeMessage.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(mailInfo.getToAddress()));
        mimeMessage.setSentDate(new Date());
        return mimeMessage;
    }
}

