/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.util;

import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.exception.RuleException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;

public class Tools {
    private static Pattern a = Pattern.compile("-?[0-9]+\\.?[0-9]*");
    private static final List<String> b = new ArrayList<String>();
    private static final List<String> c = new ArrayList<String>();

    public static boolean isNumber(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            String string = (String)object;
            return a.matcher(string).matches();
        }
        return object instanceof Number;
    }

    public static BigDecimal toBigDecimal(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof String) {
            try {
                String string = object.toString().trim();
                return new BigDecimal(string);
            }
            catch (Exception exception) {
                throw new RuleException("Can not convert " + object + " to BigDecimal.");
            }
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            if (number instanceof Integer) {
                return new BigDecimal(Integer.toString(number.intValue()));
            }
            if (number instanceof Float) {
                return new BigDecimal(Float.toString(number.floatValue()));
            }
            if (number instanceof Double) {
                return new BigDecimal(Double.toString(number.doubleValue()));
            }
            if (number instanceof Long) {
                return new BigDecimal(Long.toString(number.longValue()));
            }
            if (number instanceof Byte) {
                return new BigDecimal(Byte.toString(number.byteValue()));
            }
            return new BigDecimal(number.toString());
        }
        throw new RuleException("Can not convert " + object + " to BigDecimal.");
    }

    public static Date toDateOrDatatime(String string) {
        try {
            return Tools.toDate(string);
        }
        catch (Exception exception) {
            return Tools.toDatetime(string);
        }
    }

    public static Date toDate(String string) {
        for (String string2 : b) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
                return simpleDateFormat.parse(string);
            }
            catch (Exception exception) {
            }
        }
        throw new RuleException("Can not convert [" + string + "] to date");
    }

    public static Date toDatetime(String string) {
        for (String string2 : c) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
                return simpleDateFormat.parse(string);
            }
            catch (Exception exception) {
            }
        }
        throw new RuleException("Can not convert [" + string + "] to date time");
    }

    public static List<String> toList(String string) {
        String[] stringArray = string.split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static Object getProperty(Object object, String string) {
        if (object == null) {
            return null;
        }
        try {
            if (object instanceof Map && string.indexOf(".") == -1) {
                Map map = (Map)object;
                return map.get(string);
            }
            return PropertyUtils.getProperty((Object)object, (String)string);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    public static int processSpan(int n) {
        if (n == 1) {
            n = 0;
        } else if (n > 1) {
            --n;
        }
        return n;
    }

    public static Date toDate(String string, String string2) {
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        if (StringUtils.isEmpty(string2)) {
            throw new RuleException("\u65e5\u671f\u683c\u5f0f\u7684\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        try {
            return simpleDateFormat.parse(string.toString());
        }
        catch (ParseException parseException) {
            throw new RuleException((Exception)parseException);
        }
    }

    public static String formatDate(Object object, String string) {
        if (StringUtils.isEmpty(object)) {
            return "";
        }
        if (StringUtils.isEmpty(string)) {
            throw new RuleException("\u65e5\u671f\u683c\u5f0f\u7684\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Date date = (Date)object;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(date);
    }

    public static String formatNumber(Object object, String string) {
        if (StringUtils.isEmpty(object)) {
            return "";
        }
        if (StringUtils.isEmpty(string)) {
            throw new RuleException("\u6570\u5b57\u683c\u5f0f\u5316\u7684\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        DecimalFormat decimalFormat = new DecimalFormat(string);
        return decimalFormat.format(Tools.toBigDecimal(object).doubleValue());
    }

    static {
        b.add("yyyy-MM-dd");
        b.add("yyyy/MM/dd");
        b.add("yyyy.MM.dd");
        b.add("yyyy\u5e74MM\u6708dd\u65e5");
        c.add("yyyy-MM-dd HH:mm:ss");
        c.add("yyyy/MM/dd HH:mm:ss");
        c.add("yyyy.MM.dd HH:mm:ss");
        c.add("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss");
    }
}

