/*
 * Decompiled with CFR 0.152.
 */
package com.btcassessors;

import com.btcassessors.Sha256Hash;
import com.btcassessors.proof.Proof;
import com.btcassessors.proof.ProofItem;
import com.btcassessors.proof.ProofItemDirection;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/btcassessors/MerkleTree;", "", "leafs", "", "Lcom/btcassessors/Sha256Hash;", "(Ljava/util/List;)V", "getLeafs", "()Ljava/util/List;", "padding", "root", "getRoot", "()Lcom/btcassessors/Sha256Hash;", "steps", "", "generateProof", "Lcom/btcassessors/proof/Proof;", "leafIndex", "", "merkletree"})
public final class MerkleTree {
    private final Sha256Hash padding;
    private List<List<Sha256Hash>> steps;
    @NotNull
    private final List<Sha256Hash> leafs;

    @NotNull
    public final Sha256Hash getRoot() {
        return (Sha256Hash)((List)CollectionsKt.last(this.steps)).get(0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Proof generateProof(int leafIndex) {
        if (leafIndex > this.leafs.size()) {
            throw (Throwable)new IndexOutOfBoundsException("Leaf index out of range");
        }
        Sha256Hash target = this.steps.get(0).get(leafIndex);
        List proofs = new ArrayList();
        Sha256Hash currentTarget = target;
        int n = 0;
        float f = MathKt.log2((float)this.leafs.size());
        int n2 = (int)Math.ceil(f);
        while (n < n2) {
            void i;
            int currentIndex = this.steps.get((int)i).indexOf(currentTarget);
            if (currentIndex % 2 == 0) {
                proofs.add(new ProofItem(ProofItemDirection.RIGHT, this.steps.get((int)i).get(currentIndex + 1)));
            } else {
                proofs.add(new ProofItem(ProofItemDirection.LEFT, this.steps.get((int)i).get(currentIndex - 1)));
            }
            currentTarget = this.steps.get((int)(i + true)).get(currentIndex / 2);
            ++i;
        }
        return new Proof(proofs);
    }

    @NotNull
    public final List<Sha256Hash> getLeafs() {
        return this.leafs;
    }

    public MerkleTree(@NotNull List<Sha256Hash> leafs) {
        List list;
        Intrinsics.checkParameterIsNotNull(leafs, (String)"leafs");
        this.leafs = leafs;
        this.padding = new Sha256Hash(new byte[32]);
        Object object = this;
        ((MerkleTree)object).steps = list = (List)new ArrayList();
        if (this.leafs.isEmpty()) {
            throw (Throwable)new IllegalArgumentException("A Merkle tree requires at least one element");
        }
        if (this.leafs.size() == 1) {
            this.steps = CollectionsKt.mutableListOf((Object[])new List[]{CollectionsKt.listOf((Object)this.leafs.get(0))});
        } else {
            List finalLeafs;
            object = this;
            ((MerkleTree)object).steps = list = (List)new ArrayList();
            int n = 2;
            BigInteger bigInteger = BigInteger.valueOf(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"BigInteger.valueOf(this.toLong())");
            float f = MathKt.log2((float)this.leafs.size());
            object = bigInteger;
            float f2 = (float)Math.ceil(f);
            int paddingCount = ((BigInteger)object).pow((int)f2).intValue() - this.leafs.size();
            object = this.leafs;
            ArrayList<Sha256Hash> arrayList = new ArrayList<Sha256Hash>(paddingCount);
            int n2 = 0;
            int n3 = paddingCount;
            while (n2 < n3) {
                int n4;
                int n5 = n4 = n2++;
                ArrayList<Sha256Hash> arrayList2 = arrayList;
                boolean bl = false;
                Sha256Hash sha256Hash = this.padding;
                arrayList2.add(sha256Hash);
            }
            List list2 = arrayList;
            List previousList = finalLeafs = CollectionsKt.plus((Collection)object, (Iterable)list2);
            List currentList = null;
            do {
                this.steps.add(previousList);
                currentList = new ArrayList();
                int idx = 0;
                int iterations = previousList.size() / 2;
                while (currentList.size() < iterations) {
                    byte[] byArray = MessageDigest.getInstance("SHA-256").digest(ArraysKt.plus((byte[])((Sha256Hash)previousList.get(idx)).getDigest(), (byte[])((Sha256Hash)previousList.get(idx + 1)).getDigest()));
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"MessageDigest.getInstanc\u2026                        )");
                    currentList.add(new Sha256Hash(byArray));
                    idx += 2;
                }
                previousList = currentList;
            } while (currentList.size() >= 2);
            this.steps.add(previousList);
        }
    }
}

