/*
 * Decompiled with CFR 0.152.
 */
package com.btcassessors;

import com.btcassessors.ByteArrayUtilsKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/btcassessors/Sha256Hash;", "", "digest", "", "([B)V", "getDigest", "()[B", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "merkletree"})
public final class Sha256Hash {
    @NotNull
    private final byte[] digest;

    public boolean equals(@Nullable Object other) {
        if (other instanceof Sha256Hash) {
            byte[] byArray = this.digest;
            byte[] byArray2 = ((Sha256Hash)other).digest;
            return Arrays.equals(byArray, byArray2);
        }
        return false;
    }

    public int hashCode() {
        byte[] byArray = this.digest;
        return Arrays.hashCode(byArray);
    }

    @NotNull
    public String toString() {
        return ByteArrayUtilsKt.toHexString(this.digest);
    }

    @NotNull
    public final byte[] getDigest() {
        return this.digest;
    }

    public Sha256Hash(@NotNull byte[] digest) {
        Intrinsics.checkParameterIsNotNull((Object)digest, (String)"digest");
        this.digest = digest;
        if (this.digest.length != 32) {
            throw (Throwable)new IllegalArgumentException("Invalid length for a sha256");
        }
    }

    @NotNull
    public final byte[] component1() {
        return this.digest;
    }

    @NotNull
    public final Sha256Hash copy(@NotNull byte[] digest) {
        Intrinsics.checkParameterIsNotNull((Object)digest, (String)"digest");
        return new Sha256Hash(digest);
    }

    @NotNull
    public static /* synthetic */ Sha256Hash copy$default(Sha256Hash sha256Hash, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            byArray = sha256Hash.digest;
        }
        return sha256Hash.copy(byArray);
    }
}

