/*
 * Decompiled with CFR 0.152.
 */
package com.btcassessors.proof;

import com.btcassessors.Sha256Hash;
import com.btcassessors.proof.Proof$WhenMappings;
import com.btcassessors.proof.ProofItem;
import java.security.MessageDigest;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0016\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/btcassessors/proof/Proof;", "", "proofItems", "", "Lcom/btcassessors/proof/ProofItem;", "(Ljava/util/List;)V", "getProofItems", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "validates", "merkleRoot", "Lcom/btcassessors/Sha256Hash;", "targetHash", "merkletree"})
public final class Proof {
    @NotNull
    private final List<ProofItem> proofItems;

    public final boolean validates(@NotNull Sha256Hash merkleRoot, @NotNull Sha256Hash targetHash) {
        Intrinsics.checkParameterIsNotNull((Object)merkleRoot, (String)"merkleRoot");
        Intrinsics.checkParameterIsNotNull((Object)targetHash, (String)"targetHash");
        if (this.proofItems.isEmpty()) {
            return Intrinsics.areEqual((Object)targetHash, (Object)merkleRoot);
        }
        Sha256Hash proofHash = targetHash;
        for (ProofItem item : this.proofItems) {
            switch (Proof$WhenMappings.$EnumSwitchMapping$0[item.getDirection().ordinal()]) {
                case 1: {
                    byte[] byArray = MessageDigest.getInstance("SHA-256").digest(ArraysKt.plus((byte[])item.getHash().getDigest(), (byte[])proofHash.getDigest()));
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"MessageDigest.getInstanc\u2026                        )");
                    proofHash = new Sha256Hash(byArray);
                    break;
                }
                case 2: {
                    byte[] byArray = MessageDigest.getInstance("SHA-256").digest(ArraysKt.plus((byte[])proofHash.getDigest(), (byte[])item.getHash().getDigest()));
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"MessageDigest.getInstanc\u2026                        )");
                    proofHash = new Sha256Hash(byArray);
                }
            }
        }
        return Intrinsics.areEqual((Object)proofHash, (Object)merkleRoot);
    }

    @NotNull
    public final List<ProofItem> getProofItems() {
        return this.proofItems;
    }

    public Proof(@NotNull List<ProofItem> proofItems) {
        Intrinsics.checkParameterIsNotNull(proofItems, (String)"proofItems");
        this.proofItems = proofItems;
    }

    @NotNull
    public final List<ProofItem> component1() {
        return this.proofItems;
    }

    @NotNull
    public final Proof copy(@NotNull List<ProofItem> proofItems) {
        Intrinsics.checkParameterIsNotNull(proofItems, (String)"proofItems");
        return new Proof(proofItems);
    }

    @NotNull
    public static /* synthetic */ Proof copy$default(Proof proof, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = proof.proofItems;
        }
        return proof.copy(list);
    }

    @NotNull
    public String toString() {
        return "Proof(proofItems=" + this.proofItems + ")";
    }

    public int hashCode() {
        List<ProofItem> list = this.proofItems;
        return list != null ? ((Object)list).hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Proof)) break block3;
                Proof proof = (Proof)object;
                if (!Intrinsics.areEqual(this.proofItems, proof.proofItems)) break block3;
            }
            return true;
        }
        return false;
    }
}

