/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.maven.plugins.ldap.mojo;

import com.btmatthews.maven.plugins.ldap.FormatLogger;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractLDAPMojo
extends AbstractMojo
implements FormatLogger {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 389;
    @Parameter(defaultValue="localhost")
    private String host = "localhost";
    @Parameter(defaultValue="389")
    private int port = 389;
    @Parameter(required=true)
    private String authDn;
    @Parameter(required=true)
    private String passwd;
    @Parameter(defaultValue="5000")
    private int connectionTimeout = 5000;
    @Parameter(defaultValue="3")
    private int connectionRetries = 3;
    @Parameter(defaultValue="false")
    private boolean skip;

    protected final LDAPConnection connect() throws MojoExecutionException {
        LDAPConnection connection = new LDAPConnection();
        int i = 0;
        while (i < this.connectionRetries) {
            long start = System.currentTimeMillis();
            try {
                this.getLog().info((CharSequence)("Attempting to connect ot LDAP directory server (" + this.host + ":" + this.port + ")"));
                connection.connect(this.host, this.port, this.connectionTimeout);
                break;
            }
            catch (LDAPException e) {
                String message = "Could not connect to LDAP directory server (" + this.host + ":" + this.port + ")";
                this.getLog().error((CharSequence)message, (Throwable)e);
                if (i++ < this.connectionRetries) {
                    long time = System.currentTimeMillis() - start;
                    if (time >= (long)this.connectionTimeout) continue;
                    try {
                        Thread.sleep((long)this.connectionTimeout - time);
                        continue;
                    }
                    catch (InterruptedException e1) {
                        throw new MojoExecutionException(message, (Exception)e1);
                    }
                }
                throw new MojoExecutionException(message, (Exception)((Object)e));
            }
        }
        try {
            connection.bind(this.authDn, this.passwd);
        }
        catch (LDAPException e) {
            throw new MojoExecutionException("Could not bind to LDAP directory server as " + this.authDn, (Exception)((Object)e));
        }
        return connection;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void logInfo(String message) {
        this.getLog().info((CharSequence)message);
    }

    public void logError(String message) {
        this.getLog().error((CharSequence)message);
    }

    public void logError(String message, Throwable exception) {
        this.getLog().error((CharSequence)message, exception);
    }
}

