/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.maven.plugins.ldap.mojo;

import com.btmatthews.maven.plugins.ldap.mojo.Source;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public abstract class AbstractSource
implements Source {
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final int CLASSPATH_PREFIX_LENGTH = 10;
    private String path;

    protected AbstractSource(String path) {
        this.path = path;
    }

    public void set(String path) {
        this.path = path;
    }

    public InputStream open() {
        if (this.path.startsWith(CLASSPATH_PREFIX)) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return loader.getResourceAsStream(this.path.substring(10));
        }
        File file = new File(this.path);
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public final String toString() {
        return this.path;
    }
}

