/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.maven.plugins.ldap.mojo;

import com.btmatthews.maven.plugins.ldap.FormatHandler;
import com.btmatthews.maven.plugins.ldap.FormatLogger;
import com.btmatthews.maven.plugins.ldap.dsml.DSMLFormatHandler;
import com.btmatthews.maven.plugins.ldap.ldif.LDIFFormatHandler;
import com.btmatthews.maven.plugins.ldap.mojo.AbstractLDAPMojo;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPInterface;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="dump")
public final class DumpMojo
extends AbstractLDAPMojo {
    private final FormatHandler dsmlFormatHandler = new DSMLFormatHandler();
    private final FormatHandler ldifFormatHandler = new LDIFFormatHandler();
    @Parameter(required=true)
    private String searchBase;
    @Parameter(defaultValue="(objectclass=*)", required=true)
    private String searchFilter;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(required=true)
    private String filename;
    @Parameter(defaultValue="ldif")
    private String format;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException {
        File outputFile = new File(this.outputDirectory, this.filename);
        if (this.outputDirectory.exists() || this.outputDirectory.mkdirs()) {
            try {
                FileOutputStream outputStream = new FileOutputStream(outputFile);
                try {
                    LDAPConnection connection = this.connect();
                    try {
                        FormatHandler handler = this.getFormatHandler();
                        if (handler != null) {
                            handler.dump((LDAPInterface)connection, this.searchBase, this.searchFilter, (OutputStream)outputStream, (FormatLogger)this);
                        }
                    }
                    finally {
                        connection.close();
                    }
                }
                finally {
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    private FormatHandler getFormatHandler() {
        if (this.format.equals("dsml")) {
            return this.dsmlFormatHandler;
        }
        if (this.format.equals("ldif")) {
            return this.ldifFormatHandler;
        }
        return null;
    }
}

