/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.maven.plugins.ldap.mojo;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultRepositoryRequest;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.configurator.AbstractComponentConfigurator;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.composite.ObjectWithFieldsConverter;
import org.codehaus.plexus.component.configurator.converters.special.ClassRealmConverter;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ComponentConfigurator.class, hint="include-server-dependencies")
public class IncludeServerDependenciesComponentConfigurator
extends AbstractComponentConfigurator {
    private static final String SERVER_TYPE_ATTRIBUTE = "serverType";
    private static final String DEFAULT_SERVER_TYPE_VALUE = "unboundid";
    private static final String DEFAULT_GROUP_ID = "com.btmatthews.maven.plugins.ldap";
    private static final String DEFAULT_ARTIFACT_ID_FORMAT = "server-{0}";
    @Requirement
    private RepositorySystem repositorySystem;

    public void configureComponent(Object component, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator, ClassRealm containerRealm, ConfigurationListener listener) throws ComponentConfigurationException {
        String serverType = this.getServerType(configuration);
        if (!serverType.startsWith("dependency-")) {
            this.addServerDependenciesToClassRealm(serverType, expressionEvaluator, containerRealm);
        }
        this.converterLookup.registerConverter((ConfigurationConverter)new ClassRealmConverter(containerRealm));
        ObjectWithFieldsConverter converter = new ObjectWithFieldsConverter();
        converter.processConfiguration(this.converterLookup, component, (ClassLoader)containerRealm, configuration, expressionEvaluator, listener);
    }

    private void addServerDependenciesToClassRealm(String serverType, ExpressionEvaluator expressionEvaluator, ClassRealm containerRealm) throws ComponentConfigurationException {
        Collection<Artifact> classpathElements = this.getServerDependencies(serverType, expressionEvaluator);
        if (classpathElements != null) {
            for (URL url : this.buildURLs(classpathElements)) {
                containerRealm.addURL(url);
            }
        }
    }

    private List<URL> buildURLs(Collection<Artifact> classpathElements) throws ComponentConfigurationException {
        ArrayList<URL> urls = new ArrayList<URL>(classpathElements.size());
        for (Artifact classpathElement : classpathElements) {
            try {
                URL url = classpathElement.getFile().toURI().toURL();
                urls.add(url);
            }
            catch (MalformedURLException e) {
                throw new ComponentConfigurationException("Unable to access project dependency: " + classpathElement, (Throwable)e);
            }
        }
        return urls;
    }

    private Collection<Artifact> getServerDependencies(String serverType, ExpressionEvaluator expressionEvaluator) throws ComponentConfigurationException {
        try {
            MavenProject project = (MavenProject)expressionEvaluator.evaluate("${project}");
            String localRepo = (String)expressionEvaluator.evaluate("${settings.localRepository}");
            ArtifactRepository localRepository = this.repositorySystem.createLocalRepository(new File(localRepo));
            DefaultRepositoryRequest repositoryRequest = new DefaultRepositoryRequest();
            repositoryRequest.setRemoteRepositories(project.getRemoteArtifactRepositories());
            repositoryRequest.setLocalRepository(localRepository);
            ArtifactResolutionRequest request = new ArtifactResolutionRequest((RepositoryRequest)repositoryRequest);
            request.setArtifact(this.getServerArtifact(serverType));
            request.setResolveTransitively(true);
            ArtifactResolutionResult result = this.repositorySystem.resolve(request);
            if (result.isSuccess()) {
                return result.getArtifacts();
            }
            boolean first = true;
            StringBuilder builder = new StringBuilder("Cannot resolve dependencies: [");
            for (Artifact artifact : result.getMissingArtifacts()) {
                if (!first) {
                    builder.append(',');
                } else {
                    first = false;
                }
                builder.append(artifact.getGroupId());
                builder.append(':');
                builder.append(artifact.getArtifactId());
                builder.append(':');
                builder.append(artifact.getVersion());
            }
            builder.append("]");
            throw new ComponentConfigurationException(builder.toString());
        }
        catch (ExpressionEvaluationException e) {
            throw new ComponentConfigurationException("Error evaluating expression", (Throwable)e);
        }
        catch (InvalidRepositoryException e) {
            throw new ComponentConfigurationException("Error resolving local repository", (Throwable)e);
        }
    }

    private Artifact getServerArtifact(String serverType) throws ComponentConfigurationException {
        if (serverType.startsWith("gav-")) {
            String[] gav;
            int index = serverType.indexOf("-", 4);
            if (index > 0 && (gav = serverType.substring(index + 1).split(":")).length == 3) {
                return this.repositorySystem.createArtifact(gav[0], gav[1], gav[2], "runtime", "jar");
            }
            throw new ComponentConfigurationException("Invalid server type: " + serverType);
        }
        return this.repositorySystem.createArtifact(DEFAULT_GROUP_ID, MessageFormat.format(DEFAULT_ARTIFACT_ID_FORMAT, serverType), ((Object)((Object)this)).getClass().getPackage().getImplementationVersion(), "runtime", "jar");
    }

    private String getServerType(PlexusConfiguration configuration) {
        Pattern pattern = Pattern.compile("\\$\\{[A-Za-z0-9\\._]+\\}");
        for (PlexusConfiguration cfg : configuration.getChildren()) {
            if (!cfg.getName().equals(SERVER_TYPE_ATTRIBUTE)) continue;
            if (pattern.matcher(cfg.getValue()).matches()) {
                return DEFAULT_SERVER_TYPE_VALUE;
            }
            return cfg.getValue();
        }
        return DEFAULT_SERVER_TYPE_VALUE;
    }
}

