/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.maven.plugins.ldap.mojo;

import com.btmatthews.maven.plugins.ldap.FormatHandler;
import com.btmatthews.maven.plugins.ldap.FormatLogger;
import com.btmatthews.maven.plugins.ldap.dsml.DSMLFormatHandler;
import com.btmatthews.maven.plugins.ldap.ldif.LDIFFormatHandler;
import com.btmatthews.maven.plugins.ldap.mojo.AbstractLDAPMojo;
import com.btmatthews.maven.plugins.ldap.mojo.Dsml;
import com.btmatthews.maven.plugins.ldap.mojo.Ldif;
import com.btmatthews.maven.plugins.ldap.mojo.Source;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPInterface;
import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="load")
public final class LoadMojo
extends AbstractLDAPMojo {
    private final FormatHandler dsmlFormatHandler = new DSMLFormatHandler();
    private final FormatHandler ldifFormatHandler = new LDIFFormatHandler();
    @Parameter(required=true)
    private Source[] sources;
    @Parameter(defaultValue="false")
    private boolean continueOnError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (!this.isSkip()) {
            LDAPConnection connection = this.connect();
            try {
                for (Source source : this.sources) {
                    try {
                        this.getLog().info((CharSequence)("Processing input source: " + source));
                        FormatHandler handler = this.getFormatHandler(source);
                        if (handler == null) {
                            this.getLog().warn((CharSequence)("No handler for input source: " + source));
                            continue;
                        }
                        InputStream inputStream = source.open();
                        if (inputStream == null) {
                            if (!this.continueOnError) {
                                throw new MojoExecutionException("Cannot open source for reading: " + source);
                            }
                            this.getLog().warn((CharSequence)("Skipping source that could not be opened for reading: " + source));
                            continue;
                        }
                        try {
                            handler.load((LDAPInterface)connection, source.open(), this.continueOnError, (FormatLogger)this);
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    catch (IOException e) {
                        if (!this.continueOnError) {
                            throw new MojoExecutionException("Error closing input source: " + source, (Exception)e);
                        }
                        this.getLog().warn((CharSequence)("Ignoring error closing input source: " + source), (Throwable)e);
                    }
                }
            }
            finally {
                connection.close();
            }
        }
    }

    private FormatHandler getFormatHandler(Source source) {
        if (source instanceof Dsml) {
            return this.dsmlFormatHandler;
        }
        if (source instanceof Ldif) {
            return this.ldifFormatHandler;
        }
        return null;
    }
}

