/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.maven.plugins.ldap.mojo;

import com.btmatthews.utils.monitor.mojo.AbstractRunMojo;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="run", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, configurator="include-server-dependencies")
public final class RunLDAPMojo
extends AbstractRunMojo {
    @Parameter(property="ldap.type", defaultValue="unboundid")
    private String serverType;
    @Parameter(property="ldap.authDn", defaultValue="uid=admin,ou=system")
    private String authDn;
    @Parameter(property="ldap.passwd", defaultValue="secret")
    private String passwd;
    @Parameter(property="ldap.root", required=true)
    private String rootDn;
    @Parameter(property="ldap.objectClasses", required=false)
    private String objectClasses;
    @Parameter(property="ldap.ldif", required=false)
    private File ldifFile;
    @Parameter(property="ldap.port", defaultValue="389")
    private int ldapPort;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;

    public String getServerType() {
        int index;
        if (this.serverType.startsWith("dependency-")) {
            return this.serverType.substring(11);
        }
        if (this.serverType.startsWith("gav-") && (index = this.serverType.indexOf("-", 4)) > 0) {
            return this.serverType.substring(4, index);
        }
        return this.serverType;
    }

    public Map<String, Object> getServerConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("root", this.rootDn);
        if (this.objectClasses != null) {
            config.put("objectClasses", this.objectClasses.split(","));
        }
        config.put("workingDirectory", new File(this.outputDirectory, this.serverType));
        if (this.ldifFile != null) {
            config.put("ldifFile", this.ldifFile);
        }
        config.put("ldapPort", this.ldapPort);
        config.put("authDn", this.authDn);
        config.put("passwd", this.passwd);
        return config;
    }
}

