/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.springboot.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.MemcachedClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@Configuration
public class MemcachedAutoConfiguration {
    private static final String LOCALHOST = "localhost";
    private static final int DEFAULT_PORT = 11211;
    @Autowired
    private Environment environment;

    @Bean
    public MemcachedClient memcachedClient(ObjectProvider<ConnectionFactory> connection) throws IOException {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        String servers = this.environment.getProperty("memcached.servers");
        if (StringUtils.isEmpty((Object)servers)) {
            addresses.add(new InetSocketAddress(LOCALHOST, 11211));
        } else {
            for (String server : servers.split(",")) {
                int colon = server.indexOf(":");
                if (colon == -1) {
                    addresses.add(new InetSocketAddress(server, 11211));
                    continue;
                }
                int port = Integer.parseInt(server.substring(colon + 1));
                addresses.add(new InetSocketAddress(server.substring(0, colon), port));
            }
        }
        ConnectionFactory con = (ConnectionFactory)connection.getIfUnique();
        return con == null ? new MemcachedClient(addresses) : new MemcachedClient(con, addresses);
    }
}

