/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.utils.monitor;

import com.btmatthews.utils.monitor.Logger;
import com.btmatthews.utils.monitor.ServerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public final class ServerFactoryLocator {
    private static ServerFactoryLocator instance;
    private final Map<String, ServerFactory> serverFactoryMapping = new HashMap<String, ServerFactory>();

    public ServerFactoryLocator(Logger logger, ClassLoader classLoader) {
        ServiceLoader<ServerFactory> loader = ServiceLoader.load(ServerFactory.class, classLoader);
        for (ServerFactory serverFactory : loader) {
            this.serverFactoryMapping.put(serverFactory.getServerName(), serverFactory);
        }
    }

    public static ServerFactoryLocator getInstance(Logger logger) {
        return ServerFactoryLocator.getInstance(logger, ServerFactoryLocator.class.getClassLoader());
    }

    public static ServerFactoryLocator getInstance(Logger logger, ClassLoader classLoader) {
        if (instance == null) {
            instance = new ServerFactoryLocator(logger, classLoader);
        }
        return instance;
    }

    public ServerFactory getFactory(String serverName) {
        return this.serverFactoryMapping.get(serverName);
    }
}

