/*
 * Decompiled with CFR 0.152.
 */
package com.buabook.common;

import com.google.common.base.Strings;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public final class Objects {
    public static <T> T convertStringToClass(String theString, Class<T> targetType) throws IllegalArgumentException {
        if (Strings.isNullOrEmpty((String)theString)) {
            throw new IllegalArgumentException("No string to convert");
        }
        if (targetType == null) {
            throw new IllegalArgumentException("No class to convert to");
        }
        T newClassInstance = null;
        try {
            newClassInstance = targetType.getConstructor(String.class).newInstance(theString);
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return null;
        }
        return newClassInstance;
    }

    public static Map<String, Object> getObjectFieldsAsMap(Object object) {
        HashMap<String, Object> fieldsMap = new HashMap<String, Object>();
        if (object == null) {
            return fieldsMap;
        }
        Field[] objFields = object.getClass().getDeclaredFields();
        if (objFields.length == 0) {
            return fieldsMap;
        }
        for (Field objField : objFields) {
            boolean isPublic = objField.isAccessible();
            if (!isPublic) {
                objField.setAccessible(true);
            }
            try {
                fieldsMap.put(objField.getName(), objField.get(object));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                fieldsMap.put(objField.getName(), null);
            }
            if (isPublic) continue;
            objField.setAccessible(false);
        }
        return fieldsMap;
    }
}

