/*
 * Decompiled with CFR 0.152.
 */
package com.buabook.common;

import com.google.common.base.Strings;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public final class Systems {
    public static File getApplicationRoot(Class<?> bootClass) throws IllegalArgumentException {
        if (bootClass == null) {
            throw new IllegalArgumentException("No boot class specified");
        }
        String projectRoot = bootClass.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (projectRoot.endsWith(".jar") || projectRoot.endsWith(".class")) {
            projectRoot = projectRoot.substring(0, projectRoot.lastIndexOf("/"));
        }
        String decodedProjectRoot = null;
        try {
            decodedProjectRoot = URLDecoder.decode(projectRoot, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return new File(decodedProjectRoot);
    }

    public static String getConfig(String envPropName) throws IllegalArgumentException {
        if (Strings.isNullOrEmpty((String)envPropName)) {
            throw new IllegalArgumentException("No property to check");
        }
        String configValue = System.getenv(envPropName);
        if (Strings.isNullOrEmpty((String)configValue)) {
            configValue = System.getProperty(envPropName);
        }
        if (Strings.isNullOrEmpty((String)configValue)) {
            throw new IllegalArgumentException("Property '" + envPropName + "' does not exist");
        }
        return configValue;
    }
}

