/*
 * Decompiled with CFR 0.152.
 */
package com.buabook.common.connection;

import com.google.common.base.Strings;

public class Process {
    private final String hostname;
    private final Integer port;

    public Process(String hostname, Integer port) {
        this.hostname = hostname;
        this.port = port;
    }

    public Process(String hostname, String portStr) throws NumberFormatException {
        this.hostname = hostname;
        this.port = Integer.parseInt(portStr);
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public String toString() {
        if (Strings.isNullOrEmpty((String)this.hostname)) {
            return "::" + this.port;
        }
        return this.hostname + ":" + this.port;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Process)) {
            return false;
        }
        Process other = (Process)obj;
        if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
            return false;
        }
        return !(this.port == null ? other.port != null : !this.port.equals(other.port));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        return result;
    }
}

