/*
 * Decompiled with CFR 0.152.
 */
package com.buabook.common.net;

import com.buabook.common.net.exceptions.DataSocketFailedToInitialiseException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSocket {
    private static final Logger log = LoggerFactory.getLogger(DataSocket.class);
    private final InetSocketAddress remoteSocketAddress;
    private Socket socket;
    private DataInputStream receiveStream;
    private DataOutputStream sendStream;

    public DataSocket(Socket socket) throws DataSocketFailedToInitialiseException {
        if (socket == null) {
            throw new DataSocketFailedToInitialiseException(new NullPointerException("socket"));
        }
        this.socket = socket;
        this.remoteSocketAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
        this.initialiseIOStreams();
        log.info("New connection on socket: {}", (Object)this.remoteSocketAddress);
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.remoteSocketAddress;
    }

    public DataInputStream getReceiveStream() {
        return this.receiveStream;
    }

    public DataOutputStream getSendStream() {
        return this.sendStream;
    }

    public Boolean isClosed() {
        if (this.socket == null) {
            return true;
        }
        return this.socket.isClosed();
    }

    public void disconnect() {
        if (this.socket == null) {
            return;
        }
        log.warn("Disconnecting socket connection [ Remote: {} ]", (Object)this.remoteSocketAddress);
        try {
            this.sendStream.close();
            this.receiveStream.close();
            this.socket.close();
        }
        catch (IOException e) {
            log.debug("Failed to close to socket [ Remote: {} ]. Error - {}", (Object)this.remoteSocketAddress, (Object)e.getMessage());
        }
        this.socket = null;
    }

    public synchronized void reconnect() throws DataSocketFailedToInitialiseException {
        if (!this.isClosed().booleanValue()) {
            return;
        }
        log.info("Attempting socket reconnection [ Remote: {} ]", (Object)this.remoteSocketAddress);
        try {
            this.socket = new Socket(this.remoteSocketAddress.getAddress(), this.remoteSocketAddress.getPort());
            this.socket.setKeepAlive(true);
        }
        catch (IOException e) {
            log.error("Failed to create new socket for reconnection! Error - {}", (Object)e.getMessage());
            throw new DataSocketFailedToInitialiseException(e);
        }
        this.initialiseIOStreams();
        log.info("Reconnection successful! [ Remote: {} ]", (Object)this.remoteSocketAddress);
    }

    private void initialiseIOStreams() throws DataSocketFailedToInitialiseException {
        try {
            this.receiveStream = new DataInputStream(this.socket.getInputStream());
            this.sendStream = new DataOutputStream(this.socket.getOutputStream());
        }
        catch (IOException e) {
            log.error("Failed to create DataInputStream / DataOutputStream's for socket {}. Error - {}", (Object)this.remoteSocketAddress, (Object)e.getMessage());
            throw new DataSocketFailedToInitialiseException(e);
        }
    }
}

